#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#define N 10000000
void saxpy(int n, float alpha, float * X, float * Y) {
  const float * restrict x = __builtin_assume_aligned (X, 32);
  float * restrict y = __builtin_assume_aligned (Y, 32);
  for (int i=0; i<n; i++) 
    Y[i] = alpha*X[i] + Y[i]; 
}

int main() {
  float *x = (float*)malloc(N*sizeof(float));
  float *y = (float*)malloc(N*sizeof(float));
  float alpha = 2.0f;
  double t1 = omp_get_wtime();
  saxpy(N,alpha,x,y);
  double t2 = omp_get_wtime();
  printf("Time %g val %g\n",t2-t1,y[N/2]);
  return 1;
}

