// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2017.4
// Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
// 
// ==============================================================

`timescale 1ns/1ps
module apint_arith_AXILiteS_s_axi
#(parameter
    C_S_AXI_ADDR_WIDTH = 9,
    C_S_AXI_DATA_WIDTH = 32
)(
    // axi4 lite slave signals
    input  wire                          ACLK,
    input  wire                          ARESET,
    input  wire                          ACLK_EN,
    input  wire [C_S_AXI_ADDR_WIDTH-1:0] AWADDR,
    input  wire                          AWVALID,
    output wire                          AWREADY,
    input  wire [C_S_AXI_DATA_WIDTH-1:0] WDATA,
    input  wire [C_S_AXI_DATA_WIDTH/8-1:0] WSTRB,
    input  wire                          WVALID,
    output wire                          WREADY,
    output wire [1:0]                    BRESP,
    output wire                          BVALID,
    input  wire                          BREADY,
    input  wire [C_S_AXI_ADDR_WIDTH-1:0] ARADDR,
    input  wire                          ARVALID,
    output wire                          ARREADY,
    output wire [C_S_AXI_DATA_WIDTH-1:0] RDATA,
    output wire [1:0]                    RRESP,
    output wire                          RVALID,
    input  wire                          RREADY,
    output wire                          interrupt,
    // user signals
    output wire                          ap_start,
    input  wire                          ap_done,
    input  wire                          ap_ready,
    input  wire                          ap_idle,
    output wire [511:0]                  inA_V,
    output wire [511:0]                  inB_V,
    output wire [1022:0]                 inC_V,
    output wire [1022:0]                 inD_V
);
//------------------------Address Info-------------------
// 0x000 : Control signals
//         bit 0  - ap_start (Read/Write/COH)
//         bit 1  - ap_done (Read/COR)
//         bit 2  - ap_idle (Read)
//         bit 3  - ap_ready (Read)
//         bit 7  - auto_restart (Read/Write)
//         others - reserved
// 0x004 : Global Interrupt Enable Register
//         bit 0  - Global Interrupt Enable (Read/Write)
//         others - reserved
// 0x008 : IP Interrupt Enable Register (Read/Write)
//         bit 0  - Channel 0 (ap_done)
//         bit 1  - Channel 1 (ap_ready)
//         others - reserved
// 0x00c : IP Interrupt Status Register (Read/TOW)
//         bit 0  - Channel 0 (ap_done)
//         bit 1  - Channel 1 (ap_ready)
//         others - reserved
// 0x010 : Data signal of inA_V
//         bit 31~0 - inA_V[31:0] (Read/Write)
// 0x014 : Data signal of inA_V
//         bit 31~0 - inA_V[63:32] (Read/Write)
// 0x018 : Data signal of inA_V
//         bit 31~0 - inA_V[95:64] (Read/Write)
// 0x01c : Data signal of inA_V
//         bit 31~0 - inA_V[127:96] (Read/Write)
// 0x020 : Data signal of inA_V
//         bit 31~0 - inA_V[159:128] (Read/Write)
// 0x024 : Data signal of inA_V
//         bit 31~0 - inA_V[191:160] (Read/Write)
// 0x028 : Data signal of inA_V
//         bit 31~0 - inA_V[223:192] (Read/Write)
// 0x02c : Data signal of inA_V
//         bit 31~0 - inA_V[255:224] (Read/Write)
// 0x030 : Data signal of inA_V
//         bit 31~0 - inA_V[287:256] (Read/Write)
// 0x034 : Data signal of inA_V
//         bit 31~0 - inA_V[319:288] (Read/Write)
// 0x038 : Data signal of inA_V
//         bit 31~0 - inA_V[351:320] (Read/Write)
// 0x03c : Data signal of inA_V
//         bit 31~0 - inA_V[383:352] (Read/Write)
// 0x040 : Data signal of inA_V
//         bit 31~0 - inA_V[415:384] (Read/Write)
// 0x044 : Data signal of inA_V
//         bit 31~0 - inA_V[447:416] (Read/Write)
// 0x048 : Data signal of inA_V
//         bit 31~0 - inA_V[479:448] (Read/Write)
// 0x04c : Data signal of inA_V
//         bit 31~0 - inA_V[511:480] (Read/Write)
// 0x050 : reserved
// 0x054 : Data signal of inB_V
//         bit 31~0 - inB_V[31:0] (Read/Write)
// 0x058 : Data signal of inB_V
//         bit 31~0 - inB_V[63:32] (Read/Write)
// 0x05c : Data signal of inB_V
//         bit 31~0 - inB_V[95:64] (Read/Write)
// 0x060 : Data signal of inB_V
//         bit 31~0 - inB_V[127:96] (Read/Write)
// 0x064 : Data signal of inB_V
//         bit 31~0 - inB_V[159:128] (Read/Write)
// 0x068 : Data signal of inB_V
//         bit 31~0 - inB_V[191:160] (Read/Write)
// 0x06c : Data signal of inB_V
//         bit 31~0 - inB_V[223:192] (Read/Write)
// 0x070 : Data signal of inB_V
//         bit 31~0 - inB_V[255:224] (Read/Write)
// 0x074 : Data signal of inB_V
//         bit 31~0 - inB_V[287:256] (Read/Write)
// 0x078 : Data signal of inB_V
//         bit 31~0 - inB_V[319:288] (Read/Write)
// 0x07c : Data signal of inB_V
//         bit 31~0 - inB_V[351:320] (Read/Write)
// 0x080 : Data signal of inB_V
//         bit 31~0 - inB_V[383:352] (Read/Write)
// 0x084 : Data signal of inB_V
//         bit 31~0 - inB_V[415:384] (Read/Write)
// 0x088 : Data signal of inB_V
//         bit 31~0 - inB_V[447:416] (Read/Write)
// 0x08c : Data signal of inB_V
//         bit 31~0 - inB_V[479:448] (Read/Write)
// 0x090 : Data signal of inB_V
//         bit 31~0 - inB_V[511:480] (Read/Write)
// 0x094 : reserved
// 0x098 : Data signal of inC_V
//         bit 31~0 - inC_V[31:0] (Read/Write)
// 0x09c : Data signal of inC_V
//         bit 31~0 - inC_V[63:32] (Read/Write)
// 0x0a0 : Data signal of inC_V
//         bit 31~0 - inC_V[95:64] (Read/Write)
// 0x0a4 : Data signal of inC_V
//         bit 31~0 - inC_V[127:96] (Read/Write)
// 0x0a8 : Data signal of inC_V
//         bit 31~0 - inC_V[159:128] (Read/Write)
// 0x0ac : Data signal of inC_V
//         bit 31~0 - inC_V[191:160] (Read/Write)
// 0x0b0 : Data signal of inC_V
//         bit 31~0 - inC_V[223:192] (Read/Write)
// 0x0b4 : Data signal of inC_V
//         bit 31~0 - inC_V[255:224] (Read/Write)
// 0x0b8 : Data signal of inC_V
//         bit 31~0 - inC_V[287:256] (Read/Write)
// 0x0bc : Data signal of inC_V
//         bit 31~0 - inC_V[319:288] (Read/Write)
// 0x0c0 : Data signal of inC_V
//         bit 31~0 - inC_V[351:320] (Read/Write)
// 0x0c4 : Data signal of inC_V
//         bit 31~0 - inC_V[383:352] (Read/Write)
// 0x0c8 : Data signal of inC_V
//         bit 31~0 - inC_V[415:384] (Read/Write)
// 0x0cc : Data signal of inC_V
//         bit 31~0 - inC_V[447:416] (Read/Write)
// 0x0d0 : Data signal of inC_V
//         bit 31~0 - inC_V[479:448] (Read/Write)
// 0x0d4 : Data signal of inC_V
//         bit 31~0 - inC_V[511:480] (Read/Write)
// 0x0d8 : Data signal of inC_V
//         bit 31~0 - inC_V[543:512] (Read/Write)
// 0x0dc : Data signal of inC_V
//         bit 31~0 - inC_V[575:544] (Read/Write)
// 0x0e0 : Data signal of inC_V
//         bit 31~0 - inC_V[607:576] (Read/Write)
// 0x0e4 : Data signal of inC_V
//         bit 31~0 - inC_V[639:608] (Read/Write)
// 0x0e8 : Data signal of inC_V
//         bit 31~0 - inC_V[671:640] (Read/Write)
// 0x0ec : Data signal of inC_V
//         bit 31~0 - inC_V[703:672] (Read/Write)
// 0x0f0 : Data signal of inC_V
//         bit 31~0 - inC_V[735:704] (Read/Write)
// 0x0f4 : Data signal of inC_V
//         bit 31~0 - inC_V[767:736] (Read/Write)
// 0x0f8 : Data signal of inC_V
//         bit 31~0 - inC_V[799:768] (Read/Write)
// 0x0fc : Data signal of inC_V
//         bit 31~0 - inC_V[831:800] (Read/Write)
// 0x100 : Data signal of inC_V
//         bit 31~0 - inC_V[863:832] (Read/Write)
// 0x104 : Data signal of inC_V
//         bit 31~0 - inC_V[895:864] (Read/Write)
// 0x108 : Data signal of inC_V
//         bit 31~0 - inC_V[927:896] (Read/Write)
// 0x10c : Data signal of inC_V
//         bit 31~0 - inC_V[959:928] (Read/Write)
// 0x110 : Data signal of inC_V
//         bit 31~0 - inC_V[991:960] (Read/Write)
// 0x114 : Data signal of inC_V
//         bit 30~0 - inC_V[1022:992] (Read/Write)
//         others   - reserved
// 0x118 : reserved
// 0x11c : Data signal of inD_V
//         bit 31~0 - inD_V[31:0] (Read/Write)
// 0x120 : Data signal of inD_V
//         bit 31~0 - inD_V[63:32] (Read/Write)
// 0x124 : Data signal of inD_V
//         bit 31~0 - inD_V[95:64] (Read/Write)
// 0x128 : Data signal of inD_V
//         bit 31~0 - inD_V[127:96] (Read/Write)
// 0x12c : Data signal of inD_V
//         bit 31~0 - inD_V[159:128] (Read/Write)
// 0x130 : Data signal of inD_V
//         bit 31~0 - inD_V[191:160] (Read/Write)
// 0x134 : Data signal of inD_V
//         bit 31~0 - inD_V[223:192] (Read/Write)
// 0x138 : Data signal of inD_V
//         bit 31~0 - inD_V[255:224] (Read/Write)
// 0x13c : Data signal of inD_V
//         bit 31~0 - inD_V[287:256] (Read/Write)
// 0x140 : Data signal of inD_V
//         bit 31~0 - inD_V[319:288] (Read/Write)
// 0x144 : Data signal of inD_V
//         bit 31~0 - inD_V[351:320] (Read/Write)
// 0x148 : Data signal of inD_V
//         bit 31~0 - inD_V[383:352] (Read/Write)
// 0x14c : Data signal of inD_V
//         bit 31~0 - inD_V[415:384] (Read/Write)
// 0x150 : Data signal of inD_V
//         bit 31~0 - inD_V[447:416] (Read/Write)
// 0x154 : Data signal of inD_V
//         bit 31~0 - inD_V[479:448] (Read/Write)
// 0x158 : Data signal of inD_V
//         bit 31~0 - inD_V[511:480] (Read/Write)
// 0x15c : Data signal of inD_V
//         bit 31~0 - inD_V[543:512] (Read/Write)
// 0x160 : Data signal of inD_V
//         bit 31~0 - inD_V[575:544] (Read/Write)
// 0x164 : Data signal of inD_V
//         bit 31~0 - inD_V[607:576] (Read/Write)
// 0x168 : Data signal of inD_V
//         bit 31~0 - inD_V[639:608] (Read/Write)
// 0x16c : Data signal of inD_V
//         bit 31~0 - inD_V[671:640] (Read/Write)
// 0x170 : Data signal of inD_V
//         bit 31~0 - inD_V[703:672] (Read/Write)
// 0x174 : Data signal of inD_V
//         bit 31~0 - inD_V[735:704] (Read/Write)
// 0x178 : Data signal of inD_V
//         bit 31~0 - inD_V[767:736] (Read/Write)
// 0x17c : Data signal of inD_V
//         bit 31~0 - inD_V[799:768] (Read/Write)
// 0x180 : Data signal of inD_V
//         bit 31~0 - inD_V[831:800] (Read/Write)
// 0x184 : Data signal of inD_V
//         bit 31~0 - inD_V[863:832] (Read/Write)
// 0x188 : Data signal of inD_V
//         bit 31~0 - inD_V[895:864] (Read/Write)
// 0x18c : Data signal of inD_V
//         bit 31~0 - inD_V[927:896] (Read/Write)
// 0x190 : Data signal of inD_V
//         bit 31~0 - inD_V[959:928] (Read/Write)
// 0x194 : Data signal of inD_V
//         bit 31~0 - inD_V[991:960] (Read/Write)
// 0x198 : Data signal of inD_V
//         bit 30~0 - inD_V[1022:992] (Read/Write)
//         others   - reserved
// 0x19c : reserved
// (SC = Self Clear, COR = Clear on Read, TOW = Toggle on Write, COH = Clear on Handshake)

//------------------------Parameter----------------------
localparam
    ADDR_AP_CTRL       = 9'h000,
    ADDR_GIE           = 9'h004,
    ADDR_IER           = 9'h008,
    ADDR_ISR           = 9'h00c,
    ADDR_INA_V_DATA_0  = 9'h010,
    ADDR_INA_V_DATA_1  = 9'h014,
    ADDR_INA_V_DATA_2  = 9'h018,
    ADDR_INA_V_DATA_3  = 9'h01c,
    ADDR_INA_V_DATA_4  = 9'h020,
    ADDR_INA_V_DATA_5  = 9'h024,
    ADDR_INA_V_DATA_6  = 9'h028,
    ADDR_INA_V_DATA_7  = 9'h02c,
    ADDR_INA_V_DATA_8  = 9'h030,
    ADDR_INA_V_DATA_9  = 9'h034,
    ADDR_INA_V_DATA_10 = 9'h038,
    ADDR_INA_V_DATA_11 = 9'h03c,
    ADDR_INA_V_DATA_12 = 9'h040,
    ADDR_INA_V_DATA_13 = 9'h044,
    ADDR_INA_V_DATA_14 = 9'h048,
    ADDR_INA_V_DATA_15 = 9'h04c,
    ADDR_INA_V_CTRL    = 9'h050,
    ADDR_INB_V_DATA_0  = 9'h054,
    ADDR_INB_V_DATA_1  = 9'h058,
    ADDR_INB_V_DATA_2  = 9'h05c,
    ADDR_INB_V_DATA_3  = 9'h060,
    ADDR_INB_V_DATA_4  = 9'h064,
    ADDR_INB_V_DATA_5  = 9'h068,
    ADDR_INB_V_DATA_6  = 9'h06c,
    ADDR_INB_V_DATA_7  = 9'h070,
    ADDR_INB_V_DATA_8  = 9'h074,
    ADDR_INB_V_DATA_9  = 9'h078,
    ADDR_INB_V_DATA_10 = 9'h07c,
    ADDR_INB_V_DATA_11 = 9'h080,
    ADDR_INB_V_DATA_12 = 9'h084,
    ADDR_INB_V_DATA_13 = 9'h088,
    ADDR_INB_V_DATA_14 = 9'h08c,
    ADDR_INB_V_DATA_15 = 9'h090,
    ADDR_INB_V_CTRL    = 9'h094,
    ADDR_INC_V_DATA_0  = 9'h098,
    ADDR_INC_V_DATA_1  = 9'h09c,
    ADDR_INC_V_DATA_2  = 9'h0a0,
    ADDR_INC_V_DATA_3  = 9'h0a4,
    ADDR_INC_V_DATA_4  = 9'h0a8,
    ADDR_INC_V_DATA_5  = 9'h0ac,
    ADDR_INC_V_DATA_6  = 9'h0b0,
    ADDR_INC_V_DATA_7  = 9'h0b4,
    ADDR_INC_V_DATA_8  = 9'h0b8,
    ADDR_INC_V_DATA_9  = 9'h0bc,
    ADDR_INC_V_DATA_10 = 9'h0c0,
    ADDR_INC_V_DATA_11 = 9'h0c4,
    ADDR_INC_V_DATA_12 = 9'h0c8,
    ADDR_INC_V_DATA_13 = 9'h0cc,
    ADDR_INC_V_DATA_14 = 9'h0d0,
    ADDR_INC_V_DATA_15 = 9'h0d4,
    ADDR_INC_V_DATA_16 = 9'h0d8,
    ADDR_INC_V_DATA_17 = 9'h0dc,
    ADDR_INC_V_DATA_18 = 9'h0e0,
    ADDR_INC_V_DATA_19 = 9'h0e4,
    ADDR_INC_V_DATA_20 = 9'h0e8,
    ADDR_INC_V_DATA_21 = 9'h0ec,
    ADDR_INC_V_DATA_22 = 9'h0f0,
    ADDR_INC_V_DATA_23 = 9'h0f4,
    ADDR_INC_V_DATA_24 = 9'h0f8,
    ADDR_INC_V_DATA_25 = 9'h0fc,
    ADDR_INC_V_DATA_26 = 9'h100,
    ADDR_INC_V_DATA_27 = 9'h104,
    ADDR_INC_V_DATA_28 = 9'h108,
    ADDR_INC_V_DATA_29 = 9'h10c,
    ADDR_INC_V_DATA_30 = 9'h110,
    ADDR_INC_V_DATA_31 = 9'h114,
    ADDR_INC_V_CTRL    = 9'h118,
    ADDR_IND_V_DATA_0  = 9'h11c,
    ADDR_IND_V_DATA_1  = 9'h120,
    ADDR_IND_V_DATA_2  = 9'h124,
    ADDR_IND_V_DATA_3  = 9'h128,
    ADDR_IND_V_DATA_4  = 9'h12c,
    ADDR_IND_V_DATA_5  = 9'h130,
    ADDR_IND_V_DATA_6  = 9'h134,
    ADDR_IND_V_DATA_7  = 9'h138,
    ADDR_IND_V_DATA_8  = 9'h13c,
    ADDR_IND_V_DATA_9  = 9'h140,
    ADDR_IND_V_DATA_10 = 9'h144,
    ADDR_IND_V_DATA_11 = 9'h148,
    ADDR_IND_V_DATA_12 = 9'h14c,
    ADDR_IND_V_DATA_13 = 9'h150,
    ADDR_IND_V_DATA_14 = 9'h154,
    ADDR_IND_V_DATA_15 = 9'h158,
    ADDR_IND_V_DATA_16 = 9'h15c,
    ADDR_IND_V_DATA_17 = 9'h160,
    ADDR_IND_V_DATA_18 = 9'h164,
    ADDR_IND_V_DATA_19 = 9'h168,
    ADDR_IND_V_DATA_20 = 9'h16c,
    ADDR_IND_V_DATA_21 = 9'h170,
    ADDR_IND_V_DATA_22 = 9'h174,
    ADDR_IND_V_DATA_23 = 9'h178,
    ADDR_IND_V_DATA_24 = 9'h17c,
    ADDR_IND_V_DATA_25 = 9'h180,
    ADDR_IND_V_DATA_26 = 9'h184,
    ADDR_IND_V_DATA_27 = 9'h188,
    ADDR_IND_V_DATA_28 = 9'h18c,
    ADDR_IND_V_DATA_29 = 9'h190,
    ADDR_IND_V_DATA_30 = 9'h194,
    ADDR_IND_V_DATA_31 = 9'h198,
    ADDR_IND_V_CTRL    = 9'h19c,
    WRIDLE             = 2'd0,
    WRDATA             = 2'd1,
    WRRESP             = 2'd2,
    WRRESET            = 2'd3,
    RDIDLE             = 2'd0,
    RDDATA             = 2'd1,
    RDRESET            = 2'd2,
    ADDR_BITS         = 9;

//------------------------Local signal-------------------
    reg  [1:0]                    wstate = WRRESET;
    reg  [1:0]                    wnext;
    reg  [ADDR_BITS-1:0]          waddr;
    wire [31:0]                   wmask;
    wire                          aw_hs;
    wire                          w_hs;
    reg  [1:0]                    rstate = RDRESET;
    reg  [1:0]                    rnext;
    reg  [31:0]                   rdata;
    wire                          ar_hs;
    wire [ADDR_BITS-1:0]          raddr;
    // internal registers
    reg                           int_ap_idle;
    reg                           int_ap_ready;
    reg                           int_ap_done = 1'b0;
    reg                           int_ap_start = 1'b0;
    reg                           int_auto_restart = 1'b0;
    reg                           int_gie = 1'b0;
    reg  [1:0]                    int_ier = 2'b0;
    reg  [1:0]                    int_isr = 2'b0;
    reg  [511:0]                  int_inA_V = 'b0;
    reg  [511:0]                  int_inB_V = 'b0;
    reg  [1022:0]                 int_inC_V = 'b0;
    reg  [1022:0]                 int_inD_V = 'b0;

//------------------------Instantiation------------------

//------------------------AXI write fsm------------------
assign AWREADY = (wstate == WRIDLE);
assign WREADY  = (wstate == WRDATA);
assign BRESP   = 2'b00;  // OKAY
assign BVALID  = (wstate == WRRESP);
assign wmask   = { {8{WSTRB[3]}}, {8{WSTRB[2]}}, {8{WSTRB[1]}}, {8{WSTRB[0]}} };
assign aw_hs   = AWVALID & AWREADY;
assign w_hs    = WVALID & WREADY;

// wstate
always @(posedge ACLK) begin
    if (ARESET)
        wstate <= WRRESET;
    else if (ACLK_EN)
        wstate <= wnext;
end

// wnext
always @(*) begin
    case (wstate)
        WRIDLE:
            if (AWVALID)
                wnext = WRDATA;
            else
                wnext = WRIDLE;
        WRDATA:
            if (WVALID)
                wnext = WRRESP;
            else
                wnext = WRDATA;
        WRRESP:
            if (BREADY)
                wnext = WRIDLE;
            else
                wnext = WRRESP;
        default:
            wnext = WRIDLE;
    endcase
end

// waddr
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (aw_hs)
            waddr <= AWADDR[ADDR_BITS-1:0];
    end
end

//------------------------AXI read fsm-------------------
assign ARREADY = (rstate == RDIDLE);
assign RDATA   = rdata;
assign RRESP   = 2'b00;  // OKAY
assign RVALID  = (rstate == RDDATA);
assign ar_hs   = ARVALID & ARREADY;
assign raddr   = ARADDR[ADDR_BITS-1:0];

// rstate
always @(posedge ACLK) begin
    if (ARESET)
        rstate <= RDRESET;
    else if (ACLK_EN)
        rstate <= rnext;
end

// rnext
always @(*) begin
    case (rstate)
        RDIDLE:
            if (ARVALID)
                rnext = RDDATA;
            else
                rnext = RDIDLE;
        RDDATA:
            if (RREADY & RVALID)
                rnext = RDIDLE;
            else
                rnext = RDDATA;
        default:
            rnext = RDIDLE;
    endcase
end

// rdata
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (ar_hs) begin
            rdata <= 1'b0;
            case (raddr)
                ADDR_AP_CTRL: begin
                    rdata[0] <= int_ap_start;
                    rdata[1] <= int_ap_done;
                    rdata[2] <= int_ap_idle;
                    rdata[3] <= int_ap_ready;
                    rdata[7] <= int_auto_restart;
                end
                ADDR_GIE: begin
                    rdata <= int_gie;
                end
                ADDR_IER: begin
                    rdata <= int_ier;
                end
                ADDR_ISR: begin
                    rdata <= int_isr;
                end
                ADDR_INA_V_DATA_0: begin
                    rdata <= int_inA_V[31:0];
                end
                ADDR_INA_V_DATA_1: begin
                    rdata <= int_inA_V[63:32];
                end
                ADDR_INA_V_DATA_2: begin
                    rdata <= int_inA_V[95:64];
                end
                ADDR_INA_V_DATA_3: begin
                    rdata <= int_inA_V[127:96];
                end
                ADDR_INA_V_DATA_4: begin
                    rdata <= int_inA_V[159:128];
                end
                ADDR_INA_V_DATA_5: begin
                    rdata <= int_inA_V[191:160];
                end
                ADDR_INA_V_DATA_6: begin
                    rdata <= int_inA_V[223:192];
                end
                ADDR_INA_V_DATA_7: begin
                    rdata <= int_inA_V[255:224];
                end
                ADDR_INA_V_DATA_8: begin
                    rdata <= int_inA_V[287:256];
                end
                ADDR_INA_V_DATA_9: begin
                    rdata <= int_inA_V[319:288];
                end
                ADDR_INA_V_DATA_10: begin
                    rdata <= int_inA_V[351:320];
                end
                ADDR_INA_V_DATA_11: begin
                    rdata <= int_inA_V[383:352];
                end
                ADDR_INA_V_DATA_12: begin
                    rdata <= int_inA_V[415:384];
                end
                ADDR_INA_V_DATA_13: begin
                    rdata <= int_inA_V[447:416];
                end
                ADDR_INA_V_DATA_14: begin
                    rdata <= int_inA_V[479:448];
                end
                ADDR_INA_V_DATA_15: begin
                    rdata <= int_inA_V[511:480];
                end
                ADDR_INB_V_DATA_0: begin
                    rdata <= int_inB_V[31:0];
                end
                ADDR_INB_V_DATA_1: begin
                    rdata <= int_inB_V[63:32];
                end
                ADDR_INB_V_DATA_2: begin
                    rdata <= int_inB_V[95:64];
                end
                ADDR_INB_V_DATA_3: begin
                    rdata <= int_inB_V[127:96];
                end
                ADDR_INB_V_DATA_4: begin
                    rdata <= int_inB_V[159:128];
                end
                ADDR_INB_V_DATA_5: begin
                    rdata <= int_inB_V[191:160];
                end
                ADDR_INB_V_DATA_6: begin
                    rdata <= int_inB_V[223:192];
                end
                ADDR_INB_V_DATA_7: begin
                    rdata <= int_inB_V[255:224];
                end
                ADDR_INB_V_DATA_8: begin
                    rdata <= int_inB_V[287:256];
                end
                ADDR_INB_V_DATA_9: begin
                    rdata <= int_inB_V[319:288];
                end
                ADDR_INB_V_DATA_10: begin
                    rdata <= int_inB_V[351:320];
                end
                ADDR_INB_V_DATA_11: begin
                    rdata <= int_inB_V[383:352];
                end
                ADDR_INB_V_DATA_12: begin
                    rdata <= int_inB_V[415:384];
                end
                ADDR_INB_V_DATA_13: begin
                    rdata <= int_inB_V[447:416];
                end
                ADDR_INB_V_DATA_14: begin
                    rdata <= int_inB_V[479:448];
                end
                ADDR_INB_V_DATA_15: begin
                    rdata <= int_inB_V[511:480];
                end
                ADDR_INC_V_DATA_0: begin
                    rdata <= int_inC_V[31:0];
                end
                ADDR_INC_V_DATA_1: begin
                    rdata <= int_inC_V[63:32];
                end
                ADDR_INC_V_DATA_2: begin
                    rdata <= int_inC_V[95:64];
                end
                ADDR_INC_V_DATA_3: begin
                    rdata <= int_inC_V[127:96];
                end
                ADDR_INC_V_DATA_4: begin
                    rdata <= int_inC_V[159:128];
                end
                ADDR_INC_V_DATA_5: begin
                    rdata <= int_inC_V[191:160];
                end
                ADDR_INC_V_DATA_6: begin
                    rdata <= int_inC_V[223:192];
                end
                ADDR_INC_V_DATA_7: begin
                    rdata <= int_inC_V[255:224];
                end
                ADDR_INC_V_DATA_8: begin
                    rdata <= int_inC_V[287:256];
                end
                ADDR_INC_V_DATA_9: begin
                    rdata <= int_inC_V[319:288];
                end
                ADDR_INC_V_DATA_10: begin
                    rdata <= int_inC_V[351:320];
                end
                ADDR_INC_V_DATA_11: begin
                    rdata <= int_inC_V[383:352];
                end
                ADDR_INC_V_DATA_12: begin
                    rdata <= int_inC_V[415:384];
                end
                ADDR_INC_V_DATA_13: begin
                    rdata <= int_inC_V[447:416];
                end
                ADDR_INC_V_DATA_14: begin
                    rdata <= int_inC_V[479:448];
                end
                ADDR_INC_V_DATA_15: begin
                    rdata <= int_inC_V[511:480];
                end
                ADDR_INC_V_DATA_16: begin
                    rdata <= int_inC_V[543:512];
                end
                ADDR_INC_V_DATA_17: begin
                    rdata <= int_inC_V[575:544];
                end
                ADDR_INC_V_DATA_18: begin
                    rdata <= int_inC_V[607:576];
                end
                ADDR_INC_V_DATA_19: begin
                    rdata <= int_inC_V[639:608];
                end
                ADDR_INC_V_DATA_20: begin
                    rdata <= int_inC_V[671:640];
                end
                ADDR_INC_V_DATA_21: begin
                    rdata <= int_inC_V[703:672];
                end
                ADDR_INC_V_DATA_22: begin
                    rdata <= int_inC_V[735:704];
                end
                ADDR_INC_V_DATA_23: begin
                    rdata <= int_inC_V[767:736];
                end
                ADDR_INC_V_DATA_24: begin
                    rdata <= int_inC_V[799:768];
                end
                ADDR_INC_V_DATA_25: begin
                    rdata <= int_inC_V[831:800];
                end
                ADDR_INC_V_DATA_26: begin
                    rdata <= int_inC_V[863:832];
                end
                ADDR_INC_V_DATA_27: begin
                    rdata <= int_inC_V[895:864];
                end
                ADDR_INC_V_DATA_28: begin
                    rdata <= int_inC_V[927:896];
                end
                ADDR_INC_V_DATA_29: begin
                    rdata <= int_inC_V[959:928];
                end
                ADDR_INC_V_DATA_30: begin
                    rdata <= int_inC_V[991:960];
                end
                ADDR_INC_V_DATA_31: begin
                    rdata <= int_inC_V[1022:992];
                end
                ADDR_IND_V_DATA_0: begin
                    rdata <= int_inD_V[31:0];
                end
                ADDR_IND_V_DATA_1: begin
                    rdata <= int_inD_V[63:32];
                end
                ADDR_IND_V_DATA_2: begin
                    rdata <= int_inD_V[95:64];
                end
                ADDR_IND_V_DATA_3: begin
                    rdata <= int_inD_V[127:96];
                end
                ADDR_IND_V_DATA_4: begin
                    rdata <= int_inD_V[159:128];
                end
                ADDR_IND_V_DATA_5: begin
                    rdata <= int_inD_V[191:160];
                end
                ADDR_IND_V_DATA_6: begin
                    rdata <= int_inD_V[223:192];
                end
                ADDR_IND_V_DATA_7: begin
                    rdata <= int_inD_V[255:224];
                end
                ADDR_IND_V_DATA_8: begin
                    rdata <= int_inD_V[287:256];
                end
                ADDR_IND_V_DATA_9: begin
                    rdata <= int_inD_V[319:288];
                end
                ADDR_IND_V_DATA_10: begin
                    rdata <= int_inD_V[351:320];
                end
                ADDR_IND_V_DATA_11: begin
                    rdata <= int_inD_V[383:352];
                end
                ADDR_IND_V_DATA_12: begin
                    rdata <= int_inD_V[415:384];
                end
                ADDR_IND_V_DATA_13: begin
                    rdata <= int_inD_V[447:416];
                end
                ADDR_IND_V_DATA_14: begin
                    rdata <= int_inD_V[479:448];
                end
                ADDR_IND_V_DATA_15: begin
                    rdata <= int_inD_V[511:480];
                end
                ADDR_IND_V_DATA_16: begin
                    rdata <= int_inD_V[543:512];
                end
                ADDR_IND_V_DATA_17: begin
                    rdata <= int_inD_V[575:544];
                end
                ADDR_IND_V_DATA_18: begin
                    rdata <= int_inD_V[607:576];
                end
                ADDR_IND_V_DATA_19: begin
                    rdata <= int_inD_V[639:608];
                end
                ADDR_IND_V_DATA_20: begin
                    rdata <= int_inD_V[671:640];
                end
                ADDR_IND_V_DATA_21: begin
                    rdata <= int_inD_V[703:672];
                end
                ADDR_IND_V_DATA_22: begin
                    rdata <= int_inD_V[735:704];
                end
                ADDR_IND_V_DATA_23: begin
                    rdata <= int_inD_V[767:736];
                end
                ADDR_IND_V_DATA_24: begin
                    rdata <= int_inD_V[799:768];
                end
                ADDR_IND_V_DATA_25: begin
                    rdata <= int_inD_V[831:800];
                end
                ADDR_IND_V_DATA_26: begin
                    rdata <= int_inD_V[863:832];
                end
                ADDR_IND_V_DATA_27: begin
                    rdata <= int_inD_V[895:864];
                end
                ADDR_IND_V_DATA_28: begin
                    rdata <= int_inD_V[927:896];
                end
                ADDR_IND_V_DATA_29: begin
                    rdata <= int_inD_V[959:928];
                end
                ADDR_IND_V_DATA_30: begin
                    rdata <= int_inD_V[991:960];
                end
                ADDR_IND_V_DATA_31: begin
                    rdata <= int_inD_V[1022:992];
                end
            endcase
        end
    end
end


//------------------------Register logic-----------------
assign interrupt = int_gie & (|int_isr);
assign ap_start  = int_ap_start;
assign inA_V     = int_inA_V;
assign inB_V     = int_inB_V;
assign inC_V     = int_inC_V;
assign inD_V     = int_inD_V;
// int_ap_start
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_start <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_AP_CTRL && WSTRB[0] && WDATA[0])
            int_ap_start <= 1'b1;
        else if (ap_ready)
            int_ap_start <= int_auto_restart; // clear on handshake/auto restart
    end
end

// int_ap_done
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_done <= 1'b0;
    else if (ACLK_EN) begin
        if (ap_done)
            int_ap_done <= 1'b1;
        else if (ar_hs && raddr == ADDR_AP_CTRL)
            int_ap_done <= 1'b0; // clear on read
    end
end

// int_ap_idle
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_idle <= 1'b0;
    else if (ACLK_EN) begin
            int_ap_idle <= ap_idle;
    end
end

// int_ap_ready
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_ready <= 1'b0;
    else if (ACLK_EN) begin
            int_ap_ready <= ap_ready;
    end
end

// int_auto_restart
always @(posedge ACLK) begin
    if (ARESET)
        int_auto_restart <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_AP_CTRL && WSTRB[0])
            int_auto_restart <=  WDATA[7];
    end
end

// int_gie
always @(posedge ACLK) begin
    if (ARESET)
        int_gie <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_GIE && WSTRB[0])
            int_gie <= WDATA[0];
    end
end

// int_ier
always @(posedge ACLK) begin
    if (ARESET)
        int_ier <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IER && WSTRB[0])
            int_ier <= WDATA[1:0];
    end
end

// int_isr[0]
always @(posedge ACLK) begin
    if (ARESET)
        int_isr[0] <= 1'b0;
    else if (ACLK_EN) begin
        if (int_ier[0] & ap_done)
            int_isr[0] <= 1'b1;
        else if (w_hs && waddr == ADDR_ISR && WSTRB[0])
            int_isr[0] <= int_isr[0] ^ WDATA[0]; // toggle on write
    end
end

// int_isr[1]
always @(posedge ACLK) begin
    if (ARESET)
        int_isr[1] <= 1'b0;
    else if (ACLK_EN) begin
        if (int_ier[1] & ap_ready)
            int_isr[1] <= 1'b1;
        else if (w_hs && waddr == ADDR_ISR && WSTRB[0])
            int_isr[1] <= int_isr[1] ^ WDATA[1]; // toggle on write
    end
end

// int_inA_V[31:0]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[31:0] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_0)
            int_inA_V[31:0] <= (WDATA[31:0] & wmask) | (int_inA_V[31:0] & ~wmask);
    end
end

// int_inA_V[63:32]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[63:32] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_1)
            int_inA_V[63:32] <= (WDATA[31:0] & wmask) | (int_inA_V[63:32] & ~wmask);
    end
end

// int_inA_V[95:64]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[95:64] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_2)
            int_inA_V[95:64] <= (WDATA[31:0] & wmask) | (int_inA_V[95:64] & ~wmask);
    end
end

// int_inA_V[127:96]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[127:96] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_3)
            int_inA_V[127:96] <= (WDATA[31:0] & wmask) | (int_inA_V[127:96] & ~wmask);
    end
end

// int_inA_V[159:128]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[159:128] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_4)
            int_inA_V[159:128] <= (WDATA[31:0] & wmask) | (int_inA_V[159:128] & ~wmask);
    end
end

// int_inA_V[191:160]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[191:160] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_5)
            int_inA_V[191:160] <= (WDATA[31:0] & wmask) | (int_inA_V[191:160] & ~wmask);
    end
end

// int_inA_V[223:192]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[223:192] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_6)
            int_inA_V[223:192] <= (WDATA[31:0] & wmask) | (int_inA_V[223:192] & ~wmask);
    end
end

// int_inA_V[255:224]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[255:224] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_7)
            int_inA_V[255:224] <= (WDATA[31:0] & wmask) | (int_inA_V[255:224] & ~wmask);
    end
end

// int_inA_V[287:256]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[287:256] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_8)
            int_inA_V[287:256] <= (WDATA[31:0] & wmask) | (int_inA_V[287:256] & ~wmask);
    end
end

// int_inA_V[319:288]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[319:288] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_9)
            int_inA_V[319:288] <= (WDATA[31:0] & wmask) | (int_inA_V[319:288] & ~wmask);
    end
end

// int_inA_V[351:320]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[351:320] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_10)
            int_inA_V[351:320] <= (WDATA[31:0] & wmask) | (int_inA_V[351:320] & ~wmask);
    end
end

// int_inA_V[383:352]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[383:352] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_11)
            int_inA_V[383:352] <= (WDATA[31:0] & wmask) | (int_inA_V[383:352] & ~wmask);
    end
end

// int_inA_V[415:384]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[415:384] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_12)
            int_inA_V[415:384] <= (WDATA[31:0] & wmask) | (int_inA_V[415:384] & ~wmask);
    end
end

// int_inA_V[447:416]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[447:416] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_13)
            int_inA_V[447:416] <= (WDATA[31:0] & wmask) | (int_inA_V[447:416] & ~wmask);
    end
end

// int_inA_V[479:448]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[479:448] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_14)
            int_inA_V[479:448] <= (WDATA[31:0] & wmask) | (int_inA_V[479:448] & ~wmask);
    end
end

// int_inA_V[511:480]
always @(posedge ACLK) begin
    if (ARESET)
        int_inA_V[511:480] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INA_V_DATA_15)
            int_inA_V[511:480] <= (WDATA[31:0] & wmask) | (int_inA_V[511:480] & ~wmask);
    end
end

// int_inB_V[31:0]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[31:0] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_0)
            int_inB_V[31:0] <= (WDATA[31:0] & wmask) | (int_inB_V[31:0] & ~wmask);
    end
end

// int_inB_V[63:32]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[63:32] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_1)
            int_inB_V[63:32] <= (WDATA[31:0] & wmask) | (int_inB_V[63:32] & ~wmask);
    end
end

// int_inB_V[95:64]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[95:64] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_2)
            int_inB_V[95:64] <= (WDATA[31:0] & wmask) | (int_inB_V[95:64] & ~wmask);
    end
end

// int_inB_V[127:96]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[127:96] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_3)
            int_inB_V[127:96] <= (WDATA[31:0] & wmask) | (int_inB_V[127:96] & ~wmask);
    end
end

// int_inB_V[159:128]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[159:128] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_4)
            int_inB_V[159:128] <= (WDATA[31:0] & wmask) | (int_inB_V[159:128] & ~wmask);
    end
end

// int_inB_V[191:160]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[191:160] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_5)
            int_inB_V[191:160] <= (WDATA[31:0] & wmask) | (int_inB_V[191:160] & ~wmask);
    end
end

// int_inB_V[223:192]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[223:192] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_6)
            int_inB_V[223:192] <= (WDATA[31:0] & wmask) | (int_inB_V[223:192] & ~wmask);
    end
end

// int_inB_V[255:224]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[255:224] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_7)
            int_inB_V[255:224] <= (WDATA[31:0] & wmask) | (int_inB_V[255:224] & ~wmask);
    end
end

// int_inB_V[287:256]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[287:256] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_8)
            int_inB_V[287:256] <= (WDATA[31:0] & wmask) | (int_inB_V[287:256] & ~wmask);
    end
end

// int_inB_V[319:288]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[319:288] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_9)
            int_inB_V[319:288] <= (WDATA[31:0] & wmask) | (int_inB_V[319:288] & ~wmask);
    end
end

// int_inB_V[351:320]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[351:320] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_10)
            int_inB_V[351:320] <= (WDATA[31:0] & wmask) | (int_inB_V[351:320] & ~wmask);
    end
end

// int_inB_V[383:352]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[383:352] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_11)
            int_inB_V[383:352] <= (WDATA[31:0] & wmask) | (int_inB_V[383:352] & ~wmask);
    end
end

// int_inB_V[415:384]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[415:384] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_12)
            int_inB_V[415:384] <= (WDATA[31:0] & wmask) | (int_inB_V[415:384] & ~wmask);
    end
end

// int_inB_V[447:416]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[447:416] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_13)
            int_inB_V[447:416] <= (WDATA[31:0] & wmask) | (int_inB_V[447:416] & ~wmask);
    end
end

// int_inB_V[479:448]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[479:448] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_14)
            int_inB_V[479:448] <= (WDATA[31:0] & wmask) | (int_inB_V[479:448] & ~wmask);
    end
end

// int_inB_V[511:480]
always @(posedge ACLK) begin
    if (ARESET)
        int_inB_V[511:480] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INB_V_DATA_15)
            int_inB_V[511:480] <= (WDATA[31:0] & wmask) | (int_inB_V[511:480] & ~wmask);
    end
end

// int_inC_V[31:0]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[31:0] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_0)
            int_inC_V[31:0] <= (WDATA[31:0] & wmask) | (int_inC_V[31:0] & ~wmask);
    end
end

// int_inC_V[63:32]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[63:32] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_1)
            int_inC_V[63:32] <= (WDATA[31:0] & wmask) | (int_inC_V[63:32] & ~wmask);
    end
end

// int_inC_V[95:64]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[95:64] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_2)
            int_inC_V[95:64] <= (WDATA[31:0] & wmask) | (int_inC_V[95:64] & ~wmask);
    end
end

// int_inC_V[127:96]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[127:96] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_3)
            int_inC_V[127:96] <= (WDATA[31:0] & wmask) | (int_inC_V[127:96] & ~wmask);
    end
end

// int_inC_V[159:128]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[159:128] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_4)
            int_inC_V[159:128] <= (WDATA[31:0] & wmask) | (int_inC_V[159:128] & ~wmask);
    end
end

// int_inC_V[191:160]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[191:160] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_5)
            int_inC_V[191:160] <= (WDATA[31:0] & wmask) | (int_inC_V[191:160] & ~wmask);
    end
end

// int_inC_V[223:192]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[223:192] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_6)
            int_inC_V[223:192] <= (WDATA[31:0] & wmask) | (int_inC_V[223:192] & ~wmask);
    end
end

// int_inC_V[255:224]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[255:224] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_7)
            int_inC_V[255:224] <= (WDATA[31:0] & wmask) | (int_inC_V[255:224] & ~wmask);
    end
end

// int_inC_V[287:256]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[287:256] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_8)
            int_inC_V[287:256] <= (WDATA[31:0] & wmask) | (int_inC_V[287:256] & ~wmask);
    end
end

// int_inC_V[319:288]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[319:288] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_9)
            int_inC_V[319:288] <= (WDATA[31:0] & wmask) | (int_inC_V[319:288] & ~wmask);
    end
end

// int_inC_V[351:320]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[351:320] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_10)
            int_inC_V[351:320] <= (WDATA[31:0] & wmask) | (int_inC_V[351:320] & ~wmask);
    end
end

// int_inC_V[383:352]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[383:352] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_11)
            int_inC_V[383:352] <= (WDATA[31:0] & wmask) | (int_inC_V[383:352] & ~wmask);
    end
end

// int_inC_V[415:384]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[415:384] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_12)
            int_inC_V[415:384] <= (WDATA[31:0] & wmask) | (int_inC_V[415:384] & ~wmask);
    end
end

// int_inC_V[447:416]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[447:416] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_13)
            int_inC_V[447:416] <= (WDATA[31:0] & wmask) | (int_inC_V[447:416] & ~wmask);
    end
end

// int_inC_V[479:448]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[479:448] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_14)
            int_inC_V[479:448] <= (WDATA[31:0] & wmask) | (int_inC_V[479:448] & ~wmask);
    end
end

// int_inC_V[511:480]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[511:480] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_15)
            int_inC_V[511:480] <= (WDATA[31:0] & wmask) | (int_inC_V[511:480] & ~wmask);
    end
end

// int_inC_V[543:512]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[543:512] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_16)
            int_inC_V[543:512] <= (WDATA[31:0] & wmask) | (int_inC_V[543:512] & ~wmask);
    end
end

// int_inC_V[575:544]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[575:544] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_17)
            int_inC_V[575:544] <= (WDATA[31:0] & wmask) | (int_inC_V[575:544] & ~wmask);
    end
end

// int_inC_V[607:576]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[607:576] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_18)
            int_inC_V[607:576] <= (WDATA[31:0] & wmask) | (int_inC_V[607:576] & ~wmask);
    end
end

// int_inC_V[639:608]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[639:608] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_19)
            int_inC_V[639:608] <= (WDATA[31:0] & wmask) | (int_inC_V[639:608] & ~wmask);
    end
end

// int_inC_V[671:640]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[671:640] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_20)
            int_inC_V[671:640] <= (WDATA[31:0] & wmask) | (int_inC_V[671:640] & ~wmask);
    end
end

// int_inC_V[703:672]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[703:672] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_21)
            int_inC_V[703:672] <= (WDATA[31:0] & wmask) | (int_inC_V[703:672] & ~wmask);
    end
end

// int_inC_V[735:704]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[735:704] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_22)
            int_inC_V[735:704] <= (WDATA[31:0] & wmask) | (int_inC_V[735:704] & ~wmask);
    end
end

// int_inC_V[767:736]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[767:736] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_23)
            int_inC_V[767:736] <= (WDATA[31:0] & wmask) | (int_inC_V[767:736] & ~wmask);
    end
end

// int_inC_V[799:768]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[799:768] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_24)
            int_inC_V[799:768] <= (WDATA[31:0] & wmask) | (int_inC_V[799:768] & ~wmask);
    end
end

// int_inC_V[831:800]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[831:800] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_25)
            int_inC_V[831:800] <= (WDATA[31:0] & wmask) | (int_inC_V[831:800] & ~wmask);
    end
end

// int_inC_V[863:832]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[863:832] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_26)
            int_inC_V[863:832] <= (WDATA[31:0] & wmask) | (int_inC_V[863:832] & ~wmask);
    end
end

// int_inC_V[895:864]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[895:864] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_27)
            int_inC_V[895:864] <= (WDATA[31:0] & wmask) | (int_inC_V[895:864] & ~wmask);
    end
end

// int_inC_V[927:896]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[927:896] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_28)
            int_inC_V[927:896] <= (WDATA[31:0] & wmask) | (int_inC_V[927:896] & ~wmask);
    end
end

// int_inC_V[959:928]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[959:928] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_29)
            int_inC_V[959:928] <= (WDATA[31:0] & wmask) | (int_inC_V[959:928] & ~wmask);
    end
end

// int_inC_V[991:960]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[991:960] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_30)
            int_inC_V[991:960] <= (WDATA[31:0] & wmask) | (int_inC_V[991:960] & ~wmask);
    end
end

// int_inC_V[1022:992]
always @(posedge ACLK) begin
    if (ARESET)
        int_inC_V[1022:992] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_INC_V_DATA_31)
            int_inC_V[1022:992] <= (WDATA[31:0] & wmask) | (int_inC_V[1022:992] & ~wmask);
    end
end

// int_inD_V[31:0]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[31:0] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_0)
            int_inD_V[31:0] <= (WDATA[31:0] & wmask) | (int_inD_V[31:0] & ~wmask);
    end
end

// int_inD_V[63:32]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[63:32] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_1)
            int_inD_V[63:32] <= (WDATA[31:0] & wmask) | (int_inD_V[63:32] & ~wmask);
    end
end

// int_inD_V[95:64]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[95:64] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_2)
            int_inD_V[95:64] <= (WDATA[31:0] & wmask) | (int_inD_V[95:64] & ~wmask);
    end
end

// int_inD_V[127:96]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[127:96] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_3)
            int_inD_V[127:96] <= (WDATA[31:0] & wmask) | (int_inD_V[127:96] & ~wmask);
    end
end

// int_inD_V[159:128]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[159:128] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_4)
            int_inD_V[159:128] <= (WDATA[31:0] & wmask) | (int_inD_V[159:128] & ~wmask);
    end
end

// int_inD_V[191:160]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[191:160] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_5)
            int_inD_V[191:160] <= (WDATA[31:0] & wmask) | (int_inD_V[191:160] & ~wmask);
    end
end

// int_inD_V[223:192]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[223:192] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_6)
            int_inD_V[223:192] <= (WDATA[31:0] & wmask) | (int_inD_V[223:192] & ~wmask);
    end
end

// int_inD_V[255:224]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[255:224] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_7)
            int_inD_V[255:224] <= (WDATA[31:0] & wmask) | (int_inD_V[255:224] & ~wmask);
    end
end

// int_inD_V[287:256]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[287:256] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_8)
            int_inD_V[287:256] <= (WDATA[31:0] & wmask) | (int_inD_V[287:256] & ~wmask);
    end
end

// int_inD_V[319:288]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[319:288] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_9)
            int_inD_V[319:288] <= (WDATA[31:0] & wmask) | (int_inD_V[319:288] & ~wmask);
    end
end

// int_inD_V[351:320]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[351:320] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_10)
            int_inD_V[351:320] <= (WDATA[31:0] & wmask) | (int_inD_V[351:320] & ~wmask);
    end
end

// int_inD_V[383:352]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[383:352] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_11)
            int_inD_V[383:352] <= (WDATA[31:0] & wmask) | (int_inD_V[383:352] & ~wmask);
    end
end

// int_inD_V[415:384]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[415:384] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_12)
            int_inD_V[415:384] <= (WDATA[31:0] & wmask) | (int_inD_V[415:384] & ~wmask);
    end
end

// int_inD_V[447:416]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[447:416] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_13)
            int_inD_V[447:416] <= (WDATA[31:0] & wmask) | (int_inD_V[447:416] & ~wmask);
    end
end

// int_inD_V[479:448]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[479:448] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_14)
            int_inD_V[479:448] <= (WDATA[31:0] & wmask) | (int_inD_V[479:448] & ~wmask);
    end
end

// int_inD_V[511:480]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[511:480] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_15)
            int_inD_V[511:480] <= (WDATA[31:0] & wmask) | (int_inD_V[511:480] & ~wmask);
    end
end

// int_inD_V[543:512]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[543:512] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_16)
            int_inD_V[543:512] <= (WDATA[31:0] & wmask) | (int_inD_V[543:512] & ~wmask);
    end
end

// int_inD_V[575:544]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[575:544] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_17)
            int_inD_V[575:544] <= (WDATA[31:0] & wmask) | (int_inD_V[575:544] & ~wmask);
    end
end

// int_inD_V[607:576]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[607:576] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_18)
            int_inD_V[607:576] <= (WDATA[31:0] & wmask) | (int_inD_V[607:576] & ~wmask);
    end
end

// int_inD_V[639:608]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[639:608] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_19)
            int_inD_V[639:608] <= (WDATA[31:0] & wmask) | (int_inD_V[639:608] & ~wmask);
    end
end

// int_inD_V[671:640]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[671:640] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_20)
            int_inD_V[671:640] <= (WDATA[31:0] & wmask) | (int_inD_V[671:640] & ~wmask);
    end
end

// int_inD_V[703:672]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[703:672] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_21)
            int_inD_V[703:672] <= (WDATA[31:0] & wmask) | (int_inD_V[703:672] & ~wmask);
    end
end

// int_inD_V[735:704]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[735:704] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_22)
            int_inD_V[735:704] <= (WDATA[31:0] & wmask) | (int_inD_V[735:704] & ~wmask);
    end
end

// int_inD_V[767:736]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[767:736] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_23)
            int_inD_V[767:736] <= (WDATA[31:0] & wmask) | (int_inD_V[767:736] & ~wmask);
    end
end

// int_inD_V[799:768]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[799:768] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_24)
            int_inD_V[799:768] <= (WDATA[31:0] & wmask) | (int_inD_V[799:768] & ~wmask);
    end
end

// int_inD_V[831:800]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[831:800] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_25)
            int_inD_V[831:800] <= (WDATA[31:0] & wmask) | (int_inD_V[831:800] & ~wmask);
    end
end

// int_inD_V[863:832]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[863:832] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_26)
            int_inD_V[863:832] <= (WDATA[31:0] & wmask) | (int_inD_V[863:832] & ~wmask);
    end
end

// int_inD_V[895:864]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[895:864] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_27)
            int_inD_V[895:864] <= (WDATA[31:0] & wmask) | (int_inD_V[895:864] & ~wmask);
    end
end

// int_inD_V[927:896]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[927:896] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_28)
            int_inD_V[927:896] <= (WDATA[31:0] & wmask) | (int_inD_V[927:896] & ~wmask);
    end
end

// int_inD_V[959:928]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[959:928] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_29)
            int_inD_V[959:928] <= (WDATA[31:0] & wmask) | (int_inD_V[959:928] & ~wmask);
    end
end

// int_inD_V[991:960]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[991:960] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_30)
            int_inD_V[991:960] <= (WDATA[31:0] & wmask) | (int_inD_V[991:960] & ~wmask);
    end
end

// int_inD_V[1022:992]
always @(posedge ACLK) begin
    if (ARESET)
        int_inD_V[1022:992] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IND_V_DATA_31)
            int_inD_V[1022:992] <= (WDATA[31:0] & wmask) | (int_inD_V[1022:992] & ~wmask);
    end
end


//------------------------Memory logic-------------------

endmodule
