// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2017.4
// Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
// 
// ==============================================================

/***************************** Include Files *********************************/
#include "xapint_arith.h"

/************************** Function Implementation *************************/
#ifndef __linux__
int XApint_arith_CfgInitialize(XApint_arith *InstancePtr, XApint_arith_Config *ConfigPtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(ConfigPtr != NULL);

    InstancePtr->Axilites_BaseAddress = ConfigPtr->Axilites_BaseAddress;
    InstancePtr->IsReady = XIL_COMPONENT_IS_READY;

    return XST_SUCCESS;
}
#endif

void XApint_arith_Start(XApint_arith *InstancePtr) {
    u32 Data;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL) & 0x80;
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL, Data | 0x01);
}

u32 XApint_arith_IsDone(XApint_arith *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL);
    return (Data >> 1) & 0x1;
}

u32 XApint_arith_IsIdle(XApint_arith *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL);
    return (Data >> 2) & 0x1;
}

u32 XApint_arith_IsReady(XApint_arith *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL);
    // check ap_start to see if the pcore is ready for next input
    return !(Data & 0x1);
}

void XApint_arith_EnableAutoRestart(XApint_arith *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL, 0x80);
}

void XApint_arith_DisableAutoRestart(XApint_arith *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_AP_CTRL, 0);
}

void XApint_arith_Set_inA_V(XApint_arith *InstancePtr, XApint_arith_Ina_v Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 0, Data.word_0);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 4, Data.word_1);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 8, Data.word_2);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 12, Data.word_3);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 16, Data.word_4);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 20, Data.word_5);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 24, Data.word_6);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 28, Data.word_7);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 32, Data.word_8);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 36, Data.word_9);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 40, Data.word_10);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 44, Data.word_11);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 48, Data.word_12);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 52, Data.word_13);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 56, Data.word_14);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 60, Data.word_15);
}

XApint_arith_Ina_v XApint_arith_Get_inA_V(XApint_arith *InstancePtr) {
    XApint_arith_Ina_v Data;

    Data.word_0 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 0);
    Data.word_1 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 4);
    Data.word_2 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 8);
    Data.word_3 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 12);
    Data.word_4 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 16);
    Data.word_5 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 20);
    Data.word_6 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 24);
    Data.word_7 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 28);
    Data.word_8 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 32);
    Data.word_9 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 36);
    Data.word_10 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 40);
    Data.word_11 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 44);
    Data.word_12 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 48);
    Data.word_13 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 52);
    Data.word_14 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 56);
    Data.word_15 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INA_V_DATA + 60);
    return Data;
}

void XApint_arith_Set_inB_V(XApint_arith *InstancePtr, XApint_arith_Inb_v Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 0, Data.word_0);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 4, Data.word_1);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 8, Data.word_2);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 12, Data.word_3);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 16, Data.word_4);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 20, Data.word_5);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 24, Data.word_6);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 28, Data.word_7);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 32, Data.word_8);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 36, Data.word_9);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 40, Data.word_10);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 44, Data.word_11);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 48, Data.word_12);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 52, Data.word_13);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 56, Data.word_14);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 60, Data.word_15);
}

XApint_arith_Inb_v XApint_arith_Get_inB_V(XApint_arith *InstancePtr) {
    XApint_arith_Inb_v Data;

    Data.word_0 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 0);
    Data.word_1 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 4);
    Data.word_2 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 8);
    Data.word_3 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 12);
    Data.word_4 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 16);
    Data.word_5 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 20);
    Data.word_6 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 24);
    Data.word_7 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 28);
    Data.word_8 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 32);
    Data.word_9 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 36);
    Data.word_10 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 40);
    Data.word_11 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 44);
    Data.word_12 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 48);
    Data.word_13 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 52);
    Data.word_14 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 56);
    Data.word_15 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INB_V_DATA + 60);
    return Data;
}

void XApint_arith_Set_inC_V(XApint_arith *InstancePtr, XApint_arith_Inc_v Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 0, Data.word_0);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 4, Data.word_1);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 8, Data.word_2);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 12, Data.word_3);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 16, Data.word_4);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 20, Data.word_5);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 24, Data.word_6);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 28, Data.word_7);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 32, Data.word_8);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 36, Data.word_9);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 40, Data.word_10);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 44, Data.word_11);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 48, Data.word_12);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 52, Data.word_13);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 56, Data.word_14);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 60, Data.word_15);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 64, Data.word_16);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 68, Data.word_17);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 72, Data.word_18);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 76, Data.word_19);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 80, Data.word_20);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 84, Data.word_21);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 88, Data.word_22);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 92, Data.word_23);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 96, Data.word_24);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 100, Data.word_25);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 104, Data.word_26);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 108, Data.word_27);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 112, Data.word_28);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 116, Data.word_29);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 120, Data.word_30);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 124, Data.word_31);
}

XApint_arith_Inc_v XApint_arith_Get_inC_V(XApint_arith *InstancePtr) {
    XApint_arith_Inc_v Data;

    Data.word_0 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 0);
    Data.word_1 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 4);
    Data.word_2 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 8);
    Data.word_3 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 12);
    Data.word_4 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 16);
    Data.word_5 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 20);
    Data.word_6 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 24);
    Data.word_7 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 28);
    Data.word_8 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 32);
    Data.word_9 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 36);
    Data.word_10 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 40);
    Data.word_11 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 44);
    Data.word_12 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 48);
    Data.word_13 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 52);
    Data.word_14 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 56);
    Data.word_15 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 60);
    Data.word_16 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 64);
    Data.word_17 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 68);
    Data.word_18 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 72);
    Data.word_19 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 76);
    Data.word_20 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 80);
    Data.word_21 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 84);
    Data.word_22 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 88);
    Data.word_23 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 92);
    Data.word_24 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 96);
    Data.word_25 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 100);
    Data.word_26 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 104);
    Data.word_27 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 108);
    Data.word_28 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 112);
    Data.word_29 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 116);
    Data.word_30 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 120);
    Data.word_31 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_INC_V_DATA + 124);
    return Data;
}

void XApint_arith_Set_inD_V(XApint_arith *InstancePtr, XApint_arith_Ind_v Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 0, Data.word_0);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 4, Data.word_1);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 8, Data.word_2);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 12, Data.word_3);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 16, Data.word_4);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 20, Data.word_5);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 24, Data.word_6);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 28, Data.word_7);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 32, Data.word_8);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 36, Data.word_9);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 40, Data.word_10);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 44, Data.word_11);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 48, Data.word_12);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 52, Data.word_13);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 56, Data.word_14);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 60, Data.word_15);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 64, Data.word_16);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 68, Data.word_17);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 72, Data.word_18);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 76, Data.word_19);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 80, Data.word_20);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 84, Data.word_21);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 88, Data.word_22);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 92, Data.word_23);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 96, Data.word_24);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 100, Data.word_25);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 104, Data.word_26);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 108, Data.word_27);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 112, Data.word_28);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 116, Data.word_29);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 120, Data.word_30);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 124, Data.word_31);
}

XApint_arith_Ind_v XApint_arith_Get_inD_V(XApint_arith *InstancePtr) {
    XApint_arith_Ind_v Data;

    Data.word_0 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 0);
    Data.word_1 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 4);
    Data.word_2 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 8);
    Data.word_3 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 12);
    Data.word_4 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 16);
    Data.word_5 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 20);
    Data.word_6 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 24);
    Data.word_7 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 28);
    Data.word_8 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 32);
    Data.word_9 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 36);
    Data.word_10 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 40);
    Data.word_11 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 44);
    Data.word_12 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 48);
    Data.word_13 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 52);
    Data.word_14 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 56);
    Data.word_15 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 60);
    Data.word_16 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 64);
    Data.word_17 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 68);
    Data.word_18 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 72);
    Data.word_19 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 76);
    Data.word_20 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 80);
    Data.word_21 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 84);
    Data.word_22 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 88);
    Data.word_23 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 92);
    Data.word_24 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 96);
    Data.word_25 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 100);
    Data.word_26 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 104);
    Data.word_27 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 108);
    Data.word_28 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 112);
    Data.word_29 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 116);
    Data.word_30 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 120);
    Data.word_31 = XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IND_V_DATA + 124);
    return Data;
}

void XApint_arith_InterruptGlobalEnable(XApint_arith *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_GIE, 1);
}

void XApint_arith_InterruptGlobalDisable(XApint_arith *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_GIE, 0);
}

void XApint_arith_InterruptEnable(XApint_arith *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IER);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IER, Register | Mask);
}

void XApint_arith_InterruptDisable(XApint_arith *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IER);
    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IER, Register & (~Mask));
}

void XApint_arith_InterruptClear(XApint_arith *InstancePtr, u32 Mask) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XApint_arith_WriteReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_ISR, Mask);
}

u32 XApint_arith_InterruptGetEnabled(XApint_arith *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_IER);
}

u32 XApint_arith_InterruptGetStatus(XApint_arith *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XApint_arith_ReadReg(InstancePtr->Axilites_BaseAddress, XAPINT_ARITH_AXILITES_ADDR_ISR);
}

