-- ==============================================================
-- RTL generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
-- Version: 2017.4
-- Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
-- 
-- ===========================================================

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity conv_stream is
generic (
    C_S_AXI_AXILITES_ADDR_WIDTH : INTEGER := 5;
    C_S_AXI_AXILITES_DATA_WIDTH : INTEGER := 32;
    C_M_AXI_IN_ARRAY_ADDR_WIDTH : INTEGER := 32;
    C_M_AXI_IN_ARRAY_ID_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_AWUSER_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_DATA_WIDTH : INTEGER := 32;
    C_M_AXI_IN_ARRAY_WUSER_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_ARUSER_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_RUSER_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_BUSER_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_ADDR_WIDTH : INTEGER := 32;
    C_M_AXI_OUT_ARRAY_ID_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_AWUSER_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_DATA_WIDTH : INTEGER := 32;
    C_M_AXI_OUT_ARRAY_WUSER_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_ARUSER_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_RUSER_WIDTH : INTEGER := 1;
    C_M_AXI_OUT_ARRAY_BUSER_WIDTH : INTEGER := 1;
    C_M_AXI_IN_ARRAY_USER_VALUE : INTEGER := 0;
    C_M_AXI_IN_ARRAY_PROT_VALUE : INTEGER := 0;
    C_M_AXI_IN_ARRAY_CACHE_VALUE : INTEGER := 3;
    C_M_AXI_OUT_ARRAY_USER_VALUE : INTEGER := 0;
    C_M_AXI_OUT_ARRAY_PROT_VALUE : INTEGER := 0;
    C_M_AXI_OUT_ARRAY_CACHE_VALUE : INTEGER := 3 );
port (
    s_axi_AXILiteS_AWVALID : IN STD_LOGIC;
    s_axi_AXILiteS_AWREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_WVALID : IN STD_LOGIC;
    s_axi_AXILiteS_WREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH/8-1 downto 0);
    s_axi_AXILiteS_ARVALID : IN STD_LOGIC;
    s_axi_AXILiteS_ARREADY : OUT STD_LOGIC;
    s_axi_AXILiteS_ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_AXILITES_ADDR_WIDTH-1 downto 0);
    s_axi_AXILiteS_RVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_RREADY : IN STD_LOGIC;
    s_axi_AXILiteS_RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_AXILITES_DATA_WIDTH-1 downto 0);
    s_axi_AXILiteS_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    s_axi_AXILiteS_BVALID : OUT STD_LOGIC;
    s_axi_AXILiteS_BREADY : IN STD_LOGIC;
    s_axi_AXILiteS_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
    ap_clk : IN STD_LOGIC;
    ap_rst_n : IN STD_LOGIC;
    interrupt : OUT STD_LOGIC;
    m_axi_in_array_AWVALID : OUT STD_LOGIC;
    m_axi_in_array_AWREADY : IN STD_LOGIC;
    m_axi_in_array_AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ADDR_WIDTH-1 downto 0);
    m_axi_in_array_AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_in_array_AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_in_array_AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_in_array_AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_in_array_AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_AWUSER_WIDTH-1 downto 0);
    m_axi_in_array_WVALID : OUT STD_LOGIC;
    m_axi_in_array_WREADY : IN STD_LOGIC;
    m_axi_in_array_WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_DATA_WIDTH-1 downto 0);
    m_axi_in_array_WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_DATA_WIDTH/8-1 downto 0);
    m_axi_in_array_WLAST : OUT STD_LOGIC;
    m_axi_in_array_WID : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_in_array_WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_WUSER_WIDTH-1 downto 0);
    m_axi_in_array_ARVALID : OUT STD_LOGIC;
    m_axi_in_array_ARREADY : IN STD_LOGIC;
    m_axi_in_array_ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ADDR_WIDTH-1 downto 0);
    m_axi_in_array_ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_in_array_ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_in_array_ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_in_array_ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_in_array_ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_in_array_ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ARUSER_WIDTH-1 downto 0);
    m_axi_in_array_RVALID : IN STD_LOGIC;
    m_axi_in_array_RREADY : OUT STD_LOGIC;
    m_axi_in_array_RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_DATA_WIDTH-1 downto 0);
    m_axi_in_array_RLAST : IN STD_LOGIC;
    m_axi_in_array_RID : IN STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_in_array_RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_RUSER_WIDTH-1 downto 0);
    m_axi_in_array_RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_BVALID : IN STD_LOGIC;
    m_axi_in_array_BREADY : OUT STD_LOGIC;
    m_axi_in_array_BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_in_array_BID : IN STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_in_array_BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_IN_ARRAY_BUSER_WIDTH-1 downto 0);
    m_axi_out_array_AWVALID : OUT STD_LOGIC;
    m_axi_out_array_AWREADY : IN STD_LOGIC;
    m_axi_out_array_AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ADDR_WIDTH-1 downto 0);
    m_axi_out_array_AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_out_array_AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_out_array_AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_out_array_AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_out_array_AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_AWUSER_WIDTH-1 downto 0);
    m_axi_out_array_WVALID : OUT STD_LOGIC;
    m_axi_out_array_WREADY : IN STD_LOGIC;
    m_axi_out_array_WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_DATA_WIDTH-1 downto 0);
    m_axi_out_array_WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_DATA_WIDTH/8-1 downto 0);
    m_axi_out_array_WLAST : OUT STD_LOGIC;
    m_axi_out_array_WID : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_out_array_WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_WUSER_WIDTH-1 downto 0);
    m_axi_out_array_ARVALID : OUT STD_LOGIC;
    m_axi_out_array_ARREADY : IN STD_LOGIC;
    m_axi_out_array_ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ADDR_WIDTH-1 downto 0);
    m_axi_out_array_ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_out_array_ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
    m_axi_out_array_ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_out_array_ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
    m_axi_out_array_ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
    m_axi_out_array_ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ARUSER_WIDTH-1 downto 0);
    m_axi_out_array_RVALID : IN STD_LOGIC;
    m_axi_out_array_RREADY : OUT STD_LOGIC;
    m_axi_out_array_RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_DATA_WIDTH-1 downto 0);
    m_axi_out_array_RLAST : IN STD_LOGIC;
    m_axi_out_array_RID : IN STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_out_array_RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_RUSER_WIDTH-1 downto 0);
    m_axi_out_array_RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_BVALID : IN STD_LOGIC;
    m_axi_out_array_BREADY : OUT STD_LOGIC;
    m_axi_out_array_BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
    m_axi_out_array_BID : IN STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_ID_WIDTH-1 downto 0);
    m_axi_out_array_BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_OUT_ARRAY_BUSER_WIDTH-1 downto 0) );
end;


architecture behav of conv_stream is 
    attribute CORE_GENERATION_INFO : STRING;
    attribute CORE_GENERATION_INFO of behav : architecture is
    "conv_stream,hls_ip_2017_4,{HLS_INPUT_TYPE=cxx,HLS_INPUT_FLOAT=1,HLS_INPUT_FIXED=0,HLS_INPUT_PART=xc7z020clg484-1,HLS_INPUT_CLOCK=10.000000,HLS_INPUT_ARCH=dataflow,HLS_SYN_CLOCK=8.750000,HLS_SYN_LAT=465,HLS_SYN_TPT=452,HLS_SYN_MEM=8,HLS_SYN_DSP=33,HLS_SYN_FF=5696,HLS_SYN_LUT=7759}";
    constant C_S_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_S_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_S_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant ap_const_logic_1 : STD_LOGIC := '1';
    constant C_M_AXI_ID_WIDTH : INTEGER range 63 downto 0 := 1;
    constant C_M_AXI_ADDR_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_M_AXI_DATA_WIDTH : INTEGER range 63 downto 0 := 20;
    constant C_M_AXI_WSTRB_WIDTH : INTEGER range 63 downto 0 := 4;
    constant C_M_AXI_AWUSER_WIDTH : INTEGER range 63 downto 0 := 1;
    constant C_M_AXI_ARUSER_WIDTH : INTEGER range 63 downto 0 := 1;
    constant C_M_AXI_WUSER_WIDTH : INTEGER range 63 downto 0 := 1;
    constant C_M_AXI_RUSER_WIDTH : INTEGER range 63 downto 0 := 1;
    constant C_M_AXI_BUSER_WIDTH : INTEGER range 63 downto 0 := 1;
    constant ap_const_logic_0 : STD_LOGIC := '0';
    constant ap_const_lv32_0 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000000";
    constant ap_const_lv32_1 : STD_LOGIC_VECTOR (31 downto 0) := "00000000000000000000000000000001";
    constant ap_const_lv1_0 : STD_LOGIC_VECTOR (0 downto 0) := "0";
    constant ap_const_lv1_1 : STD_LOGIC_VECTOR (0 downto 0) := "1";
    constant ap_const_lv3_0 : STD_LOGIC_VECTOR (2 downto 0) := "000";
    constant ap_const_lv3_1 : STD_LOGIC_VECTOR (2 downto 0) := "001";
    constant ap_const_lv2_0 : STD_LOGIC_VECTOR (1 downto 0) := "00";
    constant ap_const_lv2_1 : STD_LOGIC_VECTOR (1 downto 0) := "01";
    constant ap_const_lv4_0 : STD_LOGIC_VECTOR (3 downto 0) := "0000";
    constant ap_const_lv4_1 : STD_LOGIC_VECTOR (3 downto 0) := "0001";

    signal ap_rst_n_inv : STD_LOGIC;
    signal ap_start : STD_LOGIC;
    signal ap_ready : STD_LOGIC;
    signal ap_done : STD_LOGIC;
    signal ap_idle : STD_LOGIC;
    signal in_array_offset : STD_LOGIC_VECTOR (31 downto 0);
    signal out_array_offset : STD_LOGIC_VECTOR (31 downto 0);
    signal in_array_AWREADY : STD_LOGIC;
    signal in_array_WREADY : STD_LOGIC;
    signal in_array_ARREADY : STD_LOGIC;
    signal in_array_RVALID : STD_LOGIC;
    signal in_array_RDATA : STD_LOGIC_VECTOR (31 downto 0);
    signal in_array_RLAST : STD_LOGIC;
    signal in_array_RID : STD_LOGIC_VECTOR (0 downto 0);
    signal in_array_RUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal in_array_RRESP : STD_LOGIC_VECTOR (1 downto 0);
    signal in_array_BVALID : STD_LOGIC;
    signal in_array_BRESP : STD_LOGIC_VECTOR (1 downto 0);
    signal in_array_BID : STD_LOGIC_VECTOR (0 downto 0);
    signal in_array_BUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal out_array_AWREADY : STD_LOGIC;
    signal out_array_WREADY : STD_LOGIC;
    signal out_array_ARREADY : STD_LOGIC;
    signal out_array_RVALID : STD_LOGIC;
    signal out_array_RDATA : STD_LOGIC_VECTOR (31 downto 0);
    signal out_array_RLAST : STD_LOGIC;
    signal out_array_RID : STD_LOGIC_VECTOR (0 downto 0);
    signal out_array_RUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal out_array_RRESP : STD_LOGIC_VECTOR (1 downto 0);
    signal out_array_BVALID : STD_LOGIC;
    signal out_array_BRESP : STD_LOGIC_VECTOR (1 downto 0);
    signal out_array_BID : STD_LOGIC_VECTOR (0 downto 0);
    signal out_array_BUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_ap_start : STD_LOGIC;
    signal read_pixel13_U0_start_full_n : STD_LOGIC;
    signal read_pixel13_U0_ap_done : STD_LOGIC;
    signal read_pixel13_U0_ap_continue : STD_LOGIC;
    signal read_pixel13_U0_ap_idle : STD_LOGIC;
    signal read_pixel13_U0_ap_ready : STD_LOGIC;
    signal read_pixel13_U0_start_out : STD_LOGIC;
    signal read_pixel13_U0_start_write : STD_LOGIC;
    signal read_pixel13_U0_in_stream_V_din : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_in_stream_V_write : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_AWVALID : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_AWADDR : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWID : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWLEN : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWSIZE : STD_LOGIC_VECTOR (2 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWBURST : STD_LOGIC_VECTOR (1 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWLOCK : STD_LOGIC_VECTOR (1 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWCACHE : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWPROT : STD_LOGIC_VECTOR (2 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWQOS : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWREGION : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_AWUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_WVALID : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_WDATA : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_m_axi_in_array_WSTRB : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_WLAST : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_WID : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_WUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARVALID : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_ARADDR : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARID : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARLEN : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARSIZE : STD_LOGIC_VECTOR (2 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARBURST : STD_LOGIC_VECTOR (1 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARLOCK : STD_LOGIC_VECTOR (1 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARCACHE : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARPROT : STD_LOGIC_VECTOR (2 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARQOS : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARREGION : STD_LOGIC_VECTOR (3 downto 0);
    signal read_pixel13_U0_m_axi_in_array_ARUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal read_pixel13_U0_m_axi_in_array_RREADY : STD_LOGIC;
    signal read_pixel13_U0_m_axi_in_array_BREADY : STD_LOGIC;
    signal read_pixel13_U0_out_array_offset_out_din : STD_LOGIC_VECTOR (31 downto 0);
    signal read_pixel13_U0_out_array_offset_out_write : STD_LOGIC;
    signal convolve_U0_ap_start : STD_LOGIC;
    signal convolve_U0_ap_done : STD_LOGIC;
    signal convolve_U0_ap_continue : STD_LOGIC;
    signal convolve_U0_ap_idle : STD_LOGIC;
    signal convolve_U0_ap_ready : STD_LOGIC;
    signal convolve_U0_in_stream_V_read : STD_LOGIC;
    signal convolve_U0_out_stream_V_din : STD_LOGIC_VECTOR (31 downto 0);
    signal convolve_U0_out_stream_V_write : STD_LOGIC;
    signal write_pixel_U0_ap_start : STD_LOGIC;
    signal write_pixel_U0_ap_done : STD_LOGIC;
    signal write_pixel_U0_ap_continue : STD_LOGIC;
    signal write_pixel_U0_ap_idle : STD_LOGIC;
    signal write_pixel_U0_ap_ready : STD_LOGIC;
    signal write_pixel_U0_out_stream_V_read : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_AWVALID : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_AWADDR : STD_LOGIC_VECTOR (31 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWID : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWLEN : STD_LOGIC_VECTOR (31 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWSIZE : STD_LOGIC_VECTOR (2 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWBURST : STD_LOGIC_VECTOR (1 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWLOCK : STD_LOGIC_VECTOR (1 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWCACHE : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWPROT : STD_LOGIC_VECTOR (2 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWQOS : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWREGION : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_AWUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_WVALID : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_WDATA : STD_LOGIC_VECTOR (31 downto 0);
    signal write_pixel_U0_m_axi_out_array_WSTRB : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_WLAST : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_WID : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_WUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARVALID : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_ARADDR : STD_LOGIC_VECTOR (31 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARID : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARLEN : STD_LOGIC_VECTOR (31 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARSIZE : STD_LOGIC_VECTOR (2 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARBURST : STD_LOGIC_VECTOR (1 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARLOCK : STD_LOGIC_VECTOR (1 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARCACHE : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARPROT : STD_LOGIC_VECTOR (2 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARQOS : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARREGION : STD_LOGIC_VECTOR (3 downto 0);
    signal write_pixel_U0_m_axi_out_array_ARUSER : STD_LOGIC_VECTOR (0 downto 0);
    signal write_pixel_U0_m_axi_out_array_RREADY : STD_LOGIC;
    signal write_pixel_U0_m_axi_out_array_BREADY : STD_LOGIC;
    signal write_pixel_U0_out_array_offset_read : STD_LOGIC;
    signal ap_sync_continue : STD_LOGIC;
    signal in_stream_V_full_n : STD_LOGIC;
    signal in_stream_V_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal in_stream_V_empty_n : STD_LOGIC;
    signal out_array_offset_c_full_n : STD_LOGIC;
    signal out_array_offset_c_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal out_array_offset_c_empty_n : STD_LOGIC;
    signal out_stream_V_full_n : STD_LOGIC;
    signal out_stream_V_dout : STD_LOGIC_VECTOR (31 downto 0);
    signal out_stream_V_empty_n : STD_LOGIC;
    signal ap_sync_done : STD_LOGIC;
    signal ap_sync_ready : STD_LOGIC;
    signal start_for_convolve_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_convolve_U0_full_n : STD_LOGIC;
    signal start_for_convolve_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_convolve_U0_empty_n : STD_LOGIC;
    signal start_for_write_pixel_U0_din : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_write_pixel_U0_full_n : STD_LOGIC;
    signal start_for_write_pixel_U0_dout : STD_LOGIC_VECTOR (0 downto 0);
    signal start_for_write_pixel_U0_empty_n : STD_LOGIC;
    signal convolve_U0_start_full_n : STD_LOGIC;
    signal convolve_U0_start_write : STD_LOGIC;
    signal write_pixel_U0_start_full_n : STD_LOGIC;
    signal write_pixel_U0_start_write : STD_LOGIC;

    component read_pixel13 IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        start_full_n : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        start_out : OUT STD_LOGIC;
        start_write : OUT STD_LOGIC;
        in_stream_V_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        in_stream_V_full_n : IN STD_LOGIC;
        in_stream_V_write : OUT STD_LOGIC;
        m_axi_in_array_AWVALID : OUT STD_LOGIC;
        m_axi_in_array_AWREADY : IN STD_LOGIC;
        m_axi_in_array_AWADDR : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_AWID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_AWLEN : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_in_array_AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_in_array_AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_AWUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_WVALID : OUT STD_LOGIC;
        m_axi_in_array_WREADY : IN STD_LOGIC;
        m_axi_in_array_WDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_WSTRB : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_WLAST : OUT STD_LOGIC;
        m_axi_in_array_WID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_WUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_ARVALID : OUT STD_LOGIC;
        m_axi_in_array_ARREADY : IN STD_LOGIC;
        m_axi_in_array_ARADDR : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_ARID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_ARLEN : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_in_array_ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_in_array_ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_in_array_ARUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_RVALID : IN STD_LOGIC;
        m_axi_in_array_RREADY : OUT STD_LOGIC;
        m_axi_in_array_RDATA : IN STD_LOGIC_VECTOR (31 downto 0);
        m_axi_in_array_RLAST : IN STD_LOGIC;
        m_axi_in_array_RID : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_RUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_BVALID : IN STD_LOGIC;
        m_axi_in_array_BREADY : OUT STD_LOGIC;
        m_axi_in_array_BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        m_axi_in_array_BID : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_in_array_BUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        in_array_offset : IN STD_LOGIC_VECTOR (31 downto 0);
        out_array_offset : IN STD_LOGIC_VECTOR (31 downto 0);
        out_array_offset_out_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        out_array_offset_out_full_n : IN STD_LOGIC;
        out_array_offset_out_write : OUT STD_LOGIC );
    end component;


    component convolve IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        in_stream_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        in_stream_V_empty_n : IN STD_LOGIC;
        in_stream_V_read : OUT STD_LOGIC;
        out_stream_V_din : OUT STD_LOGIC_VECTOR (31 downto 0);
        out_stream_V_full_n : IN STD_LOGIC;
        out_stream_V_write : OUT STD_LOGIC );
    end component;


    component write_pixel IS
    port (
        ap_clk : IN STD_LOGIC;
        ap_rst : IN STD_LOGIC;
        ap_start : IN STD_LOGIC;
        ap_done : OUT STD_LOGIC;
        ap_continue : IN STD_LOGIC;
        ap_idle : OUT STD_LOGIC;
        ap_ready : OUT STD_LOGIC;
        out_stream_V_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        out_stream_V_empty_n : IN STD_LOGIC;
        out_stream_V_read : OUT STD_LOGIC;
        m_axi_out_array_AWVALID : OUT STD_LOGIC;
        m_axi_out_array_AWREADY : IN STD_LOGIC;
        m_axi_out_array_AWADDR : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_AWID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_AWLEN : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_out_array_AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_out_array_AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_AWUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_WVALID : OUT STD_LOGIC;
        m_axi_out_array_WREADY : IN STD_LOGIC;
        m_axi_out_array_WDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_WSTRB : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_WLAST : OUT STD_LOGIC;
        m_axi_out_array_WID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_WUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_ARVALID : OUT STD_LOGIC;
        m_axi_out_array_ARREADY : IN STD_LOGIC;
        m_axi_out_array_ARADDR : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_ARID : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_ARLEN : OUT STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_out_array_ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        m_axi_out_array_ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        m_axi_out_array_ARUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_RVALID : IN STD_LOGIC;
        m_axi_out_array_RREADY : OUT STD_LOGIC;
        m_axi_out_array_RDATA : IN STD_LOGIC_VECTOR (31 downto 0);
        m_axi_out_array_RLAST : IN STD_LOGIC;
        m_axi_out_array_RID : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_RUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_BVALID : IN STD_LOGIC;
        m_axi_out_array_BREADY : OUT STD_LOGIC;
        m_axi_out_array_BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        m_axi_out_array_BID : IN STD_LOGIC_VECTOR (0 downto 0);
        m_axi_out_array_BUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        out_array_offset_dout : IN STD_LOGIC_VECTOR (31 downto 0);
        out_array_offset_empty_n : IN STD_LOGIC;
        out_array_offset_read : OUT STD_LOGIC );
    end component;


    component fifo_w32_d32_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (31 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (31 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component fifo_w32_d2_A IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (31 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (31 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_convolvfYi IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component start_for_write_pg8j IS
    port (
        clk : IN STD_LOGIC;
        reset : IN STD_LOGIC;
        if_read_ce : IN STD_LOGIC;
        if_write_ce : IN STD_LOGIC;
        if_din : IN STD_LOGIC_VECTOR (0 downto 0);
        if_full_n : OUT STD_LOGIC;
        if_write : IN STD_LOGIC;
        if_dout : OUT STD_LOGIC_VECTOR (0 downto 0);
        if_empty_n : OUT STD_LOGIC;
        if_read : IN STD_LOGIC );
    end component;


    component conv_stream_AXILiteS_s_axi IS
    generic (
        C_S_AXI_ADDR_WIDTH : INTEGER;
        C_S_AXI_DATA_WIDTH : INTEGER );
    port (
        AWVALID : IN STD_LOGIC;
        AWREADY : OUT STD_LOGIC;
        AWADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        WVALID : IN STD_LOGIC;
        WREADY : OUT STD_LOGIC;
        WDATA : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : IN STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH/8-1 downto 0);
        ARVALID : IN STD_LOGIC;
        ARREADY : OUT STD_LOGIC;
        ARADDR : IN STD_LOGIC_VECTOR (C_S_AXI_ADDR_WIDTH-1 downto 0);
        RVALID : OUT STD_LOGIC;
        RREADY : IN STD_LOGIC;
        RDATA : OUT STD_LOGIC_VECTOR (C_S_AXI_DATA_WIDTH-1 downto 0);
        RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        BVALID : OUT STD_LOGIC;
        BREADY : IN STD_LOGIC;
        BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        ap_start : OUT STD_LOGIC;
        interrupt : OUT STD_LOGIC;
        ap_ready : IN STD_LOGIC;
        ap_done : IN STD_LOGIC;
        ap_idle : IN STD_LOGIC;
        in_array_offset : OUT STD_LOGIC_VECTOR (31 downto 0);
        out_array_offset : OUT STD_LOGIC_VECTOR (31 downto 0) );
    end component;


    component conv_stream_in_array_m_axi IS
    generic (
        USER_DW : INTEGER;
        USER_AW : INTEGER;
        USER_MAXREQS : INTEGER;
        NUM_READ_OUTSTANDING : INTEGER;
        NUM_WRITE_OUTSTANDING : INTEGER;
        MAX_READ_BURST_LENGTH : INTEGER;
        MAX_WRITE_BURST_LENGTH : INTEGER;
        C_M_AXI_ID_WIDTH : INTEGER;
        C_M_AXI_ADDR_WIDTH : INTEGER;
        C_M_AXI_DATA_WIDTH : INTEGER;
        C_M_AXI_AWUSER_WIDTH : INTEGER;
        C_M_AXI_ARUSER_WIDTH : INTEGER;
        C_M_AXI_WUSER_WIDTH : INTEGER;
        C_M_AXI_RUSER_WIDTH : INTEGER;
        C_M_AXI_BUSER_WIDTH : INTEGER;
        C_USER_VALUE : INTEGER;
        C_PROT_VALUE : INTEGER;
        C_CACHE_VALUE : INTEGER );
    port (
        AWVALID : OUT STD_LOGIC;
        AWREADY : IN STD_LOGIC;
        AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_AWUSER_WIDTH-1 downto 0);
        WVALID : OUT STD_LOGIC;
        WREADY : IN STD_LOGIC;
        WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH/8-1 downto 0);
        WLAST : OUT STD_LOGIC;
        WID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_WUSER_WIDTH-1 downto 0);
        ARVALID : OUT STD_LOGIC;
        ARREADY : IN STD_LOGIC;
        ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_ARUSER_WIDTH-1 downto 0);
        RVALID : IN STD_LOGIC;
        RREADY : OUT STD_LOGIC;
        RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        RLAST : IN STD_LOGIC;
        RID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_RUSER_WIDTH-1 downto 0);
        RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BVALID : IN STD_LOGIC;
        BREADY : OUT STD_LOGIC;
        BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_BUSER_WIDTH-1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        I_ARVALID : IN STD_LOGIC;
        I_ARREADY : OUT STD_LOGIC;
        I_ARADDR : IN STD_LOGIC_VECTOR (31 downto 0);
        I_ARID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_ARLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_ARSIZE : IN STD_LOGIC_VECTOR (2 downto 0);
        I_ARLOCK : IN STD_LOGIC_VECTOR (1 downto 0);
        I_ARCACHE : IN STD_LOGIC_VECTOR (3 downto 0);
        I_ARQOS : IN STD_LOGIC_VECTOR (3 downto 0);
        I_ARPROT : IN STD_LOGIC_VECTOR (2 downto 0);
        I_ARUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_ARBURST : IN STD_LOGIC_VECTOR (1 downto 0);
        I_ARREGION : IN STD_LOGIC_VECTOR (3 downto 0);
        I_RVALID : OUT STD_LOGIC;
        I_RREADY : IN STD_LOGIC;
        I_RDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
        I_RID : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_RUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        I_RLAST : OUT STD_LOGIC;
        I_AWVALID : IN STD_LOGIC;
        I_AWREADY : OUT STD_LOGIC;
        I_AWADDR : IN STD_LOGIC_VECTOR (31 downto 0);
        I_AWID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_AWLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_AWSIZE : IN STD_LOGIC_VECTOR (2 downto 0);
        I_AWLOCK : IN STD_LOGIC_VECTOR (1 downto 0);
        I_AWCACHE : IN STD_LOGIC_VECTOR (3 downto 0);
        I_AWQOS : IN STD_LOGIC_VECTOR (3 downto 0);
        I_AWPROT : IN STD_LOGIC_VECTOR (2 downto 0);
        I_AWUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_AWBURST : IN STD_LOGIC_VECTOR (1 downto 0);
        I_AWREGION : IN STD_LOGIC_VECTOR (3 downto 0);
        I_WVALID : IN STD_LOGIC;
        I_WREADY : OUT STD_LOGIC;
        I_WDATA : IN STD_LOGIC_VECTOR (31 downto 0);
        I_WID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_WUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_WLAST : IN STD_LOGIC;
        I_WSTRB : IN STD_LOGIC_VECTOR (3 downto 0);
        I_BVALID : OUT STD_LOGIC;
        I_BREADY : IN STD_LOGIC;
        I_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        I_BID : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_BUSER : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;


    component conv_stream_out_array_m_axi IS
    generic (
        USER_DW : INTEGER;
        USER_AW : INTEGER;
        USER_MAXREQS : INTEGER;
        NUM_READ_OUTSTANDING : INTEGER;
        NUM_WRITE_OUTSTANDING : INTEGER;
        MAX_READ_BURST_LENGTH : INTEGER;
        MAX_WRITE_BURST_LENGTH : INTEGER;
        C_M_AXI_ID_WIDTH : INTEGER;
        C_M_AXI_ADDR_WIDTH : INTEGER;
        C_M_AXI_DATA_WIDTH : INTEGER;
        C_M_AXI_AWUSER_WIDTH : INTEGER;
        C_M_AXI_ARUSER_WIDTH : INTEGER;
        C_M_AXI_WUSER_WIDTH : INTEGER;
        C_M_AXI_RUSER_WIDTH : INTEGER;
        C_M_AXI_BUSER_WIDTH : INTEGER;
        C_USER_VALUE : INTEGER;
        C_PROT_VALUE : INTEGER;
        C_CACHE_VALUE : INTEGER );
    port (
        AWVALID : OUT STD_LOGIC;
        AWREADY : IN STD_LOGIC;
        AWADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        AWID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        AWLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        AWSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        AWCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        AWQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        AWUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_AWUSER_WIDTH-1 downto 0);
        WVALID : OUT STD_LOGIC;
        WREADY : IN STD_LOGIC;
        WDATA : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        WSTRB : OUT STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH/8-1 downto 0);
        WLAST : OUT STD_LOGIC;
        WID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        WUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_WUSER_WIDTH-1 downto 0);
        ARVALID : OUT STD_LOGIC;
        ARREADY : IN STD_LOGIC;
        ARADDR : OUT STD_LOGIC_VECTOR (C_M_AXI_ADDR_WIDTH-1 downto 0);
        ARID : OUT STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        ARLEN : OUT STD_LOGIC_VECTOR (7 downto 0);
        ARSIZE : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARBURST : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARLOCK : OUT STD_LOGIC_VECTOR (1 downto 0);
        ARCACHE : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARPROT : OUT STD_LOGIC_VECTOR (2 downto 0);
        ARQOS : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARREGION : OUT STD_LOGIC_VECTOR (3 downto 0);
        ARUSER : OUT STD_LOGIC_VECTOR (C_M_AXI_ARUSER_WIDTH-1 downto 0);
        RVALID : IN STD_LOGIC;
        RREADY : OUT STD_LOGIC;
        RDATA : IN STD_LOGIC_VECTOR (C_M_AXI_DATA_WIDTH-1 downto 0);
        RLAST : IN STD_LOGIC;
        RID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        RUSER : IN STD_LOGIC_VECTOR (C_M_AXI_RUSER_WIDTH-1 downto 0);
        RRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BVALID : IN STD_LOGIC;
        BREADY : OUT STD_LOGIC;
        BRESP : IN STD_LOGIC_VECTOR (1 downto 0);
        BID : IN STD_LOGIC_VECTOR (C_M_AXI_ID_WIDTH-1 downto 0);
        BUSER : IN STD_LOGIC_VECTOR (C_M_AXI_BUSER_WIDTH-1 downto 0);
        ACLK : IN STD_LOGIC;
        ARESET : IN STD_LOGIC;
        ACLK_EN : IN STD_LOGIC;
        I_ARVALID : IN STD_LOGIC;
        I_ARREADY : OUT STD_LOGIC;
        I_ARADDR : IN STD_LOGIC_VECTOR (31 downto 0);
        I_ARID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_ARLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_ARSIZE : IN STD_LOGIC_VECTOR (2 downto 0);
        I_ARLOCK : IN STD_LOGIC_VECTOR (1 downto 0);
        I_ARCACHE : IN STD_LOGIC_VECTOR (3 downto 0);
        I_ARQOS : IN STD_LOGIC_VECTOR (3 downto 0);
        I_ARPROT : IN STD_LOGIC_VECTOR (2 downto 0);
        I_ARUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_ARBURST : IN STD_LOGIC_VECTOR (1 downto 0);
        I_ARREGION : IN STD_LOGIC_VECTOR (3 downto 0);
        I_RVALID : OUT STD_LOGIC;
        I_RREADY : IN STD_LOGIC;
        I_RDATA : OUT STD_LOGIC_VECTOR (31 downto 0);
        I_RID : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_RUSER : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_RRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        I_RLAST : OUT STD_LOGIC;
        I_AWVALID : IN STD_LOGIC;
        I_AWREADY : OUT STD_LOGIC;
        I_AWADDR : IN STD_LOGIC_VECTOR (31 downto 0);
        I_AWID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_AWLEN : IN STD_LOGIC_VECTOR (31 downto 0);
        I_AWSIZE : IN STD_LOGIC_VECTOR (2 downto 0);
        I_AWLOCK : IN STD_LOGIC_VECTOR (1 downto 0);
        I_AWCACHE : IN STD_LOGIC_VECTOR (3 downto 0);
        I_AWQOS : IN STD_LOGIC_VECTOR (3 downto 0);
        I_AWPROT : IN STD_LOGIC_VECTOR (2 downto 0);
        I_AWUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_AWBURST : IN STD_LOGIC_VECTOR (1 downto 0);
        I_AWREGION : IN STD_LOGIC_VECTOR (3 downto 0);
        I_WVALID : IN STD_LOGIC;
        I_WREADY : OUT STD_LOGIC;
        I_WDATA : IN STD_LOGIC_VECTOR (31 downto 0);
        I_WID : IN STD_LOGIC_VECTOR (0 downto 0);
        I_WUSER : IN STD_LOGIC_VECTOR (0 downto 0);
        I_WLAST : IN STD_LOGIC;
        I_WSTRB : IN STD_LOGIC_VECTOR (3 downto 0);
        I_BVALID : OUT STD_LOGIC;
        I_BREADY : IN STD_LOGIC;
        I_BRESP : OUT STD_LOGIC_VECTOR (1 downto 0);
        I_BID : OUT STD_LOGIC_VECTOR (0 downto 0);
        I_BUSER : OUT STD_LOGIC_VECTOR (0 downto 0) );
    end component;



begin
    conv_stream_AXILiteS_s_axi_U : component conv_stream_AXILiteS_s_axi
    generic map (
        C_S_AXI_ADDR_WIDTH => C_S_AXI_AXILITES_ADDR_WIDTH,
        C_S_AXI_DATA_WIDTH => C_S_AXI_AXILITES_DATA_WIDTH)
    port map (
        AWVALID => s_axi_AXILiteS_AWVALID,
        AWREADY => s_axi_AXILiteS_AWREADY,
        AWADDR => s_axi_AXILiteS_AWADDR,
        WVALID => s_axi_AXILiteS_WVALID,
        WREADY => s_axi_AXILiteS_WREADY,
        WDATA => s_axi_AXILiteS_WDATA,
        WSTRB => s_axi_AXILiteS_WSTRB,
        ARVALID => s_axi_AXILiteS_ARVALID,
        ARREADY => s_axi_AXILiteS_ARREADY,
        ARADDR => s_axi_AXILiteS_ARADDR,
        RVALID => s_axi_AXILiteS_RVALID,
        RREADY => s_axi_AXILiteS_RREADY,
        RDATA => s_axi_AXILiteS_RDATA,
        RRESP => s_axi_AXILiteS_RRESP,
        BVALID => s_axi_AXILiteS_BVALID,
        BREADY => s_axi_AXILiteS_BREADY,
        BRESP => s_axi_AXILiteS_BRESP,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        ap_start => ap_start,
        interrupt => interrupt,
        ap_ready => ap_ready,
        ap_done => ap_done,
        ap_idle => ap_idle,
        in_array_offset => in_array_offset,
        out_array_offset => out_array_offset);

    conv_stream_in_array_m_axi_U : component conv_stream_in_array_m_axi
    generic map (
        USER_DW => 32,
        USER_AW => 32,
        USER_MAXREQS => 5,
        NUM_READ_OUTSTANDING => 16,
        NUM_WRITE_OUTSTANDING => 16,
        MAX_READ_BURST_LENGTH => 16,
        MAX_WRITE_BURST_LENGTH => 16,
        C_M_AXI_ID_WIDTH => C_M_AXI_IN_ARRAY_ID_WIDTH,
        C_M_AXI_ADDR_WIDTH => C_M_AXI_IN_ARRAY_ADDR_WIDTH,
        C_M_AXI_DATA_WIDTH => C_M_AXI_IN_ARRAY_DATA_WIDTH,
        C_M_AXI_AWUSER_WIDTH => C_M_AXI_IN_ARRAY_AWUSER_WIDTH,
        C_M_AXI_ARUSER_WIDTH => C_M_AXI_IN_ARRAY_ARUSER_WIDTH,
        C_M_AXI_WUSER_WIDTH => C_M_AXI_IN_ARRAY_WUSER_WIDTH,
        C_M_AXI_RUSER_WIDTH => C_M_AXI_IN_ARRAY_RUSER_WIDTH,
        C_M_AXI_BUSER_WIDTH => C_M_AXI_IN_ARRAY_BUSER_WIDTH,
        C_USER_VALUE => C_M_AXI_IN_ARRAY_USER_VALUE,
        C_PROT_VALUE => C_M_AXI_IN_ARRAY_PROT_VALUE,
        C_CACHE_VALUE => C_M_AXI_IN_ARRAY_CACHE_VALUE)
    port map (
        AWVALID => m_axi_in_array_AWVALID,
        AWREADY => m_axi_in_array_AWREADY,
        AWADDR => m_axi_in_array_AWADDR,
        AWID => m_axi_in_array_AWID,
        AWLEN => m_axi_in_array_AWLEN,
        AWSIZE => m_axi_in_array_AWSIZE,
        AWBURST => m_axi_in_array_AWBURST,
        AWLOCK => m_axi_in_array_AWLOCK,
        AWCACHE => m_axi_in_array_AWCACHE,
        AWPROT => m_axi_in_array_AWPROT,
        AWQOS => m_axi_in_array_AWQOS,
        AWREGION => m_axi_in_array_AWREGION,
        AWUSER => m_axi_in_array_AWUSER,
        WVALID => m_axi_in_array_WVALID,
        WREADY => m_axi_in_array_WREADY,
        WDATA => m_axi_in_array_WDATA,
        WSTRB => m_axi_in_array_WSTRB,
        WLAST => m_axi_in_array_WLAST,
        WID => m_axi_in_array_WID,
        WUSER => m_axi_in_array_WUSER,
        ARVALID => m_axi_in_array_ARVALID,
        ARREADY => m_axi_in_array_ARREADY,
        ARADDR => m_axi_in_array_ARADDR,
        ARID => m_axi_in_array_ARID,
        ARLEN => m_axi_in_array_ARLEN,
        ARSIZE => m_axi_in_array_ARSIZE,
        ARBURST => m_axi_in_array_ARBURST,
        ARLOCK => m_axi_in_array_ARLOCK,
        ARCACHE => m_axi_in_array_ARCACHE,
        ARPROT => m_axi_in_array_ARPROT,
        ARQOS => m_axi_in_array_ARQOS,
        ARREGION => m_axi_in_array_ARREGION,
        ARUSER => m_axi_in_array_ARUSER,
        RVALID => m_axi_in_array_RVALID,
        RREADY => m_axi_in_array_RREADY,
        RDATA => m_axi_in_array_RDATA,
        RLAST => m_axi_in_array_RLAST,
        RID => m_axi_in_array_RID,
        RUSER => m_axi_in_array_RUSER,
        RRESP => m_axi_in_array_RRESP,
        BVALID => m_axi_in_array_BVALID,
        BREADY => m_axi_in_array_BREADY,
        BRESP => m_axi_in_array_BRESP,
        BID => m_axi_in_array_BID,
        BUSER => m_axi_in_array_BUSER,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        I_ARVALID => read_pixel13_U0_m_axi_in_array_ARVALID,
        I_ARREADY => in_array_ARREADY,
        I_ARADDR => read_pixel13_U0_m_axi_in_array_ARADDR,
        I_ARID => read_pixel13_U0_m_axi_in_array_ARID,
        I_ARLEN => read_pixel13_U0_m_axi_in_array_ARLEN,
        I_ARSIZE => read_pixel13_U0_m_axi_in_array_ARSIZE,
        I_ARLOCK => read_pixel13_U0_m_axi_in_array_ARLOCK,
        I_ARCACHE => read_pixel13_U0_m_axi_in_array_ARCACHE,
        I_ARQOS => read_pixel13_U0_m_axi_in_array_ARQOS,
        I_ARPROT => read_pixel13_U0_m_axi_in_array_ARPROT,
        I_ARUSER => read_pixel13_U0_m_axi_in_array_ARUSER,
        I_ARBURST => read_pixel13_U0_m_axi_in_array_ARBURST,
        I_ARREGION => read_pixel13_U0_m_axi_in_array_ARREGION,
        I_RVALID => in_array_RVALID,
        I_RREADY => read_pixel13_U0_m_axi_in_array_RREADY,
        I_RDATA => in_array_RDATA,
        I_RID => in_array_RID,
        I_RUSER => in_array_RUSER,
        I_RRESP => in_array_RRESP,
        I_RLAST => in_array_RLAST,
        I_AWVALID => ap_const_logic_0,
        I_AWREADY => in_array_AWREADY,
        I_AWADDR => ap_const_lv32_0,
        I_AWID => ap_const_lv1_0,
        I_AWLEN => ap_const_lv32_0,
        I_AWSIZE => ap_const_lv3_0,
        I_AWLOCK => ap_const_lv2_0,
        I_AWCACHE => ap_const_lv4_0,
        I_AWQOS => ap_const_lv4_0,
        I_AWPROT => ap_const_lv3_0,
        I_AWUSER => ap_const_lv1_0,
        I_AWBURST => ap_const_lv2_0,
        I_AWREGION => ap_const_lv4_0,
        I_WVALID => ap_const_logic_0,
        I_WREADY => in_array_WREADY,
        I_WDATA => ap_const_lv32_0,
        I_WID => ap_const_lv1_0,
        I_WUSER => ap_const_lv1_0,
        I_WLAST => ap_const_logic_0,
        I_WSTRB => ap_const_lv4_0,
        I_BVALID => in_array_BVALID,
        I_BREADY => ap_const_logic_0,
        I_BRESP => in_array_BRESP,
        I_BID => in_array_BID,
        I_BUSER => in_array_BUSER);

    conv_stream_out_array_m_axi_U : component conv_stream_out_array_m_axi
    generic map (
        USER_DW => 32,
        USER_AW => 32,
        USER_MAXREQS => 5,
        NUM_READ_OUTSTANDING => 16,
        NUM_WRITE_OUTSTANDING => 16,
        MAX_READ_BURST_LENGTH => 16,
        MAX_WRITE_BURST_LENGTH => 16,
        C_M_AXI_ID_WIDTH => C_M_AXI_OUT_ARRAY_ID_WIDTH,
        C_M_AXI_ADDR_WIDTH => C_M_AXI_OUT_ARRAY_ADDR_WIDTH,
        C_M_AXI_DATA_WIDTH => C_M_AXI_OUT_ARRAY_DATA_WIDTH,
        C_M_AXI_AWUSER_WIDTH => C_M_AXI_OUT_ARRAY_AWUSER_WIDTH,
        C_M_AXI_ARUSER_WIDTH => C_M_AXI_OUT_ARRAY_ARUSER_WIDTH,
        C_M_AXI_WUSER_WIDTH => C_M_AXI_OUT_ARRAY_WUSER_WIDTH,
        C_M_AXI_RUSER_WIDTH => C_M_AXI_OUT_ARRAY_RUSER_WIDTH,
        C_M_AXI_BUSER_WIDTH => C_M_AXI_OUT_ARRAY_BUSER_WIDTH,
        C_USER_VALUE => C_M_AXI_OUT_ARRAY_USER_VALUE,
        C_PROT_VALUE => C_M_AXI_OUT_ARRAY_PROT_VALUE,
        C_CACHE_VALUE => C_M_AXI_OUT_ARRAY_CACHE_VALUE)
    port map (
        AWVALID => m_axi_out_array_AWVALID,
        AWREADY => m_axi_out_array_AWREADY,
        AWADDR => m_axi_out_array_AWADDR,
        AWID => m_axi_out_array_AWID,
        AWLEN => m_axi_out_array_AWLEN,
        AWSIZE => m_axi_out_array_AWSIZE,
        AWBURST => m_axi_out_array_AWBURST,
        AWLOCK => m_axi_out_array_AWLOCK,
        AWCACHE => m_axi_out_array_AWCACHE,
        AWPROT => m_axi_out_array_AWPROT,
        AWQOS => m_axi_out_array_AWQOS,
        AWREGION => m_axi_out_array_AWREGION,
        AWUSER => m_axi_out_array_AWUSER,
        WVALID => m_axi_out_array_WVALID,
        WREADY => m_axi_out_array_WREADY,
        WDATA => m_axi_out_array_WDATA,
        WSTRB => m_axi_out_array_WSTRB,
        WLAST => m_axi_out_array_WLAST,
        WID => m_axi_out_array_WID,
        WUSER => m_axi_out_array_WUSER,
        ARVALID => m_axi_out_array_ARVALID,
        ARREADY => m_axi_out_array_ARREADY,
        ARADDR => m_axi_out_array_ARADDR,
        ARID => m_axi_out_array_ARID,
        ARLEN => m_axi_out_array_ARLEN,
        ARSIZE => m_axi_out_array_ARSIZE,
        ARBURST => m_axi_out_array_ARBURST,
        ARLOCK => m_axi_out_array_ARLOCK,
        ARCACHE => m_axi_out_array_ARCACHE,
        ARPROT => m_axi_out_array_ARPROT,
        ARQOS => m_axi_out_array_ARQOS,
        ARREGION => m_axi_out_array_ARREGION,
        ARUSER => m_axi_out_array_ARUSER,
        RVALID => m_axi_out_array_RVALID,
        RREADY => m_axi_out_array_RREADY,
        RDATA => m_axi_out_array_RDATA,
        RLAST => m_axi_out_array_RLAST,
        RID => m_axi_out_array_RID,
        RUSER => m_axi_out_array_RUSER,
        RRESP => m_axi_out_array_RRESP,
        BVALID => m_axi_out_array_BVALID,
        BREADY => m_axi_out_array_BREADY,
        BRESP => m_axi_out_array_BRESP,
        BID => m_axi_out_array_BID,
        BUSER => m_axi_out_array_BUSER,
        ACLK => ap_clk,
        ARESET => ap_rst_n_inv,
        ACLK_EN => ap_const_logic_1,
        I_ARVALID => ap_const_logic_0,
        I_ARREADY => out_array_ARREADY,
        I_ARADDR => ap_const_lv32_0,
        I_ARID => ap_const_lv1_0,
        I_ARLEN => ap_const_lv32_0,
        I_ARSIZE => ap_const_lv3_0,
        I_ARLOCK => ap_const_lv2_0,
        I_ARCACHE => ap_const_lv4_0,
        I_ARQOS => ap_const_lv4_0,
        I_ARPROT => ap_const_lv3_0,
        I_ARUSER => ap_const_lv1_0,
        I_ARBURST => ap_const_lv2_0,
        I_ARREGION => ap_const_lv4_0,
        I_RVALID => out_array_RVALID,
        I_RREADY => ap_const_logic_0,
        I_RDATA => out_array_RDATA,
        I_RID => out_array_RID,
        I_RUSER => out_array_RUSER,
        I_RRESP => out_array_RRESP,
        I_RLAST => out_array_RLAST,
        I_AWVALID => write_pixel_U0_m_axi_out_array_AWVALID,
        I_AWREADY => out_array_AWREADY,
        I_AWADDR => write_pixel_U0_m_axi_out_array_AWADDR,
        I_AWID => write_pixel_U0_m_axi_out_array_AWID,
        I_AWLEN => write_pixel_U0_m_axi_out_array_AWLEN,
        I_AWSIZE => write_pixel_U0_m_axi_out_array_AWSIZE,
        I_AWLOCK => write_pixel_U0_m_axi_out_array_AWLOCK,
        I_AWCACHE => write_pixel_U0_m_axi_out_array_AWCACHE,
        I_AWQOS => write_pixel_U0_m_axi_out_array_AWQOS,
        I_AWPROT => write_pixel_U0_m_axi_out_array_AWPROT,
        I_AWUSER => write_pixel_U0_m_axi_out_array_AWUSER,
        I_AWBURST => write_pixel_U0_m_axi_out_array_AWBURST,
        I_AWREGION => write_pixel_U0_m_axi_out_array_AWREGION,
        I_WVALID => write_pixel_U0_m_axi_out_array_WVALID,
        I_WREADY => out_array_WREADY,
        I_WDATA => write_pixel_U0_m_axi_out_array_WDATA,
        I_WID => write_pixel_U0_m_axi_out_array_WID,
        I_WUSER => write_pixel_U0_m_axi_out_array_WUSER,
        I_WLAST => write_pixel_U0_m_axi_out_array_WLAST,
        I_WSTRB => write_pixel_U0_m_axi_out_array_WSTRB,
        I_BVALID => out_array_BVALID,
        I_BREADY => write_pixel_U0_m_axi_out_array_BREADY,
        I_BRESP => out_array_BRESP,
        I_BID => out_array_BID,
        I_BUSER => out_array_BUSER);

    read_pixel13_U0 : component read_pixel13
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => read_pixel13_U0_ap_start,
        start_full_n => read_pixel13_U0_start_full_n,
        ap_done => read_pixel13_U0_ap_done,
        ap_continue => read_pixel13_U0_ap_continue,
        ap_idle => read_pixel13_U0_ap_idle,
        ap_ready => read_pixel13_U0_ap_ready,
        start_out => read_pixel13_U0_start_out,
        start_write => read_pixel13_U0_start_write,
        in_stream_V_din => read_pixel13_U0_in_stream_V_din,
        in_stream_V_full_n => in_stream_V_full_n,
        in_stream_V_write => read_pixel13_U0_in_stream_V_write,
        m_axi_in_array_AWVALID => read_pixel13_U0_m_axi_in_array_AWVALID,
        m_axi_in_array_AWREADY => ap_const_logic_0,
        m_axi_in_array_AWADDR => read_pixel13_U0_m_axi_in_array_AWADDR,
        m_axi_in_array_AWID => read_pixel13_U0_m_axi_in_array_AWID,
        m_axi_in_array_AWLEN => read_pixel13_U0_m_axi_in_array_AWLEN,
        m_axi_in_array_AWSIZE => read_pixel13_U0_m_axi_in_array_AWSIZE,
        m_axi_in_array_AWBURST => read_pixel13_U0_m_axi_in_array_AWBURST,
        m_axi_in_array_AWLOCK => read_pixel13_U0_m_axi_in_array_AWLOCK,
        m_axi_in_array_AWCACHE => read_pixel13_U0_m_axi_in_array_AWCACHE,
        m_axi_in_array_AWPROT => read_pixel13_U0_m_axi_in_array_AWPROT,
        m_axi_in_array_AWQOS => read_pixel13_U0_m_axi_in_array_AWQOS,
        m_axi_in_array_AWREGION => read_pixel13_U0_m_axi_in_array_AWREGION,
        m_axi_in_array_AWUSER => read_pixel13_U0_m_axi_in_array_AWUSER,
        m_axi_in_array_WVALID => read_pixel13_U0_m_axi_in_array_WVALID,
        m_axi_in_array_WREADY => ap_const_logic_0,
        m_axi_in_array_WDATA => read_pixel13_U0_m_axi_in_array_WDATA,
        m_axi_in_array_WSTRB => read_pixel13_U0_m_axi_in_array_WSTRB,
        m_axi_in_array_WLAST => read_pixel13_U0_m_axi_in_array_WLAST,
        m_axi_in_array_WID => read_pixel13_U0_m_axi_in_array_WID,
        m_axi_in_array_WUSER => read_pixel13_U0_m_axi_in_array_WUSER,
        m_axi_in_array_ARVALID => read_pixel13_U0_m_axi_in_array_ARVALID,
        m_axi_in_array_ARREADY => in_array_ARREADY,
        m_axi_in_array_ARADDR => read_pixel13_U0_m_axi_in_array_ARADDR,
        m_axi_in_array_ARID => read_pixel13_U0_m_axi_in_array_ARID,
        m_axi_in_array_ARLEN => read_pixel13_U0_m_axi_in_array_ARLEN,
        m_axi_in_array_ARSIZE => read_pixel13_U0_m_axi_in_array_ARSIZE,
        m_axi_in_array_ARBURST => read_pixel13_U0_m_axi_in_array_ARBURST,
        m_axi_in_array_ARLOCK => read_pixel13_U0_m_axi_in_array_ARLOCK,
        m_axi_in_array_ARCACHE => read_pixel13_U0_m_axi_in_array_ARCACHE,
        m_axi_in_array_ARPROT => read_pixel13_U0_m_axi_in_array_ARPROT,
        m_axi_in_array_ARQOS => read_pixel13_U0_m_axi_in_array_ARQOS,
        m_axi_in_array_ARREGION => read_pixel13_U0_m_axi_in_array_ARREGION,
        m_axi_in_array_ARUSER => read_pixel13_U0_m_axi_in_array_ARUSER,
        m_axi_in_array_RVALID => in_array_RVALID,
        m_axi_in_array_RREADY => read_pixel13_U0_m_axi_in_array_RREADY,
        m_axi_in_array_RDATA => in_array_RDATA,
        m_axi_in_array_RLAST => in_array_RLAST,
        m_axi_in_array_RID => in_array_RID,
        m_axi_in_array_RUSER => in_array_RUSER,
        m_axi_in_array_RRESP => in_array_RRESP,
        m_axi_in_array_BVALID => ap_const_logic_0,
        m_axi_in_array_BREADY => read_pixel13_U0_m_axi_in_array_BREADY,
        m_axi_in_array_BRESP => ap_const_lv2_0,
        m_axi_in_array_BID => ap_const_lv1_0,
        m_axi_in_array_BUSER => ap_const_lv1_0,
        in_array_offset => in_array_offset,
        out_array_offset => out_array_offset,
        out_array_offset_out_din => read_pixel13_U0_out_array_offset_out_din,
        out_array_offset_out_full_n => out_array_offset_c_full_n,
        out_array_offset_out_write => read_pixel13_U0_out_array_offset_out_write);

    convolve_U0 : component convolve
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => convolve_U0_ap_start,
        ap_done => convolve_U0_ap_done,
        ap_continue => convolve_U0_ap_continue,
        ap_idle => convolve_U0_ap_idle,
        ap_ready => convolve_U0_ap_ready,
        in_stream_V_dout => in_stream_V_dout,
        in_stream_V_empty_n => in_stream_V_empty_n,
        in_stream_V_read => convolve_U0_in_stream_V_read,
        out_stream_V_din => convolve_U0_out_stream_V_din,
        out_stream_V_full_n => out_stream_V_full_n,
        out_stream_V_write => convolve_U0_out_stream_V_write);

    write_pixel_U0 : component write_pixel
    port map (
        ap_clk => ap_clk,
        ap_rst => ap_rst_n_inv,
        ap_start => write_pixel_U0_ap_start,
        ap_done => write_pixel_U0_ap_done,
        ap_continue => write_pixel_U0_ap_continue,
        ap_idle => write_pixel_U0_ap_idle,
        ap_ready => write_pixel_U0_ap_ready,
        out_stream_V_dout => out_stream_V_dout,
        out_stream_V_empty_n => out_stream_V_empty_n,
        out_stream_V_read => write_pixel_U0_out_stream_V_read,
        m_axi_out_array_AWVALID => write_pixel_U0_m_axi_out_array_AWVALID,
        m_axi_out_array_AWREADY => out_array_AWREADY,
        m_axi_out_array_AWADDR => write_pixel_U0_m_axi_out_array_AWADDR,
        m_axi_out_array_AWID => write_pixel_U0_m_axi_out_array_AWID,
        m_axi_out_array_AWLEN => write_pixel_U0_m_axi_out_array_AWLEN,
        m_axi_out_array_AWSIZE => write_pixel_U0_m_axi_out_array_AWSIZE,
        m_axi_out_array_AWBURST => write_pixel_U0_m_axi_out_array_AWBURST,
        m_axi_out_array_AWLOCK => write_pixel_U0_m_axi_out_array_AWLOCK,
        m_axi_out_array_AWCACHE => write_pixel_U0_m_axi_out_array_AWCACHE,
        m_axi_out_array_AWPROT => write_pixel_U0_m_axi_out_array_AWPROT,
        m_axi_out_array_AWQOS => write_pixel_U0_m_axi_out_array_AWQOS,
        m_axi_out_array_AWREGION => write_pixel_U0_m_axi_out_array_AWREGION,
        m_axi_out_array_AWUSER => write_pixel_U0_m_axi_out_array_AWUSER,
        m_axi_out_array_WVALID => write_pixel_U0_m_axi_out_array_WVALID,
        m_axi_out_array_WREADY => out_array_WREADY,
        m_axi_out_array_WDATA => write_pixel_U0_m_axi_out_array_WDATA,
        m_axi_out_array_WSTRB => write_pixel_U0_m_axi_out_array_WSTRB,
        m_axi_out_array_WLAST => write_pixel_U0_m_axi_out_array_WLAST,
        m_axi_out_array_WID => write_pixel_U0_m_axi_out_array_WID,
        m_axi_out_array_WUSER => write_pixel_U0_m_axi_out_array_WUSER,
        m_axi_out_array_ARVALID => write_pixel_U0_m_axi_out_array_ARVALID,
        m_axi_out_array_ARREADY => ap_const_logic_0,
        m_axi_out_array_ARADDR => write_pixel_U0_m_axi_out_array_ARADDR,
        m_axi_out_array_ARID => write_pixel_U0_m_axi_out_array_ARID,
        m_axi_out_array_ARLEN => write_pixel_U0_m_axi_out_array_ARLEN,
        m_axi_out_array_ARSIZE => write_pixel_U0_m_axi_out_array_ARSIZE,
        m_axi_out_array_ARBURST => write_pixel_U0_m_axi_out_array_ARBURST,
        m_axi_out_array_ARLOCK => write_pixel_U0_m_axi_out_array_ARLOCK,
        m_axi_out_array_ARCACHE => write_pixel_U0_m_axi_out_array_ARCACHE,
        m_axi_out_array_ARPROT => write_pixel_U0_m_axi_out_array_ARPROT,
        m_axi_out_array_ARQOS => write_pixel_U0_m_axi_out_array_ARQOS,
        m_axi_out_array_ARREGION => write_pixel_U0_m_axi_out_array_ARREGION,
        m_axi_out_array_ARUSER => write_pixel_U0_m_axi_out_array_ARUSER,
        m_axi_out_array_RVALID => ap_const_logic_0,
        m_axi_out_array_RREADY => write_pixel_U0_m_axi_out_array_RREADY,
        m_axi_out_array_RDATA => ap_const_lv32_0,
        m_axi_out_array_RLAST => ap_const_logic_0,
        m_axi_out_array_RID => ap_const_lv1_0,
        m_axi_out_array_RUSER => ap_const_lv1_0,
        m_axi_out_array_RRESP => ap_const_lv2_0,
        m_axi_out_array_BVALID => out_array_BVALID,
        m_axi_out_array_BREADY => write_pixel_U0_m_axi_out_array_BREADY,
        m_axi_out_array_BRESP => out_array_BRESP,
        m_axi_out_array_BID => out_array_BID,
        m_axi_out_array_BUSER => out_array_BUSER,
        out_array_offset_dout => out_array_offset_c_dout,
        out_array_offset_empty_n => out_array_offset_c_empty_n,
        out_array_offset_read => write_pixel_U0_out_array_offset_read);

    in_stream_V_U : component fifo_w32_d32_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => read_pixel13_U0_in_stream_V_din,
        if_full_n => in_stream_V_full_n,
        if_write => read_pixel13_U0_in_stream_V_write,
        if_dout => in_stream_V_dout,
        if_empty_n => in_stream_V_empty_n,
        if_read => convolve_U0_in_stream_V_read);

    out_array_offset_c_U : component fifo_w32_d2_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => read_pixel13_U0_out_array_offset_out_din,
        if_full_n => out_array_offset_c_full_n,
        if_write => read_pixel13_U0_out_array_offset_out_write,
        if_dout => out_array_offset_c_dout,
        if_empty_n => out_array_offset_c_empty_n,
        if_read => write_pixel_U0_out_array_offset_read);

    out_stream_V_U : component fifo_w32_d32_A
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => convolve_U0_out_stream_V_din,
        if_full_n => out_stream_V_full_n,
        if_write => convolve_U0_out_stream_V_write,
        if_dout => out_stream_V_dout,
        if_empty_n => out_stream_V_empty_n,
        if_read => write_pixel_U0_out_stream_V_read);

    start_for_convolvfYi_U : component start_for_convolvfYi
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_convolve_U0_din,
        if_full_n => start_for_convolve_U0_full_n,
        if_write => read_pixel13_U0_start_write,
        if_dout => start_for_convolve_U0_dout,
        if_empty_n => start_for_convolve_U0_empty_n,
        if_read => convolve_U0_ap_ready);

    start_for_write_pg8j_U : component start_for_write_pg8j
    port map (
        clk => ap_clk,
        reset => ap_rst_n_inv,
        if_read_ce => ap_const_logic_1,
        if_write_ce => ap_const_logic_1,
        if_din => start_for_write_pixel_U0_din,
        if_full_n => start_for_write_pixel_U0_full_n,
        if_write => read_pixel13_U0_start_write,
        if_dout => start_for_write_pixel_U0_dout,
        if_empty_n => start_for_write_pixel_U0_empty_n,
        if_read => write_pixel_U0_ap_ready);




    ap_done <= write_pixel_U0_ap_done;
    ap_idle <= (write_pixel_U0_ap_idle and read_pixel13_U0_ap_idle and convolve_U0_ap_idle);
    ap_ready <= read_pixel13_U0_ap_ready;

    ap_rst_n_inv_assign_proc : process(ap_rst_n)
    begin
                ap_rst_n_inv <= not(ap_rst_n);
    end process;

    ap_sync_continue <= ap_const_logic_1;
    ap_sync_done <= write_pixel_U0_ap_done;
    ap_sync_ready <= read_pixel13_U0_ap_ready;
    convolve_U0_ap_continue <= ap_const_logic_1;
    convolve_U0_ap_start <= start_for_convolve_U0_empty_n;
    convolve_U0_start_full_n <= ap_const_logic_1;
    convolve_U0_start_write <= ap_const_logic_0;
    read_pixel13_U0_ap_continue <= ap_const_logic_1;
    read_pixel13_U0_ap_start <= ap_start;
    read_pixel13_U0_start_full_n <= (start_for_write_pixel_U0_full_n and start_for_convolve_U0_full_n);
    start_for_convolve_U0_din <= (0=>ap_const_logic_1, others=>'-');
    start_for_write_pixel_U0_din <= (0=>ap_const_logic_1, others=>'-');
    write_pixel_U0_ap_continue <= ap_const_logic_1;
    write_pixel_U0_ap_start <= start_for_write_pixel_U0_empty_n;
    write_pixel_U0_start_full_n <= ap_const_logic_1;
    write_pixel_U0_start_write <= ap_const_logic_0;
end behav;
