// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2017.4
// Copyright (C) 1986-2017 Xilinx, Inc. All Rights Reserved.
// 
// ==============================================================

/***************************** Include Files *********************************/
#include "xconv_stream.h"

/************************** Function Implementation *************************/
#ifndef __linux__
int XConv_stream_CfgInitialize(XConv_stream *InstancePtr, XConv_stream_Config *ConfigPtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(ConfigPtr != NULL);

    InstancePtr->Axilites_BaseAddress = ConfigPtr->Axilites_BaseAddress;
    InstancePtr->IsReady = XIL_COMPONENT_IS_READY;

    return XST_SUCCESS;
}
#endif

void XConv_stream_Start(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL) & 0x80;
    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL, Data | 0x01);
}

u32 XConv_stream_IsDone(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL);
    return (Data >> 1) & 0x1;
}

u32 XConv_stream_IsIdle(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL);
    return (Data >> 2) & 0x1;
}

u32 XConv_stream_IsReady(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL);
    // check ap_start to see if the pcore is ready for next input
    return !(Data & 0x1);
}

void XConv_stream_EnableAutoRestart(XConv_stream *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL, 0x80);
}

void XConv_stream_DisableAutoRestart(XConv_stream *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_AP_CTRL, 0);
}

void XConv_stream_Set_in_array_offset(XConv_stream *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IN_ARRAY_OFFSET_DATA, Data);
}

u32 XConv_stream_Get_in_array_offset(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IN_ARRAY_OFFSET_DATA);
    return Data;
}

void XConv_stream_Set_out_array_offset(XConv_stream *InstancePtr, u32 Data) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_OUT_ARRAY_OFFSET_DATA, Data);
}

u32 XConv_stream_Get_out_array_offset(XConv_stream *InstancePtr) {
    u32 Data;

    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Data = XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_OUT_ARRAY_OFFSET_DATA);
    return Data;
}

void XConv_stream_InterruptGlobalEnable(XConv_stream *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_GIE, 1);
}

void XConv_stream_InterruptGlobalDisable(XConv_stream *InstancePtr) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_GIE, 0);
}

void XConv_stream_InterruptEnable(XConv_stream *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IER);
    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IER, Register | Mask);
}

void XConv_stream_InterruptDisable(XConv_stream *InstancePtr, u32 Mask) {
    u32 Register;

    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    Register =  XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IER);
    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IER, Register & (~Mask));
}

void XConv_stream_InterruptClear(XConv_stream *InstancePtr, u32 Mask) {
    Xil_AssertVoid(InstancePtr != NULL);
    Xil_AssertVoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    XConv_stream_WriteReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_ISR, Mask);
}

u32 XConv_stream_InterruptGetEnabled(XConv_stream *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_IER);
}

u32 XConv_stream_InterruptGetStatus(XConv_stream *InstancePtr) {
    Xil_AssertNonvoid(InstancePtr != NULL);
    Xil_AssertNonvoid(InstancePtr->IsReady == XIL_COMPONENT_IS_READY);

    return XConv_stream_ReadReg(InstancePtr->Axilites_BaseAddress, XCONV_STREAM_AXILITES_ADDR_ISR);
}

