#include <stdio.h>

#include "font8x8_basic.h"

/*
void usage(char *exec) {
    printf("Usage: %s <char_code>\n", exec);
    printf("       <char_code> Decimal character code between 0 and 127\n");
}
*/
void render(char *bitmap) {
    int x,y;
    int set;
    int mask;
    for (x=0; x < 8; x++) {
        for (y=0; y < 8; y++) {
            set = bitmap[x] & 1 << y;
            printf("%c", set ? 'X' : ' ');
        }
        printf("\n");
    }
}

int main(int argc, char **argv) {
/*    int ord;
    if (argc != 2) {
        usage(argv[0]);
        return 1;
    }
    ord = atoi(argv[1]);
    if (ord > 127 || ord < 0) {
        usage(argv[0]);
        return 2;
    }*/
int i,j;
FILE *fptr;
	fptr=fopen("fontrom.vhd","wt+");
	fprintf(fptr,"type font_rom_type is array (0 to 128*8-1) of std_logic_vector(7 downto 0);\n");
	fprintf(fptr,"constant font_rom : font_rom_type := (\n");
	for(i=0;i<128;i++)
	{    
		unsigned char *bitmap = font8x8_basic[i];
		//render(bitmap);
		fprintf(fptr,"\t");
		for(j=0;j<8;j++)
		{
			if ((i==127)&&(j==7))
			{
				fprintf(fptr,"X\"%02x\"",bitmap[j]);			
			}
			else
			{
				fprintf(fptr,"X\"%02x\", ",bitmap[j]);
			}
		}
		fprintf(fptr,"\n");
	}
	fprintf(fptr,");\n");
	fclose(fptr);
//0-9 A-F
	unsigned char chars[16]="0123456789ABCDEF";
	fptr=fopen("fontromhex.vhd","wt+");
	fprintf(fptr,"type font_rom_hex_type is array (0 to 16*8-1) of std_logic_vector(7 downto 0);\n");
	fprintf(fptr,"constant font_rom_hex : font_rom_hex_type := (\n");
	for(i=0;i<16;i++)
	{    
		unsigned char *bitmap = font8x8_basic[chars[i]];
		render(bitmap);
		fprintf(fptr,"\t");
		for(j=0;j<8;j++)
		{
			if ((i==15)&&(j==7))
			{
				fprintf(fptr,"X\"%02x\"",bitmap[j]);			
			}
			else
			{
				fprintf(fptr,"X\"%02x\", ",bitmap[j]);
			}
		}
		fprintf(fptr,"\n");
	}
	fprintf(fptr,");\n");
	fclose(fptr);
	return 0;
}
