function [G] = WSmodel(rajz, fokszam, RN, p)
%   WSmodel metdus grfgenerlsra hasznlhat, Watts-Strogatz eljrsa
%   szerint
%
%   Bemenete:
%   RN      - RegularNetwork metdussal generlt grf
%   p       - tvezetkels valsznsge
%   rajz    - 1: kirajzols lesz; 0: nem
%   fokszam - 1: fokszmok eloszlst szmol s rajzol; 0: nem
%
%   Kimenete egy G adatstruktra a kvetkez elemekkel:
%   G.Adj   - a grf szomszdsgi mtrixa (1 - a kt cscs kztt van l, 0
%   - a kt cscs kztt nincs l
%   G.nv    - cscsok szma (vertices)
%   G.ne    - lek szma (edges)

% talaktjuk a mtrixot felshromszgg (mivel irnytatlan a grf, ezrt
% ezt nyugodtan megtehetjk)
A = triu(RN.Adj);

nv = RN.nv;

% megkeressk az lekkel sszekttt cscsprokat
[v1,v2] = find(A);

% ezek kzl a kvetkez leket kell felbontani (p valsznsggel szmolva) 
dis = (rand(length(v1),1)<=p); 
A(v1(dis),v2(dis))=0; % l kitrlse a szomszdsgi mtrixbl

nDis = sum(dis); % hny darab let kell visszarakni, mert trlve lett

pairs_to_disconnect=[v1(dis),v2(dis)];

for n=1:nDis
    % kivlasztjuk az egyik cscsot a kitrlt lbl
    i=ceil(rand*size(pairs_to_disconnect,1));
    j=logical(1+rand>0.5);
    
    v_dis_to_rec=pairs_to_disconnect(i,j);
    % keresnk egy nem szomszdos cscsot
    adj=[find(A(:,v_dis_to_rec)) ; find(A(v_dis_to_rec,:))'];
    non_adj=setdiff(1:nv,adj);
    
    % ne legyen hurok
    v_to_rec = v_dis_to_rec;
    while v_to_rec==v_dis_to_rec
        v_to_rec=non_adj(ceil(rand*length(non_adj)));
    end
        
    % vgl berjuk az A mtrixba az j let
    S = sort([v_dis_to_rec v_to_rec]);
    A(S(1),S(2))=1;
end

A=A+A';

G = struct('Adj', A, 'nv', nv, 'ne', nnz(A)/2);

if rajz==1
    plotGraphBasic(G,3,1);
end

if fokszam==1
    plotKPk(G);
end
