function [G] = RegularNetwork(rajz, fokszam, nv, k, p)
%[G] = RegularNetwork(1, 0, 10, 2, 0.2);
%[G] = RegularNetwork(0, 1, 1500, 2, 0.2) %fokszm eloszls Poisson, egyre szlesebb minnl nagyobb az thuzalozs
%   RegularNetwork metdus grfgenerlsra hasznlhat
%
%   Bemeneti paramterek:
%   nv      - cscsok szma (vertices)
%   k       - fokszm
%   p       - tvezetkezs valsznsge
%   rajz    - 1: kirajzols lesz; 0: nem
%   fokszam - 1: fokszmok eloszlst szmol s rajzol; 0: nem
%
%   Kimeneti paramter egy G adatstruktra a kvetkez elemekkel:
%   G.Adj   - a grf szomszdsgi mtrixa (1 - a kt cscs kztt van l, 0
%   - a kt cscs kztt nincs l
%   G.nv    - cscsok szma (vertices)
%   G.ne    - lek szma (edges)

% ltrehozzuk az alapmtrixot csupa nullval
A=zeros(nv,nv);

% k, a fokszm hibakezelse
k=fix(abs(k)/2);k=(k<1)+k;

for k_=1:k
    % hozzadjuk az adott cscshoz tartoz kis diagonlmtrixot
    A = A + diag(ones(1,length(diag(A,k_))), k_) ...
          + diag(ones(1,length(diag(A,nv-k_))), nv-k_);  
     % A
end
A = A + A';

G = struct('Adj', A, 'nv', nv, 'ne', nnz(A)/2);

if rajz==1
    plotGraphBasic(G,3,1);
end

if fokszam==1
    plotKPk(G);
end

%p=0.2; %tvezetkezs valsznsge
if nargin==5
[G] = WSmodel(rajz, fokszam, G, p);
end
