function [G] = ERmodel(rajz, fokszam, n, p, L)
%[G] = ERmodel(1, 0, 10, 0, 5)
%[G] = ERmodel(0, 1, 1500, 0, 8000) %a fokszm eloszls Poisson, haranggrba
%   ERmodel metdus grfgenerlsra hasznlhat, Erds - Rnyi eljrsa
%   szerint
%
%   Bemenete:
%   n       - cscsok szma
%   p       - az l ltezsnek valsznsge
%   L       - az lek szma (ha megvan adva, akkor az algoritmus ezt veszi
%   figyelembe
%   rajz    - 1: kirajzols lesz; 0: nem
%   fokszam - 1: fokszmok eloszlst szmol s rajzol; 0: nem
%
%   Kimenete egy G adatstruktra a kvetkez elemekkel:
%   G.Adj   - a grf szomszdsgi mtrixa (1 - a kt cscs kztt van l, 0
%   - a kt cscs kztt nincs l
%   G.nv    - cscsok szma (vertices)
%   G.ne    - lek szma (edges)


adj=zeros(n); % res szomszdsgi mtrix

switch nargin
    case 3  % ha csak egy paramter van, az a cscsok szma
        % 0.5 a p alaprtelmezett rtke most
        for i=1:n
            for j=i+1:n
                if rand<=0.5; adj(i,j)=1; adj(j,i)=1; end
            end
        end
        
    case 4 % ha p is defininlt, az l p esllyel jelenik meg
        for i=1:n
            for j=i+1:n
                if rand<=p; adj(i,j)=1; adj(j,i)=1; end
            end
        end
        
    case 5 % a cscsoknak s az leknek pontosan megadott szmuk lehet.
        while sum(sum(adj))/2 < L
            i=randi(n); j=randi(n);
            if i==j || adj(i,j)>0; continue; end  % ne legyen se dupla l, se hurok.
            adj(i,j)=adj(i,j)+1; adj(j,i)=adj(i,j);
        end
        
end  

G = struct('Adj', adj, 'nv', n, 'ne', nnz(adj)/2);

if rajz==1
    plotGraphBasic(G,3,1);
end

if fokszam==1
    plotKPk(G);
end