function [coeff_open] = ClusterCoefficient(G) 
    % Csomsodsi egytthet kiszmolsra szolgl metdus
    %
    % Bemeneti paramter:
    % G   - grf struktra
    % 
    % Kimeneti paramter:
    % coeff_open - csomsodsi egytthat
    
    A = G.Adj;
    n =G.nv;
    % majd rszgrfhoz a csomsodsi egytthatt
    local_open = zeros(n,1);
    for i = 1:n
        
        sz=find(A(i,:)); %szomszedok
        if isempty(sz)% %ha a cscs izollt, egyetlen szomszdja maga
            local_open(i)=0;
        else
        sz_rg=A(sz, sz); %szomszedok rszgrf
        local_open(i) = sum(sz_rg(:))/(length(sz)*length(sz)); %lek szma a szomszdsgban/lehetsges maximlis lszm (teljes rszgrf)
        end
    end

    % a teljes grfra rtelmezett csomsodsi egytthatt a loklis
    % csomsodsi egytthatk tlagaknt kapjuk
    coeff_open = mean(local_open);

end