function [G] = BAmodel(rajz, fokszam, n, n0, L, L0)
%[G] = BAmodel(1, 0, 50, 0.03, 1, 3)
%[G] = BAmodel(0, 1, 1500, 0.03, 1, 3) %a fokszm eloszls hatvnyfggvny
%   BAmodel metdus grfgenerlsra hasznlhat, Barabsi - Albert eljrsa
%   szerint
%
%   Bemenete:
%   n       - cscsok szma
%   n0      - az l ltezsnek valsznsge
%   L       - a cscsok fokszma
%   L0      - az lek szma a grf ltrehozsakor
%   rajz    - 1: kirajzols lesz; 0: nem
%   fokszam - 1: fokszmok eloszlst szmol s rajzol; 0: nem
%
%   Kimenete egy G adatstruktra a kvetkez elemekkel:
%   G.Adj   - a grf szomszdsgi mtrixa (1 - a kt cscs kztt van l, 0
%   - a kt cscs kztt nincs l
%   G.nv    - cscsok szma (vertices)
%   G.ne    - lek szma (edges)

A = zeros(n,n);
n0=n0*100;
steps=n-n0; 


% Elejn vletlenszeren feltltjk a grfot L0 llel
for j=1:L0
    l_ = 1;
    n_ = 1;
    while (A(l_,n_)~=0) || (l_==n_)
        l_ = ceil(rand*n0);
        n_ = ceil(rand*n0);
    end
    A (l_,n_) = 1;
    A (n_,l_) = 1;
end;

% Mindegyik idpillanatban hozzadunk egy cscsot m <= L+1, ekkor ez a
% cscs jabb m csccsal lesz kapcsolatban. Hogy segtsk a preferencia
% szerinti kapcsoldst, gy az j cscsot p(ki) = ki / sum(kj)
% valsznsggel kti a mr meglv cscshoz.

for t = 1:steps
    
     k = zeros(n0+(t-1) ,1);
    for i = 1:n0+(t-1)
        k(i) = sum(A(i,:));
    end;
    P   = k./sum(k);
    PP  = cumsum(P);
    j=0; 
    k = 0;
    while (j<L && k<L^3)   % k<L^10 csak a vgtelen ciklus elkerlse miatt van
        rv = rand(1);
        index_list = find(PP >= rv, 1);
        index = index_list(1);
        % ha mg nincs l, hozzadjuk
        if (A(n0+t,index)~=1)
            A(n0+t,index)=1;
            A(index,n0+t)=1;
            j=j+1;
        else
            k=k+1; %% error raise
        end
        
        
    end
    
    if (k>=L^3)
        display('error');
        G = [];
        return;
    end
    
    
end

G = struct('Adj', A, 'nv', n, 'ne', nnz(A)/2);

if rajz==1
    plotGraphBasic(G,3,1);
end

if fokszam==1
    plotKPk(G);
end










