% GUI inicializálása
function varargout = tumorGrowthGUI(varargin)
    gui_Singleton = 1;
    gui_State = struct('gui_Name',       mfilename, ...
                       'gui_Singleton',  gui_Singleton, ...
                       'gui_OpeningFcn', @tumorGrowthGUI_OpeningFcn, ...
                       'gui_OutputFcn',  @tumorGrowthGUI_OutputFcn, ...
                       'gui_LayoutFcn',  [] , ...
                       'gui_Callback',   []);
    if nargin && ischar(varargin{1})
        gui_State.gui_Callback = str2func(varargin{1});
    end
    if nargout
        [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
    else
        gui_mainfcn(gui_State, varargin{:});
    end

% Függvény, amely lekérdezi a csúszkáktól az aktuális értéküket és ezek a paraméterek alapján elindítja a DE kiszámítását, majd kirajzolja az eredményt
function refresh(handles)
    button = handles.pushbutton1;
    set(button,'String','Calculating...'); drawnow()
    
    % Calculation...
    sol = tumorGrowth(get(handles.slider1, 'Value'),...
                        get(handles.slider2, 'Value'));
                    
    set(button,'String','Drawing...'); drawnow()
    
    % Drawind first plot
    plot1 = handles.axes1;
    plot(plot1,sol.x,sol.y)
    legend(plot1,...
            'x1 - tumor cells',...
            'x2 - hunting predator cells',...
            'x3 - resting cells')
    xlabel(plot1,'time (t)')
    ylabel(plot1,'cell number (relative scale)')
    
    %Drawing second plot
    plot2 = handles.axes2;
    plot3(plot2,sol.y(1,:),sol.y(2,:), sol.y(3,:))
    xlabel(plot2,'x1 - tumor cells')
    ylabel(plot2,'x2 - hunting predator cells')
    zlabel(plot2,'x3 - resting cells')
    
    set(button,'String','Calculate & Draw')

% GUI indítása
function tumorGrowthGUI_OpeningFcn(hObject, ~, handles, ~)
    handles.output = hObject;
    guidata(hObject, handles);
    refresh(handles)

% GUI kimenete
function varargout = tumorGrowthGUI_OutputFcn(~, ~, handles) 
    varargout{1} = handles.output;

% Első sliderre való kattintás eseménye
function slider1_Callback(~, ~, handles)
    set(handles.text3, 'String', get(handles.slider1,'Value'))
%#ok<*DEFNU> Csak azért, hogy ne sírjon a továbbiakban a "function might not be used" miatt...

% Első slider inicializálása
function slider1_CreateFcn(hObject, ~, ~)
    if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor',[.9 .9 .9]);
    end

% Második sliderre való kattintás eseménye
function slider2_Callback(~, ~, handles)
    set(handles.text4, 'String', get(handles.slider2,'Value'))

% Második slider inicializálása
function slider2_CreateFcn(hObject, ~, ~)
    if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor',[.9 .9 .9]);
    end

% Gombra való kattintás
function pushbutton1_Callback(~, ~, handles)
    refresh(handles)
