% Függvény, ami megoldja a késleltetett differenciálegyenletet, és ezzel megadja a rendszer dinamikáját
function solution = tumorGrowth(t_max, tau)
    x_null = [1,1,1]; % kezdeti értékek
    t_span = [0,t_max]; % szimulációs ablak
    options = ddeset('RelTol', 1e-7, 'AbsTol', 1e-10); % Minimális lépésközt finomabbra kellett állítanom, hogy sikerüljön a DE megoldása
    solution = dde23(@odeFunc, tau, x_null,t_span, options);
end

% A dde23-nek külön függvényben kell megadni a megoldandó egyenletrendszert. A függvény megadja adott állapot értékeiből, illetve a késleltetett értékekből, hogy az egyes változóknak mennyi az adott pillanatbeli deriváltja
function dx = odeFunc(~,x,Z)
    % paraméterek
    a1 = 2.5;
    a2 = 4.5;
    a3 = 0.6;
    a4 = 3.5;
    a5 = 2.0;
    a6 = 0.1;

    % Maga a DE
    dx = zeros(3,1);
    dx(1) = 1 + a1*(1-x(1))*x(1)-x(1)*x(2);
    dx(2) = a2*Z(2,1)*Z(3,1)-a3*x(2);
    dx(3) = a4*(1-x(3))*x(3)-a5*x(2)*x(3)-a6*x(3);

end
