function dx = cell_equation(t,X,P)


%reshape the 1xN input for the size of the image
x=reshape(X,P.SizeX,P.SizeY);

dx=zeros(P.SizeX,P.SizeY);

%we do not care about boundary conditions now
for a=2:P.SizeX-1
    for b=2:P.SizeY-1
	%the current state
        cella=x(a,b);
	
	%cut out the neighbouring states
        stateregion=x(a-1:a+1,b-1:b+1);
        stateregion=reshape(stateregion,9,1);
	%output of the neighbours
        y=nonlinearity1(stateregion);

	%cut out the neighbouring input
        inputregion=P.Input(a-1:a+1,b-1:b+1);
        u=reshape(inputregion,9,1);

	%calculate the derivative
        dx(a,b)=-cella+P.A*y+P.B*u+P.Z;
    end
end

%reshape back from Nx1
dx=reshape(dx,P.SizeX*P.SizeY,1);
