/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import org.gepard.common.LEDataInputStream;
import org.gepard.common.LEDataOutputStream;

public class VmatchConverter {
    private static final int PREFIX_THRESHOLD = 0x800000;
    private static final String[] MAPPING = new String[]{"aA", "tTuU", "gG", "cC", "nsywrkvbdhmNSYWRKVBDHM"};

    public static void genSAFileFromVmatch(String strinfile, int seqlen, File outfile) throws IOException, InterruptedException {
        VmatchConverter.genSAFileFromVmatch(strinfile, seqlen, outfile, "mkvtree");
    }

    public static void genSAFileFromVmatch(String strinfile, int seqlen, File outfile, String command) throws IOException, InterruptedException {
        String alifile = String.valueOf(System.currentTimeMillis()) + seqlen;
        PrintWriter mapwriter = new PrintWriter(new FileWriter(alifile));
        int i = 0;
        while (i < MAPPING.length) {
            mapwriter.println(MAPPING[i]);
            ++i;
        }
        mapwriter.close();
        String filename = VmatchConverter.extractFilename(strinfile);
        String execute = String.valueOf(command) + " -db " + strinfile + " -lcp -suf -smap " + alifile;
        if (seqlen > 0x800000) {
            execute = String.valueOf(execute) + " -pl";
        }
        System.out.println("Running: " + execute);
        Process p = Runtime.getRuntime().exec(execute);
        p.waitFor();
        VmatchConverter.processVMatchFiles(filename, seqlen, outfile);
        new File(String.valueOf(filename) + ".suf").delete();
        new File(String.valueOf(filename) + ".lcp").delete();
        new File(String.valueOf(filename) + ".prj").delete();
        new File(String.valueOf(filename) + ".llv").delete();
        new File(String.valueOf(filename) + ".al1").delete();
        new File(String.valueOf(filename) + ".des").delete();
        new File(String.valueOf(filename) + ".sds").delete();
        new File(alifile).delete();
        new File(alifile).deleteOnExit();
    }

    private static void processVMatchFiles(String filename, int seqlen, File outfile) throws IOException {
        int mkvtreesuflen = (int)new File(String.valueOf(filename) + ".suf").length();
        boolean bit64 = false;
        if (mkvtreesuflen > seqlen * 4 + 4) {
            bit64 = true;
        }
        LEDataOutputStream safile = new LEDataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outfile))));
        safile.write(1);
        safile.writeInt(seqlen);
        LEDataInputStream suffile = new LEDataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(filename) + ".suf")));
        int i = 0;
        while (i < seqlen) {
            safile.writeInt(suffile.readInt());
            if (bit64) {
                suffile.readInt();
            }
            ++i;
        }
        suffile.close();
        LEDataInputStream lcpfile = new LEDataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(filename) + ".lcp")));
        lcpfile.skipBytes(1);
        short[] lcptab = new short[seqlen - 1];
        int i2 = 0;
        while (i2 < seqlen - 1) {
            byte test = lcpfile.readByte();
            lcptab[i2] = VmatchConverter.byte2unsignedshort(test);
            safile.writeByte(test);
            ++i2;
        }
        lcpfile.close();
        LEDataInputStream llv = new LEDataInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(filename) + ".llv")));
        boolean eof = false;
        while (!eof) {
            try {
                safile.writeInt(llv.readInt());
                if (bit64) {
                    llv.readInt();
                }
                safile.writeInt(llv.readInt());
                if (!bit64) continue;
                llv.readInt();
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        llv.close();
        safile.close();
    }

    private static String extractFilename(String path) {
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    private static short byte2unsignedshort(byte i) {
        if (i < 0) {
            return (short)(256 + i);
        }
        return i;
    }
}

