/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gepard.common.AbortionChecker;
import org.gepard.common.LEDataInputStream;
import org.gepard.common.LEDataOutputStream;
import org.gepard.common.Sequence;

public class SuffixArray {
    private int[] suftab;
    private byte[] orgdata;
    private short[] lcp;
    private AbortionChecker ac;
    boolean isgepardsa = true;

    public SuffixArray(Sequence seq, int K, AbortionChecker ac) {
        this.ac = ac;
        byte[] s = seq.getSequenceData();
        int[] si = new int[s.length + 3];
        int i = 0;
        while (i < s.length) {
            si[i] = s[i];
            ++i;
        }
        si[s.length + 2] = 0;
        si[s.length + 1] = 0;
        si[s.length] = 0;
        this.suftab = new int[s.length];
        this.genArray(si, this.suftab, s.length, K + 1);
        if (ac != null && ac.dotplotAborted()) {
            return;
        }
        this.lcp = this.genLCP(this.suftab, s);
        this.orgdata = s;
    }

    private SuffixArray(int[] st, short[] l, byte[] od, boolean isgepardsa) {
        this.suftab = st;
        this.orgdata = od;
        this.lcp = l;
        this.isgepardsa = isgepardsa;
    }

    public int[] search(byte[] query, int qstart, int qlen, boolean backwards, byte[] map) {
        int[] ret = new int[]{};
        int l = 0;
        int r = this.orgdata.length - 1;
        int m = (l + r) / 2;
        while (l <= r) {
            m = (l + r) / 2;
            int comp = this.compare(this.orgdata, this.suftab[m], query, qstart, qlen, backwards, map);
            if (comp == 1) {
                r = m - 1;
                continue;
            }
            if (comp == -1) {
                l = m + 1;
                continue;
            }
            l = m;
            while (l > 0 && this.lcp[l - 1] >= qlen) {
                --l;
            }
            r = m;
            while (r < this.orgdata.length - 1 && this.lcp[r] >= qlen) {
                ++r;
            }
            ret = new int[r - l + 1];
            int i = 0;
            while (i < r - l + 1) {
                ret[i] = this.suftab[l + i];
                ++i;
            }
            r = 0;
            l = 1;
        }
        return ret;
    }

    private int compare(byte[] s1, int off1, byte[] s2, int off2, int p, boolean backwards, byte[] map) {
        if (!backwards) {
            int i = 0;
            while (i < p && i + off1 < s1.length && i + off2 < s2.length) {
                if (s1[i + off1] < map[s2[i + off2]]) {
                    return -1;
                }
                if (s1[i + off1] > map[s2[i + off2]]) {
                    return 1;
                }
                ++i;
            }
            if (i < p) {
                if (this.isgepardsa) {
                    if (i + off1 == s1.length) {
                        return -1;
                    }
                    return 1;
                }
                if (i + off1 == s1.length) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
        int i = 0;
        while (i < p && i + off1 < s1.length && i + off2 < s2.length) {
            if (s1[i + off1] < map[s2[-i + off2]]) {
                return -1;
            }
            if (s1[i + off1] > map[s2[-i + off2]]) {
                return 1;
            }
            ++i;
        }
        if (i < p) {
            if (this.isgepardsa) {
                if (i + off1 == s1.length) {
                    return -1;
                }
                return 1;
            }
            if (i + off1 == s1.length) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private void radixPass(int[] a, int[] b, int[] s, int offset, int n, int K) {
        int[] c = new int[K + 1];
        int i = 0;
        while (i < n) {
            int n2 = s[a[i] + offset];
            c[n2] = c[n2] + 1;
            ++i;
        }
        i = 0;
        int sum = 0;
        while (i <= K) {
            int t = c[i];
            c[i] = sum;
            sum += t;
            ++i;
        }
        i = 0;
        while (i < n) {
            int n3 = s[a[i] + offset];
            int n4 = c[n3];
            c[n3] = n4 + 1;
            b[n4] = a[i];
            ++i;
        }
    }

    public int[] getRawArray() {
        return this.suftab;
    }

    private void genArray(int[] s, int[] SA, int n, int K) {
        if (this.ac != null && this.ac.dotplotAborted()) {
            this.suftab = null;
            this.orgdata = null;
            this.lcp = null;
            return;
        }
        int n0 = (n + 2) / 3;
        int n1 = (n + 1) / 3;
        int n2 = n / 3;
        int n02 = n0 + n2;
        int[] s12a = new int[n02 + 3];
        int[] s12b = new int[n02 + 3];
        int i = 0;
        int j = 0;
        while (i < n + (n0 - n1)) {
            if (i % 3 != 0) {
                s12a[j++] = i;
            }
            ++i;
        }
        this.radixPass(s12a, s12b, s, 2, n02, K);
        this.radixPass(s12b, s12a, s, 1, n02, K);
        this.radixPass(s12a, s12b, s, 0, n02, K);
        int name = 0;
        int c0 = -1;
        int c1 = -1;
        int c2 = -1;
        int i2 = 0;
        while (i2 < n02) {
            if (s[s12b[i2]] != c0 || s[s12b[i2] + 1] != c1 || s[s12b[i2] + 2] != c2) {
                ++name;
                c0 = s[s12b[i2]];
                c1 = s[s12b[i2] + 1];
                c2 = s[s12b[i2] + 2];
            }
            if (s12b[i2] % 3 == 1) {
                s12a[s12b[i2] / 3] = name;
            } else {
                s12a[s12b[i2] / 3 + n0] = name;
            }
            ++i2;
        }
        if (name < n02) {
            this.genArray(s12a, s12b, n02, name);
            if (this.ac != null && this.ac.dotplotAborted()) {
                this.suftab = null;
                this.orgdata = null;
                this.lcp = null;
                return;
            }
            i2 = 0;
            while (i2 < n02) {
                s12a[s12b[i2]] = i2 + 1;
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < n02) {
                s12b[s12a[i2] - 1] = i2;
                ++i2;
            }
        }
        int[] s0a = new int[n0];
        int[] s0b = new int[n0];
        int i3 = 0;
        int j2 = 0;
        while (i3 < n02) {
            if (s12b[i3] < n0) {
                s0a[j2++] = 3 * s12b[i3];
            }
            ++i3;
        }
        this.radixPass(s0a, s0b, s, 0, n0, K);
        s0a = null;
        int p = 0;
        int t = n0 - n1;
        int k = 0;
        while (k < n) {
            int a2;
            int a1;
            int i4 = s12b[t] < n0 ? s12b[t] * 3 + 1 : (s12b[t] - n0) * 3 + 2;
            int j3 = s0b[p];
            boolean q = false;
            if (s12b[t] < n0) {
                a1 = s[i4];
                a2 = s12a[s12b[t] + n0];
                int b1 = s[j3];
                int b2 = s12a[j3 / 3];
                q = a1 < b1 || a1 == b1 && a2 <= b2;
            } else {
                a1 = s[i4];
                a2 = s[i4 + 1];
                int a3 = s12a[s12b[t] - n0 + 1];
                int b1 = s[j3];
                int b2 = s[j3 + 1];
                int b3 = s12a[j3 / 3 + n0];
                boolean bl = q = a1 < b1 || a1 == b1 && (a2 < b2 || a2 == b2 && a3 <= b3);
            }
            if (q) {
                SA[k] = i4;
                if (++t == n02) {
                    ++k;
                    while (p < n0) {
                        SA[k] = s0b[p];
                        ++p;
                        ++k;
                    }
                }
            } else {
                SA[k] = j3;
                if (++p == n0) {
                    ++k;
                    while (t < n02) {
                        SA[k] = s12b[t] < n0 ? s12b[t] * 3 + 1 : (s12b[t] - n0) * 3 + 2;
                        ++t;
                        ++k;
                    }
                }
            }
            ++k;
        }
    }

    public void saveToFile(String filename) throws IOException {
        LEDataOutputStream safile = new LEDataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename))));
        Vector<BigLCP> biglcps = new Vector<BigLCP>();
        safile.write(0);
        safile.writeInt(this.suftab.length);
        int i = 0;
        while (i < this.suftab.length) {
            safile.writeInt(this.suftab[i]);
            ++i;
        }
        i = 0;
        while (i < this.lcp.length) {
            if (this.lcp[i] < 255) {
                safile.write(SuffixArray.unsignedshort2byte(this.lcp[i]));
            } else {
                biglcps.add(new BigLCP(i, this.lcp[i]));
                safile.write(SuffixArray.unsignedshort2byte((short)-1));
            }
            ++i;
        }
        for (BigLCP lcp : biglcps) {
            safile.writeInt(lcp.suffix + 1);
            safile.writeInt(lcp.lcp);
        }
        safile.close();
    }

    public static SuffixArray loadFromFile(File file, byte[] orgdata) throws FileNotFoundException, IOException {
        LEDataInputStream in = new LEDataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        byte type = in.readByte();
        boolean isgepardsa = type == 0;
        int seqlength = in.readInt();
        int[] suftab = new int[seqlength];
        short[] lcp = new short[seqlength - 1];
        int i = 0;
        while (i < seqlength) {
            suftab[i] = in.readInt();
            ++i;
        }
        i = 0;
        while (i < seqlength - 1) {
            lcp[i] = SuffixArray.byte2unsignedshort(in.readByte());
            ++i;
        }
        boolean eof = false;
        while (!eof) {
            try {
                int cursuf = in.readInt();
                int curlcp = in.readInt();
                if (curlcp > Short.MAX_VALUE) {
                    curlcp = Short.MAX_VALUE;
                }
                lcp[cursuf - 1] = (short)curlcp;
            }
            catch (EOFException e) {
                eof = true;
            }
        }
        in.close();
        return new SuffixArray(suftab, lcp, orgdata, isgepardsa);
    }

    private static short byte2unsignedshort(byte i) {
        if (i < 0) {
            return (short)(256 + i);
        }
        return i;
    }

    private static byte unsignedshort2byte(short i) {
        if (i > 127) {
            return (byte)(i - 256);
        }
        return (byte)i;
    }

    private short[] genLCP(int[] suftab, byte[] orgdata) {
        int len = suftab.length;
        short[] ret = new short[len - 1];
        int i = 0;
        while (i < len - 1) {
            int j = 0;
            while (j < 32768 && suftab[i] + j < len && suftab[i + 1] + j < len && orgdata[suftab[i] + j] == orgdata[suftab[i + 1] + j]) {
                ++j;
            }
            ret[i] = (short)j;
            ++i;
        }
        return ret;
    }

    public static String getSAFilename(String sequenceFile) {
        String filename = SuffixArray.extractFilename(sequenceFile);
        return String.valueOf(filename) + "_" + new File(sequenceFile).length() + ".sa";
    }

    private static String extractFilename(String source) {
        int sep = source.lastIndexOf(System.getProperty("file.separator"));
        if (sep > -1) {
            return source.substring(sep + 1);
        }
        return source;
    }

    public void compareSAs(SuffixArray sa) {
        int j = 0;
        int i = 0;
        while (i < sa.suftab.length) {
            if (this.suftab[i] != sa.suftab[i]) {
                System.out.println("differing at suffix " + i + ", this: " + this.suftab[i] + ", other: " + sa.suftab[i]);
                ++j;
                System.out.println();
                SuffixArray.dump("vmatch  ", this.orgdata, this.suftab[i]);
                SuffixArray.dump("gepard  ", this.orgdata, sa.suftab[i]);
            }
            if (j >= 10) break;
            ++i;
        }
    }

    private static void dump(String name, byte[] orgdata, int pos) {
        char[] mapit = new char[]{' ', 'A', 'T', 'G', 'C', 'N'};
        System.out.print(name);
        int k = 0;
        while (k < 50 && pos + k < orgdata.length) {
            System.out.print(mapit[orgdata[pos + k]]);
            ++k;
        }
        System.out.println();
    }

    public void printYourself() {
        char[] mapit = new char[]{' ', 'A', 'T', 'G', 'C'};
        int m = 0;
        while (m < this.suftab.length) {
            System.out.print(String.valueOf(m) + ": ");
            int i = 0;
            while (i <= 8 && this.suftab[m] + i < this.suftab.length) {
                System.out.print(mapit[this.orgdata[this.suftab[m] + i]]);
                ++i;
            }
            System.out.println();
            ++m;
        }
    }

    public void verifyArray() {
        byte[] idmap = new byte[128];
        int i = 0;
        while (i < 128 && i >= 0) {
            idmap[i] = i;
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < this.suftab.length - 1) {
            if (this.compare(this.orgdata, this.suftab[i], this.orgdata, this.suftab[i + 1], 1000, false, idmap) > 0) {
                System.out.println("WAAAAA, bad one: " + this.suftab[i + 1]);
                SuffixArray.dump(String.valueOf(i) + "\t", this.orgdata, this.suftab[i]);
                SuffixArray.dump(String.valueOf(i + 1) + "\t", this.orgdata, this.suftab[i + 1]);
            }
            ++i;
        }
    }

    public void showFirst(int n) {
        int i = 0;
        while (i < n) {
            SuffixArray.dump("", this.orgdata, this.suftab[i]);
            ++i;
        }
    }

    public int getLength() {
        return this.suftab.length;
    }

    public void doubles() {
        byte[] check = new byte[this.suftab.length];
        System.out.println("seq: " + this.suftab.length);
        int i = 0;
        while (i < check.length) {
            if (this.suftab[i] >= check.length) {
                System.out.println("Was: " + i);
            }
            if (check[this.suftab[i]] == 1) {
                System.err.println("NOOOOOOOOOOOOOO");
            } else {
                check[this.suftab[i]] = 1;
            }
            ++i;
        }
    }

    private static class BigLCP {
        public int suffix;
        public int lcp;

        public BigLCP(int suffix, int lcp) {
            this.suffix = suffix;
            this.lcp = lcp;
        }
    }
}

