/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.common;

import java.util.List;

public class Sequence {
    private byte[] sequenceData;
    private String name;
    private boolean likelynucleotides;
    private boolean invalidchars;
    private boolean complementary = false;
    private boolean isMulti;
    private String[] multiNames;
    private int[] multiStarts;
    private static byte[] complement = null;

    public Sequence(byte[] sequence, String name, boolean likelynucleotides, boolean invalidchars) {
        this.name = name;
        this.sequenceData = sequence;
        this.likelynucleotides = likelynucleotides;
        this.invalidchars = invalidchars;
    }

    public byte[] getSequenceData() {
        return this.sequenceData;
    }

    public String getName() {
        return (this.complementary ? "[compl.]" : "").concat(this.name);
    }

    public int getLength() {
        return this.sequenceData.length;
    }

    public boolean likelyNucleotides() {
        return this.likelynucleotides;
    }

    public boolean hasInvalidChars() {
        return this.invalidchars;
    }

    public void setComplementaryFlag() {
        this.complementary = true;
    }

    public static void complementarizeSequence(Sequence sequence) {
        if (complement == null) {
            complement = Sequence.getComplementaryMap();
        }
        byte[] seq = sequence.getSequenceData();
        int i = 0;
        while (i < seq.length) {
            seq[i] = complement[seq[i]];
            ++i;
        }
        sequence.setComplementaryFlag();
    }

    public static byte[] getComplementaryMap() {
        byte[] complement = new byte[128];
        complement[1] = 2;
        complement[2] = 1;
        complement[3] = 4;
        complement[4] = 3;
        complement[5] = 5;
        return complement;
    }

    public void setMulti(List<String> names, List<Integer> starts) {
        this.multiNames = names.toArray(new String[0]);
        this.multiStarts = new int[starts.size()];
        int i = 0;
        for (int v : starts) {
            this.multiStarts[i++] = v;
        }
        this.isMulti = true;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public String[] getMultiNames() {
        return this.multiNames;
    }

    public int[] getMultiStarts() {
        return this.multiStarts;
    }
}

