/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.common;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.gepard.client.ClientGlobals;
import org.gepard.common.FASTAReader;
import org.gepard.common.InvalidFASTAFileException;
import org.gepard.common.InvalidSubMatFileException;
import org.gepard.common.Sequence;
import org.gepard.common.SubstitutionMatrix;

public class FASTAWriter {
    private static final int FASTA_COLS = 70;

    public static void writeFASTAFile(String file, Sequence sequence, int from, int length, SubstitutionMatrix submat) throws IOException {
        FASTAWriter.writeFASTAFile(file, sequence.getSequenceData(), sequence.getName(), from, length, 0, submat);
    }

    public static void writeFASTAFile(String file, byte[] seq, String seqname, int from, int length, int offset, SubstitutionMatrix submat) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        String rangeString = ", range: " + from + "-" + (from + length - 1);
        writer.println(">" + ClientGlobals.cutString(seqname, 70 - rangeString.length() - 1) + rangeString);
        int col = 0;
        int i = from;
        while (i < from + length) {
            writer.print(submat.reverseMap(seq[i - offset]));
            if (++col % 70 == 0) {
                writer.println();
            }
            ++i;
        }
        writer.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InvalidFASTAFileException, InvalidSubMatFileException {
        Sequence seq = FASTAReader.readFile("/home/jan/scratch/seqtest/humain14.fasta", ClientGlobals.getEDNA());
        FASTAWriter.writeFASTAFile("/home/jan/myout", seq, 100, 700, ClientGlobals.getEDNA());
    }
}

