/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.gepard.client.Controller;

public class UserMessageDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -6831146639624661450L;
    private JTextArea txtMessage;

    public static void showUserMessageIfExisting(String file) {
        InputStream stream = Controller.class.getResourceAsStream(file);
        if (stream != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String caption = reader.readLine();
                reader.readLine();
                StringBuilder msg = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    msg.append(String.valueOf(line) + "\n");
                }
                new UserMessageDialog(caption, msg.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private UserMessageDialog(String caption, String message) {
        super(caption);
        this.setSize(new Dimension(480, 340));
        this.setupGUI();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/gepard.gif")));
        this.setVisible(true);
        this.setResizable(false);
        Dimension SCREEN_SIZE = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(SCREEN_SIZE.width / 2 - this.getWidth() / 2, SCREEN_SIZE.height / 2 - this.getHeight() / 2);
        this.txtMessage.setText(message);
        this.txtMessage.setCaretPosition(0);
    }

    private void setupGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1000.0;
        c.fill = 1;
        this.txtMessage = new JTextArea();
        JScrollPane scrolling = new JScrollPane(this.txtMessage);
        this.add((Component)scrolling, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 3;
        c.anchor = 13;
        JButton btnQuit = new JButton("Close");
        this.add((Component)btnQuit, c);
        scrolling.setHorizontalScrollBarPolicy(31);
        scrolling.setVerticalScrollBarPolicy(20);
        this.txtMessage.setFont(new Font("Courier", 0, 11));
        this.txtMessage.setEditable(false);
        this.txtMessage.setLineWrap(true);
        this.txtMessage.setWrapStyleWord(true);
        btnQuit.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.dispose();
    }
}

