/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.gepard.client.Controller;
import org.gepard.common.DotMatrixCallback;

public class StatusDialog
extends JDialog
implements DotMatrixCallback,
ActionListener {
    private static final long serialVersionUID = -7182005894700504482L;
    JLabel lblStatus;
    JProgressBar progress;
    JButton btnAbort;
    JDialog dialog;
    Controller ctrl;

    public StatusDialog(Controller ctrl) {
        super(ctrl.getContainer());
        this.ctrl = ctrl;
        this.setTitle("Working...");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.lblStatus = new JLabel();
        this.add((Component)this.lblStatus, c);
        ++c.gridy;
        c.weighty = 1.5;
        this.progress = new JProgressBar(0, 1000);
        this.add((Component)this.progress, c);
        ++c.gridy;
        c.weighty = 0.5;
        c.fill = 0;
        this.btnAbort = new JButton("Abort");
        this.add((Component)this.btnAbort, c);
        this.btnAbort.addActionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setResizable(false);
        this.pack();
        this.setSize(220, 120);
        this.setVisible(true);
    }

    public void setStatusText(final String text) {
        Runnable doSetProgressBarValue = new Runnable(){

            @Override
            public void run() {
                StatusDialog.this.lblStatus.setText(text);
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    public void close() {
        this.setVisible(false);
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void dotmatrixCalcStatus(final float percent) {
        Runnable doSetProgressBarValue = new Runnable(){

            @Override
            public void run() {
                StatusDialog.this.progress.setValue((int)(percent * 10.0f));
            }
        };
        SwingUtilities.invokeLater(doSetProgressBarValue);
    }

    @Override
    public int tellCallbackStep(int wordlen, int windowsize) {
        if (wordlen != 0) {
            return 100000;
        }
        return 200;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.ctrl.abortDotplot();
        this.setStatusText("Aborting, please wait...");
    }

    @Override
    public void tellAborted() {
    }
}

