/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.gepard.client.Config;
import org.gepard.client.Controller;
import org.gepard.client.userinterface.HelpTexts;
import org.gepard.client.userinterface.WindowPos;

public class ProxyDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1809215642400993530L;
    private JButton btnOK;
    private JButton btnCancel;
    private JTextField txtHost;
    private JTextField txtPort;
    private Controller ctrl;

    public ProxyDialog(Controller ctrl) {
        super("HTTP proxy settings");
        this.ctrl = ctrl;
        this.setSize(new Dimension(280, 140));
        this.setupGUI();
        this.setVisible(true);
        this.setResizable(false);
        WindowPos cpos = ctrl.getContainer().getPosition();
        this.setLocation(cpos.x + cpos.width / 2 - this.getWidth() / 2, cpos.y + cpos.height / 2 - this.getHeight() / 2);
        this.txtHost.setText(Config.getInstance().getStringVal("proxy_host", ""));
        String port = Config.getInstance().getStringVal("proxy_port", "");
        if (port.trim().equals("")) {
            port = "8080";
        }
        this.txtPort.setText(port);
    }

    private void setupGUI() {
        HelpTexts hlp = HelpTexts.getInstance();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JLabel spacer1 = new JLabel("");
        this.add((Component)spacer1, c);
        ++c.gridx;
        JLabel spacer2 = new JLabel("");
        this.add((Component)spacer2, c);
        ++c.gridx;
        JLabel spacer3 = new JLabel("");
        this.add((Component)spacer3, c);
        ++c.gridx;
        JLabel spacer4 = new JLabel("");
        this.add((Component)spacer4, c);
        c.insets = new Insets(10, 6, 6, 6);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Host:"), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.txtHost = new JTextField("", 10000);
        this.add((Component)this.txtHost, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Port:"), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        c.anchor = 17;
        this.txtPort = new JTextField("");
        this.add((Component)this.txtPort, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(6, 6, 6, 6);
        c.fill = 2;
        this.add((Component)new JLabel(""), c);
        ++c.gridx;
        this.add((Component)new JLabel(""), c);
        ++c.gridx;
        this.btnOK = new JButton("OK");
        this.add((Component)this.btnOK, c);
        ++c.gridx;
        this.btnCancel = new JButton("Cancel");
        this.add((Component)this.btnCancel, c);
        spacer1.setPreferredSize(new Dimension(1, 1));
        spacer2.setPreferredSize(new Dimension(1, 1));
        spacer3.setPreferredSize(new Dimension(85, 1));
        spacer3.setMinimumSize(new Dimension(85, 1));
        spacer3.setMaximumSize(new Dimension(85, 1));
        spacer4.setPreferredSize(new Dimension(5, 1));
        spacer4.setMinimumSize(new Dimension(5, 1));
        spacer4.setMaximumSize(new Dimension(5, 1));
        this.txtPort.setMinimumSize(new Dimension(50, 20));
        ++c.gridy;
        c.weighty = 10000.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel(), c);
        this.txtHost.setToolTipText(hlp.getHelpText("proxyhost"));
        this.txtPort.setToolTipText(hlp.getHelpText("proxyport"));
        this.btnOK.setToolTipText(hlp.getHelpText("okbutton"));
        this.btnCancel.setToolTipText(hlp.getHelpText("cancelbutton"));
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnOK) {
            Config.getInstance().setVal("proxy_host", this.txtHost.getText());
            Config.getInstance().setVal("proxy_port", this.txtPort.getText());
            this.ctrl.updateProxySettings(false);
        }
        this.dispose();
    }
}

