/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import org.gepard.client.Controller;
import org.gepard.common.Sequence;
import org.gepard.common.SubstitutionMatrix;

public class InfoPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -499089675210568791L;
    private Graphics2D bufferGraphics;
    private BufferedImage offscreen;
    private Graphics2D bufferFlashText;
    private BufferedImage offFlashText;
    private static final int COORDINATES_X = 10;
    private static final int COORDINATES_Y = 0;
    private static final int ALIGNMENT_MARGIN_LEFT = 10;
    private static final int ALIGNMENT_MARGIN_HOR_ADD = 10;
    private static final int MAX_ALIGNMENT_LENGTH = 1000;
    private int ALIGNMENT_Y = 0;
    private static final int MARGIN_BOTTOM = 5;
    private char[] strseq1 = new char[1000];
    private char[] strseq2 = new char[1000];
    private char[] strsim = new char[1000];
    private char[] strpos1 = new char[1000];
    private char[] strpos2 = new char[1000];
    private String markers;
    private boolean showingFlashText = false;
    private Controller ctrl;
    private int alignlen;
    private byte[] m_seq1;
    private byte[] m_seq2;
    private int m_seq1pos;
    private int m_seq2pos;
    private int m_off1;
    private int m_off2;
    private int m_arrlen1;
    private int m_arrlen2;
    private SubstitutionMatrix m_submat;
    private boolean m_complementary;

    public InfoPanel(Controller ctrl) {
        this.ctrl = ctrl;
        this.offscreen = new BufferedImage(1500, 200, 1);
        this.bufferGraphics = (Graphics2D)this.offscreen.getGraphics();
        this.bufferGraphics.fillRect(0, 0, 1500, 200);
        this.bufferGraphics.setFont(new Font("Courier", 0, 12));
        this.offFlashText = new BufferedImage(1500, 200, 1);
        this.bufferFlashText = (Graphics2D)this.offFlashText.getGraphics();
        this.bufferFlashText.fillRect(0, 0, 1500, 200);
        this.bufferFlashText.setFont(new Font("Courier", 0, 12));
        this.addComponentListener(this);
        this.ALIGNMENT_Y = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).getHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.showingFlashText) {
            g.drawImage(this.offscreen, 0, 0, this);
        } else {
            g.drawImage(this.offFlashText, 0, 0, this);
        }
    }

    public void showAlignments(boolean showalign) {
        if (showalign) {
            this.setPreferredSize(new Dimension(1, 5 + 8 * this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).getHeight()));
        } else {
            this.setPreferredSize(new Dimension(1, 5 + this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).getHeight()));
        }
        this.invalidate();
        this.ctrl.validateContainer();
    }

    public void setCoordinates(int x, int y, String multiName1, String multiName2) {
        String toDraw = "Position: " + x + ", " + y;
        String full = "";
        if (multiName1 != null) {
            full = "H: " + multiName1;
        }
        if (multiName1 != null && multiName2 != null) {
            full = String.valueOf(full) + "  ";
        }
        if (multiName2 != null) {
            full = String.valueOf(full) + "V: " + multiName2;
        }
        FontMetrics fm = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont());
        this.bufferGraphics.setColor(Color.WHITE);
        this.bufferGraphics.fillRect(10, 0, 1000, fm.getHeight());
        this.bufferGraphics.setColor(Color.BLACK);
        this.bufferGraphics.drawString(String.valueOf(toDraw) + "     " + full, 10, 0 + fm.getAscent());
        this.repaint();
    }

    public void setSelection(int x1, int y1, int x2, int y2) {
        int rx1 = 0;
        int ry1 = 0;
        int rx2 = 0;
        int ry2 = 0;
        rx1 = x1 < x2 ? x1 : x2;
        rx2 = x1 > x2 ? x1 : x2;
        ry1 = y1 < y2 ? y1 : y2;
        ry2 = y1 > y2 ? y1 : y2;
        String toDraw = "Selection: " + rx1 + "," + ry1 + "  -  " + rx2 + "," + ry2 + " (" + Math.abs(rx1 - rx2) + " x " + Math.abs(ry1 - ry2) + ")";
        FontMetrics fm = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont());
        this.bufferGraphics.setColor(Color.WHITE);
        this.bufferGraphics.fillRect(10, 0, 1000, fm.getHeight());
        this.bufferGraphics.setColor(Color.BLACK);
        this.bufferGraphics.drawString(toDraw, 10, 0 + fm.getAscent());
        this.repaint();
    }

    public void showAlignment(byte[] seq1, byte[] seq2, int offset1, int offset2, int arrlength1, int arrlength2, int seq1pos, int seq2pos, SubstitutionMatrix submat, boolean complementary) {
        int oddadd;
        this.m_seq1 = seq1;
        this.m_seq2 = seq2;
        this.m_off1 = offset1;
        this.m_off2 = offset2;
        this.m_arrlen1 = arrlength1;
        this.m_arrlen2 = arrlength2;
        this.m_seq1pos = seq1pos;
        this.m_seq2pos = seq2pos;
        this.m_submat = submat;
        this.m_complementary = complementary;
        this.bufferGraphics.setColor(Color.WHITE);
        this.bufferGraphics.fillRect(0, this.ALIGNMENT_Y, this.getSize().width, this.getSize().height - this.ALIGNMENT_Y);
        this.bufferGraphics.setColor(Color.BLACK);
        int backward = this.alignlen / 2;
        int forward = this.alignlen / 2;
        Arrays.fill(this.strpos1, ' ');
        Arrays.fill(this.strpos2, ' ');
        byte[] complmap = Sequence.getComplementaryMap();
        int j = 0;
        int i = -backward;
        while (i <= forward) {
            byte a = -1;
            byte b = -1;
            if (seq1pos + i - offset1 >= 0 && seq1pos + i - offset1 < seq1.length) {
                a = seq1[seq1pos + i - offset1];
            }
            if (!complementary) {
                if (seq2pos + i - offset2 >= 0 && seq2pos + i - offset2 < seq2.length) {
                    b = seq2[seq2pos + i - offset2];
                }
            } else if (seq2pos - i - offset2 >= 0 && seq2pos - i - offset2 < seq2.length) {
                b = complmap[seq2[seq2pos - i - offset2]];
            }
            this.strseq1[j] = a != -1 ? submat.reverseMap(a) : (char)32;
            this.strseq2[j] = b != -1 ? submat.reverseMap(b) : (char)32;
            this.strsim[j] = a != -1 && b != -1 ? this.getNuclSimCode(a, b, submat) : (char)32;
            ++j;
            ++i;
        }
        int n = oddadd = this.alignlen % 2 != 0 ? 1 : 0;
        if (seq1pos - backward - offset1 >= 0) {
            this.insertNumIntoCharArray(this.strpos1, 0, seq1pos - backward);
        }
        this.insertNumIntoCharArray(this.strpos1, forward, seq1pos);
        if (seq1pos + forward - offset1 <= seq1.length) {
            this.insertNumIntoCharArray(this.strpos1, oddadd + forward + backward - this.numLength(seq1pos + forward - 1), seq1pos + forward - 1);
        }
        if (!complementary) {
            if (seq2pos - backward - offset2 >= 0) {
                this.insertNumIntoCharArray(this.strpos2, 0, seq2pos - backward);
            }
            this.insertNumIntoCharArray(this.strpos2, forward, seq2pos);
            if (seq2pos + forward - offset2 <= seq2.length) {
                this.insertNumIntoCharArray(this.strpos2, oddadd + forward + backward - this.numLength(seq2pos + forward - 1), seq2pos + forward - 1);
            }
        } else {
            if (seq2pos + backward - offset2 < seq2.length) {
                this.insertNumIntoCharArray(this.strpos2, 0, seq2pos + backward);
            }
            this.insertNumIntoCharArray(this.strpos2, forward, seq2pos);
            if (seq2pos - forward - offset2 + 1 >= 0) {
                this.insertNumIntoCharArray(this.strpos2, oddadd + forward + backward - this.numLength(seq2pos - forward + 1), seq2pos - forward + 1);
            }
        }
        String pos1 = new String(this.strpos1);
        String pos2 = new String(this.strpos2);
        int ascent = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).getAscent();
        int charheight = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).getHeight();
        this.bufferGraphics.drawString(pos1, 10, this.ALIGNMENT_Y + ascent);
        this.bufferGraphics.drawString(this.markers, 10, this.ALIGNMENT_Y + charheight + ascent);
        this.bufferGraphics.drawString(String.valueOf(this.strseq1, 0, this.alignlen), 10, this.ALIGNMENT_Y + charheight * 2 + ascent);
        this.bufferGraphics.drawString(String.valueOf(this.strsim, 0, this.alignlen), 10, this.ALIGNMENT_Y + charheight * 3 + ascent);
        this.bufferGraphics.drawString(String.valueOf(this.strseq2, 0, this.alignlen), 10, this.ALIGNMENT_Y + charheight * 4 + ascent);
        this.bufferGraphics.drawString(this.markers, 10, this.ALIGNMENT_Y + charheight * 5 + ascent);
        this.bufferGraphics.drawString(pos2, 10, this.ALIGNMENT_Y + charheight * 6 + ascent);
        this.repaint();
    }

    public void removeAlignment() {
        this.m_seq1 = null;
        this.m_seq2 = null;
        this.m_submat = null;
        this.bufferGraphics.setColor(Color.WHITE);
        this.bufferGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        int s2len;
        int s1len;
        Dimension dim = this.getSize();
        int charwidth = this.bufferGraphics.getFontMetrics(this.bufferGraphics.getFont()).stringWidth("a");
        this.alignlen = (dim.width - 20) / charwidth;
        if (this.ctrl.dotplotExists() && this.alignlen > ((s1len = this.ctrl.getDPInfo().seq1len) < (s2len = this.ctrl.getDPInfo().seq2len) ? s1len : s2len)) {
            int n = this.alignlen = s1len < s2len ? s1len : s2len;
        }
        if (this.alignlen > 5) {
            this.constructMarker(this.alignlen);
            if (this.m_seq1 != null) {
                this.showAlignment(this.m_seq1, this.m_seq2, this.m_off1, this.m_off2, this.m_arrlen1, this.m_arrlen2, this.m_seq1pos, this.m_seq2pos, this.m_submat, this.m_complementary);
            }
        }
    }

    public void updateAlignment(boolean complemenatary) {
        if (this.m_seq1 != null) {
            this.showAlignment(this.m_seq1, this.m_seq2, this.m_off1, this.m_off2, this.m_arrlen1, this.m_arrlen2, this.m_seq1pos, this.m_seq2pos, this.m_submat, complemenatary);
        }
    }

    private void constructMarker(int alignlength) {
        char[] cmarkers = new char[alignlength];
        cmarkers[0] = 124;
        int i = 1;
        while (i < alignlength / 2) {
            cmarkers[i] = 32;
            ++i;
        }
        cmarkers[i] = 124;
        i = alignlength / 2 + 1;
        while (i < alignlength - 1) {
            cmarkers[i] = 32;
            ++i;
        }
        cmarkers[i] = 124;
        this.markers = String.valueOf(cmarkers);
    }

    private void insertNumIntoCharArray(char[] arr, int pos, int num) {
        String snum = "" + num;
        int mod = 0;
        if (pos + snum.length() > arr.length) {
            mod = pos + snum.length() - arr.length;
        }
        int i = 0;
        while (i < snum.length()) {
            arr[pos + i - mod] = snum.charAt(i);
            ++i;
        }
    }

    private int numLength(int num) {
        return new String("" + num).length();
    }

    private char getNuclSimCode(byte a, byte b, SubstitutionMatrix submat) {
        if (a == b) {
            return ':';
        }
        int score = submat.getScore(a, b);
        if (score > 0) {
            return '.';
        }
        return ' ';
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    public void flashMessage(String message, int seconds) {
        this.showingFlashText = true;
        this.bufferFlashText.setColor(Color.WHITE);
        this.bufferFlashText.fillRect(0, 0, 1500, 500);
        this.bufferFlashText.setColor(Color.RED);
        FontMetrics fm = this.bufferGraphics.getFontMetrics(this.bufferFlashText.getFont());
        this.bufferFlashText.drawString(message, 10, 0 + fm.getAscent());
        this.repaint();
        Timer x = new Timer();
        x.schedule((TimerTask)new EndFlashTimer(), seconds * 1000);
    }

    private class EndFlashTimer
    extends TimerTask {
        private EndFlashTimer() {
        }

        @Override
        public void run() {
            InfoPanel.this.showingFlashText = false;
        }
    }
}

