/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.gepard.common.SAXFinishedException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class HelpTexts
extends DefaultHandler {
    private static HelpTexts instance = null;
    private String curID = null;
    private String curText = null;
    private HashMap<String, String> texts;

    public static HelpTexts getInstance() {
        if (instance == null) {
            instance = new HelpTexts();
        }
        return instance;
    }

    public String getHelpText(String id) {
        String ret = this.texts.get(id);
        if (ret == null) {
            return "HELP TEXT WITH ID '" + id + "' DOES NOT EXIST!";
        }
        return ret;
    }

    private HelpTexts() {
        SAXParser p = new SAXParser();
        p.setContentHandler(this);
        this.texts = new HashMap();
        try {
            p.parse(new InputSource(this.getClass().getResourceAsStream("/resources/help/help.xml")));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not load help file '/resources/help/help.xml'.\n\nError:\n" + e.getMessage(), "Error", 2);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXFinishedException {
        if (localName.toLowerCase().equals("helpitem")) {
            this.curID = atts.getValue("id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXFinishedException {
        if (localName.toLowerCase().equals("helpitem")) {
            this.texts.put(this.curID, "<html>" + this.curText.trim().replace(new StringBuffer("\n"), new StringBuffer("<br>")) + "</html>");
            this.curID = null;
            this.curText = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.curID != null) {
            if (this.curText == null) {
                this.curText = "";
            }
            this.curText = String.valueOf(this.curText) + new String(ch, start, length).trim() + "\n";
        }
    }
}

