/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import org.gepard.client.Controller;
import org.gepard.client.DrawTarget;
import org.gepard.client.Plotter;

public class DrawPanel
extends JPanel
implements DrawTarget {
    private static final long serialVersionUID = 923132750680455953L;
    Plotter p = null;
    Controller ctrl = null;

    public DrawPanel(Controller ictrl) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (DrawPanel.this.p != null) {
                    DrawPanel.this.ctrl.eventMouseClick(evt.getX(), evt.getY(), evt.getButton());
                    DrawPanel.this.requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (DrawPanel.this.p != null) {
                    DrawPanel.this.ctrl.eventMouseRelease(evt.getX(), evt.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                if (DrawPanel.this.p != null) {
                    DrawPanel.this.ctrl.eventMouseMove(evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                if (DrawPanel.this.p != null) {
                    DrawPanel.this.ctrl.eventMouseDrag(evt.getX(), evt.getY());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DrawPanel.this.ctrl.eventKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                DrawPanel.this.ctrl.eventKeyReleased(evt);
            }
        });
        this.ctrl = ictrl;
        this.setFocusable(true);
    }

    public void setPlotter(Plotter ip) {
        this.p = ip;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 2000, 2000);
        if (this.p != null) {
            this.p.redraw((Graphics2D)g);
        }
    }
}

