/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gepard.client.ClientGlobals;
import org.gepard.client.Config;
import org.gepard.client.Controller;
import org.gepard.client.InvalidParamSetException;
import org.gepard.client.SubstMatrixFile;
import org.gepard.client.SubstMatrixList;
import org.gepard.client.userinterface.CustomComboBox;
import org.gepard.client.userinterface.ExampleFileFilter;
import org.gepard.client.userinterface.HelpTexts;
import org.gepard.client.userinterface.ProxyDialog;
import org.gepard.common.FASTAReader;
import org.gepard.common.InvalidFASTAFileException;
import org.gepard.common.InvalidSubMatFileException;
import org.gepard.common.ParameterSet;
import org.gepard.common.SubstitutionMatrix;

public class ControlPanel
extends JPanel
implements AdjustmentListener,
ActionListener,
ChangeListener {
    private static final long serialVersionUID = 2211444361988984615L;
    private static NumberFormat INTFMT = new DecimalFormat("###,###,###,###,##0", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final int HOR_MARGIN = 5;
    private static final int CMB_HEIGHT = 18;
    private static final int SEQ_HEIGHT = 218;
    private static final int FUNCT_HEIGHT = 132;
    private static final int OPT_HEIGHT = 285;
    private static final int SEQ_TAB_SPACE_TOP = 3;
    private static final int SEQ_TAB_SPACE_BOTTOM = 3;
    private static final int SEQ_TAB_BETWEEN_SEQS = 10;
    private static final int SEQ_TAB_INITIAL_TOP = 5;
    private static final int SEQ_TAB_BUTTON_HEIGHT = 20;
    private static final int FUNCT_BETWEEN_ZOOM = 5;
    private static final int FUNCT_MARGIN_ZOOM = 10;
    private static final int FUNCT_GOADV_HOR_MARGIN = 40;
    private static final int FUNCT_ABOVE_GO = 8;
    private static final int FUNCT_BELOW_GO = 12;
    private static final int FUNCT_ABOVE_ADV = 20;
    private static final int PLOTOPT_VERTSPACE = 2;
    private static final int PLOTOPT_EXTRAVERT = 5;
    private static final int PLOTOPT_BEGIN_VERTSPACE = 5;
    private static final int PLOTOPT_ITEMS_INDENT = 6;
    private static final int MISC_VERTSPACE = 2;
    private static final int MISC_EXTRAVERT = 6;
    private static final int MISC_INITVERT = 3;
    private static final int DISP_VERT_SMALL = 4;
    private static final int DISP_VERT_BIG = 8;
    private static final int DISP_ABOVE_EXPORT = 5;
    private static final int QUIT_BTN_HEIGHT = 27;
    private static final int BELOW_QUIT_BTN = 5;
    private static final int QUIT_BTN_HOR_MARGIN = 40;
    private static final Font MAIN_FONT = new Font("Dialog", 1, 11);
    private static final Font CAPT_FONT = new Font("Dialog", 1, 12);
    private static final Font TEXT_FONT = new Font("Dialog", 0, 11);
    private JTabbedPane seqTabs;
    private JTabbedPane optTabs;
    private JButton btnLocalSeq1;
    private JButton btnLocalSeq2;
    private JTextField txtLocalSeq1;
    private JTextField txtLocalSeq2;
    private JCheckBox chkFirstComp;
    private JCheckBox chkSecondComp;
    private JCheckBox chkAutoZoom;
    private JCheckBox chkSmallPlots;
    private JCheckBox chkAutoParams;
    private JCheckBox chkAutoMatrix;
    private JTextField txtZoom;
    private JTextField txtWordlen;
    private JTextField txtWinsize;
    private CustomComboBox cmbMatrices;
    private JTextField txtStart1;
    private JTextField txtStop1;
    private JTextField txtStart2;
    private JTextField txtStop2;
    private JCheckBox chkSaveSA;
    private JLabel lblSASpace;
    private JButton btnDeleteSAs;
    private JRadioButton optLocalShowAlign;
    private JRadioButton optLocalExport;
    private JRadioButton optLocalDoNothing;
    private JButton btnSetupProxy;
    private JPanel dispTab;
    private JScrollBar scrLower;
    private JScrollBar scrUpper;
    private JScrollBar scrGreyscale;
    private JCheckBox chkRevCompAlign;
    private JButton btnGo;
    private JButton btnAdvanced;
    private JButton btnFullPlot;
    private JButton btnZoomOut;
    private JButton btnExportFile;
    private JButton btnZoomIn;
    private JButton btnQuit;
    private String curSubmatName;
    private boolean isAdvancedMode = false;
    private SubstMatrixFile[] substMatrices;
    private SubstitutionMatrix customMatrix = null;
    private boolean needreload;
    private boolean noScrollbarEvents = false;
    Controller ctrl;

    public ControlPanel(Controller ictrl) {
        this.ctrl = ictrl;
        try {
            this.substMatrices = SubstMatrixList.getInstance().getMatrixFiles();
        }
        catch (Exception e) {
            ClientGlobals.errMessage("Could not open substitution matrix list. The 'matrices/' subfolder seems to be corrupted");
            System.exit(1);
        }
        JPanel localTab = this.generateLocalTab();
        this.seqTabs = new JTabbedPane();
        this.seqTabs.addTab("Sequences", localTab);
        this.seqTabs.addChangeListener(this);
        JPanel functPanel = this.generateFunctionPanel();
        JPanel plotOptTab = this.generatePlotOptTab();
        JPanel miscTab = this.generateMiscTab();
        this.dispTab = this.generateDispTab();
        this.optTabs = new JTabbedPane();
        this.optTabs.setFont(MAIN_FONT);
        this.optTabs.addTab("Plot", plotOptTab);
        this.optTabs.addTab("Misc", miscTab);
        this.optTabs.addTab("Display", this.dispTab);
        this.optTabs.setSelectedIndex(0);
        this.seqTabs.setAlignmentX(0.0f);
        this.optTabs.setAlignmentX(0.0f);
        this.btnGo.setAlignmentX(0.0f);
        functPanel.setAlignmentX(0.0f);
        JPanel fixedBox = new JPanel();
        fixedBox.setLayout(new BoxLayout(fixedBox, 1));
        fixedBox.add(Box.createRigidArea(new Dimension(0, 3)));
        fixedBox.add(this.seqTabs);
        fixedBox.add(Box.createRigidArea(new Dimension(0, 10)));
        fixedBox.add(functPanel);
        fixedBox.add(Box.createRigidArea(new Dimension(0, 10)));
        fixedBox.add(this.optTabs);
        this.seqTabs.setPreferredSize(new Dimension(1, 218));
        functPanel.setPreferredSize(new Dimension(1, 132));
        this.optTabs.setPreferredSize(new Dimension(1, 285));
        JPanel panelQuit = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1000.0;
        panelQuit.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.weighty = 1.0;
        c.insets = new Insets(0, 45, 5, 45);
        this.btnQuit = new JButton("Quit");
        panelQuit.add((Component)this.btnQuit, c);
        this.btnQuit.setPreferredSize(new Dimension(1, 27));
        this.setLayout(new BorderLayout());
        this.add((Component)fixedBox, "North");
        this.add((Component)panelQuit, "Center");
        this.btnQuit.addActionListener(this);
        if (Config.getInstance().getIntVal("advanced", 0) == 1) {
            this.switchMode(true);
        } else {
            this.switchMode(false);
        }
        this.btnQuit.setToolTipText(HelpTexts.getInstance().getHelpText("quit"));
        this.needreload = true;
        this.setDispTabEnabled(false);
        this.setNavigationEnabled(false);
    }

    public void setGoButtonCaption(boolean update) {
        if (update) {
            this.btnGo.setText("Update dotplot");
        } else {
            this.btnGo.setText("Create dotplot");
        }
    }

    private JPanel generateFunctionPanel() {
        HelpTexts hlp = HelpTexts.getInstance();
        JPanel functPane = new JPanel();
        functPane.setLayout(new GridBagLayout());
        ImageIcon icoZoomIn = new ImageIcon(this.getClass().getResource("/resources/images/zoomin.gif"));
        ImageIcon icoZoomOut = new ImageIcon(this.getClass().getResource("/resources/images/zoomout.gif"));
        ImageIcon icoShowFull = new ImageIcon(this.getClass().getResource("/resources/images/zoomfull.gif"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 4;
        c.insets = new Insets(8, 40, 12, 40);
        this.btnGo = this.getCustomButton("");
        functPane.add((Component)this.btnGo, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.insets = new Insets(0, 15, 0, 5);
        this.btnZoomIn = new JButton(icoZoomIn);
        functPane.add((Component)this.btnZoomIn, c);
        ++c.gridx;
        c.insets = new Insets(0, 5, 0, 5);
        this.btnZoomOut = new JButton(icoZoomOut);
        functPane.add((Component)this.btnZoomOut, c);
        ++c.gridx;
        this.btnFullPlot = new JButton(icoShowFull);
        functPane.add((Component)this.btnFullPlot, c);
        c.insets = new Insets(20, 40, 0, 40);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.btnAdvanced = this.getCustomButton("");
        functPane.add((Component)this.btnAdvanced, c);
        this.setGoButtonCaption(false);
        ++c.gridy;
        c.weighty = 10000.0;
        c.gridwidth = 1;
        functPane.add((Component)new JLabel(), c);
        this.btnGo.addActionListener(this);
        this.btnAdvanced.addActionListener(this);
        this.btnFullPlot.addActionListener(this);
        this.btnZoomIn.addActionListener(this);
        this.btnZoomOut.addActionListener(this);
        this.btnGo.setToolTipText(hlp.getHelpText("createplot"));
        this.btnZoomIn.setToolTipText(hlp.getHelpText("zoomin"));
        this.btnZoomOut.setToolTipText(hlp.getHelpText("zoomout"));
        this.btnFullPlot.setToolTipText(hlp.getHelpText("fullplot"));
        this.btnAdvanced.setToolTipText(hlp.getHelpText("advmode"));
        return functPane;
    }

    private JPanel generateLocalTab() {
        HelpTexts hlp = HelpTexts.getInstance();
        JPanel localPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(8, 5, 3, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 17;
        localPanel.add((Component)this.getLargeLabel("Sequence 1 (horizontal):"), c);
        c.insets = new Insets(3, 5, 3, 5);
        ++c.gridy;
        this.txtLocalSeq1 = this.getCustomTextField("");
        localPanel.add((Component)this.txtLocalSeq1, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.anchor = 17;
        this.chkFirstComp = this.getCustomCheckbox("Complementary");
        localPanel.add((Component)this.chkFirstComp, c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 13;
        this.btnLocalSeq1 = this.getCustomButton("Select file");
        localPanel.add((Component)this.btnLocalSeq1, c);
        this.btnLocalSeq1.setPreferredSize(new Dimension(100, 20));
        this.btnLocalSeq1.setMinimumSize(new Dimension(100, 20));
        c.gridwidth = 2;
        c.gridx = 0;
        c.insets = new Insets(13, 5, 3, 5);
        c.fill = 2;
        c.anchor = 17;
        ++c.gridy;
        localPanel.add((Component)this.getLargeLabel("Sequence 2 (vertical):"), c);
        c.insets = new Insets(3, 5, 3, 5);
        ++c.gridy;
        this.txtLocalSeq2 = this.getCustomTextField("");
        localPanel.add((Component)this.txtLocalSeq2, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.anchor = 17;
        this.chkSecondComp = this.getCustomCheckbox("Complementary");
        localPanel.add((Component)this.chkSecondComp, c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 13;
        this.btnLocalSeq2 = this.getCustomButton("Select file");
        localPanel.add((Component)this.btnLocalSeq2, c);
        this.btnLocalSeq2.setPreferredSize(new Dimension(100, 20));
        this.btnLocalSeq2.setMinimumSize(new Dimension(100, 20));
        ++c.gridy;
        c.weighty = 200.0;
        localPanel.add((Component)new JLabel(""), c);
        this.txtLocalSeq1.setToolTipText(hlp.getHelpText("sequence1"));
        this.btnLocalSeq1.setToolTipText(hlp.getHelpText("sequence1select"));
        this.txtLocalSeq2.setToolTipText(hlp.getHelpText("sequence2"));
        this.btnLocalSeq2.setToolTipText(hlp.getHelpText("sequence2select"));
        this.btnLocalSeq1.addActionListener(this);
        this.btnLocalSeq2.addActionListener(this);
        this.chkFirstComp.addActionListener(this);
        this.chkSecondComp.addActionListener(this);
        return localPanel;
    }

    private JPanel generatePlotOptTab() {
        HelpTexts hlp = HelpTexts.getInstance();
        JPanel plotOptTab = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        Insets defInsets = new Insets(0, 5, 2, 5);
        Insets leftspaceInsets = new Insets(0, 11, 2, 5);
        Insets extraVertInsets = new Insets(0, 11, 7, 5);
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 2, 5);
        plotOptTab.add((Component)this.getCustomLabel("Coordinates"), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = leftspaceInsets;
        JLabel start1 = this.getCustomLabel("Start 1:");
        plotOptTab.add((Component)start1, c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtStart1 = this.getCustomTextField("0", 20);
        plotOptTab.add((Component)this.txtStart1, c);
        ++c.gridx;
        c.insets = leftspaceInsets;
        JLabel horStretcher = new JLabel();
        plotOptTab.add(horStretcher);
        c.gridx = 0;
        ++c.gridy;
        c.insets = leftspaceInsets;
        plotOptTab.add((Component)this.getCustomLabel("Stop 1:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtStop1 = this.getCustomTextField("0", 20);
        plotOptTab.add((Component)this.txtStop1, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = leftspaceInsets;
        plotOptTab.add((Component)this.getCustomLabel("Start 2:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtStart2 = this.getCustomTextField("0", 20);
        plotOptTab.add((Component)this.txtStart2, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = extraVertInsets;
        plotOptTab.add((Component)this.getCustomLabel("Stop 2:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtStop2 = this.getCustomTextField("0", 20);
        plotOptTab.add((Component)this.txtStop2, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = defInsets;
        this.chkAutoZoom = this.getCustomCheckbox("Auto zoom");
        plotOptTab.add((Component)this.chkAutoZoom, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.chkSmallPlots = this.getCustomCheckbox("Small plots");
        plotOptTab.add((Component)this.chkSmallPlots, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = extraVertInsets;
        plotOptTab.add((Component)this.getCustomLabel("Zoom:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtZoom = this.getCustomTextField("0", 5);
        plotOptTab.add((Component)this.txtZoom, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.chkAutoParams = this.getCustomCheckbox("Auto params");
        plotOptTab.add((Component)this.chkAutoParams, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = leftspaceInsets;
        plotOptTab.add((Component)this.getCustomLabel("Word length:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtWordlen = this.getCustomTextField("10", 5);
        plotOptTab.add((Component)this.txtWordlen, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = extraVertInsets;
        plotOptTab.add((Component)this.getCustomLabel("Window size:"), c);
        ++c.gridx;
        c.insets = defInsets;
        this.txtWinsize = this.getCustomTextField("0", 5);
        plotOptTab.add((Component)this.txtWinsize, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.chkAutoMatrix = this.getCustomCheckbox("Auto matrix");
        plotOptTab.add((Component)this.chkAutoMatrix, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = leftspaceInsets;
        plotOptTab.add((Component)this.getCustomLabel("Use matrix:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = defInsets;
        c.fill = 0;
        c.weighty = 1.0;
        this.cmbMatrices = this.getCustomComboBox();
        plotOptTab.add((Component)this.cmbMatrices, c);
        this.cmbMatrices.setMaximumSize(new Dimension(170, 18));
        this.cmbMatrices.setMinimumSize(new Dimension(170, 18));
        this.cmbMatrices.setPreferredSize(new Dimension(170, 18));
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 10000.0;
        c.gridwidth = 1;
        plotOptTab.add((Component)new JLabel(""), c);
        horStretcher.setMinimumSize(new Dimension(50, 1));
        start1.setMinimumSize(new Dimension(140, 15));
        this.chkAutoZoom.setToolTipText(hlp.getHelpText("autozoom"));
        this.txtZoom.setToolTipText(hlp.getHelpText("zoom"));
        this.chkAutoParams.setToolTipText(hlp.getHelpText("autoparams"));
        this.txtWordlen.setToolTipText(hlp.getHelpText("wordlen"));
        this.txtWinsize.setToolTipText(hlp.getHelpText("winsize"));
        this.txtStart1.setToolTipText(hlp.getHelpText("coordinates"));
        this.txtStop1.setToolTipText(hlp.getHelpText("coordinates"));
        this.txtStart2.setToolTipText(hlp.getHelpText("coordinates"));
        this.txtStop2.setToolTipText(hlp.getHelpText("coordinates"));
        this.chkAutoMatrix.setToolTipText(hlp.getHelpText("automatrix"));
        this.cmbMatrices.setToolTipText(hlp.getHelpText("substmatrix"));
        this.chkSmallPlots.setToolTipText(hlp.getHelpText("smallplots"));
        this.txtZoom.setInputVerifier(new IntVerifier("Ratio", 0, 1000000));
        this.txtWordlen.setInputVerifier(new IntVerifier("Word length", 0, Short.MAX_VALUE));
        this.txtWinsize.setInputVerifier(new IntVerifier("Window size", 0, 10000));
        this.txtStart1.setInputVerifier(new IntVerifier("Coordinates", 0, Integer.MAX_VALUE));
        this.txtStop1.setInputVerifier(new IntVerifier("Coordinates", 0, Integer.MAX_VALUE));
        this.txtStart2.setInputVerifier(new IntVerifier("Coordinates", 0, Integer.MAX_VALUE));
        this.txtStop2.setInputVerifier(new IntVerifier("Coordinates", 0, Integer.MAX_VALUE));
        this.chkAutoZoom.addActionListener(this);
        this.chkAutoParams.addActionListener(this);
        this.chkAutoMatrix.addActionListener(this);
        this.cmbMatrices.addActionListener(this);
        this.chkSmallPlots.addActionListener(this);
        this.chkAutoZoom.setSelected(Config.getInstance().getIntVal("autozoom", 1) == 1);
        this.chkAutoParams.setSelected(Config.getInstance().getIntVal("autoparams", 1) == 1);
        this.chkAutoMatrix.setSelected(Config.getInstance().getIntVal("automatrix", 1) == 1);
        this.chkSmallPlots.setSelected(Config.getInstance().getIntVal("smallplots", 0) == 1);
        this.txtZoom.setEnabled(!this.chkAutoZoom.isSelected());
        this.txtWordlen.setEnabled(!this.chkAutoParams.isSelected());
        this.txtWinsize.setEnabled(!this.chkAutoParams.isSelected());
        this.cmbMatrices.setEnabled(!this.chkAutoMatrix.isSelected());
        this.chkSmallPlots.setEnabled(this.chkAutoZoom.isSelected());
        this.fillSubstMatrixCombo();
        return plotOptTab;
    }

    private void switchMode(boolean advanced) {
        if (advanced) {
            this.btnAdvanced.setText("<< Simple mode");
            this.optTabs.setVisible(true);
            this.isAdvancedMode = true;
        } else {
            this.btnAdvanced.setText(">> Advanced mode");
            this.optTabs.setVisible(false);
            this.isAdvancedMode = false;
        }
        Config.getInstance().setIntVal("advanced", this.isAdvancedMode ? 1 : 0);
    }

    private void fillSubstMatrixCombo() {
        this.cmbMatrices.removeAllItems();
        int i = 0;
        while (i < this.substMatrices.length) {
            this.cmbMatrices.addItem(this.substMatrices[i].getName());
            ++i;
        }
        this.cmbMatrices.adaptPopupWidth();
    }

    private JPanel generateMiscTab() {
        JPanel miscTab = new JPanel();
        HelpTexts hlp = HelpTexts.getInstance();
        miscTab.setLayout(new GridBagLayout());
        Insets defInsets = new Insets(2, 5, 0, 5);
        Insets extraVertInsets = new Insets(2, 5, 6, 5);
        Insets initInsets = new Insets(5, 5, 0, 5);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        ++c.gridy;
        c.insets = initInsets;
        this.chkSaveSA = this.getCustomCheckbox("Save suffix arrays ");
        miscTab.add((Component)this.chkSaveSA, c);
        ++c.gridy;
        c.insets = defInsets;
        this.lblSASpace = this.getCustomLabel("");
        miscTab.add((Component)this.lblSASpace, c);
        ++c.gridy;
        c.insets = extraVertInsets;
        this.btnDeleteSAs = this.getCustomButton("Delete suffix array files");
        miscTab.add((Component)this.btnDeleteSAs, c);
        ++c.gridy;
        c.insets = defInsets;
        miscTab.add((Component)this.getCustomLabel("Local dotplot click action..."), c);
        ++c.gridy;
        this.optLocalShowAlign = this.getCustomRadioButton("... show alignment");
        miscTab.add((Component)this.optLocalShowAlign, c);
        ++c.gridy;
        this.optLocalExport = this.getCustomRadioButton("... export window to FASTA");
        miscTab.add((Component)this.optLocalExport, c);
        ++c.gridy;
        c.insets = extraVertInsets;
        this.optLocalDoNothing = this.getCustomRadioButton("... do nothing");
        miscTab.add((Component)this.optLocalDoNothing, c);
        ++c.gridy;
        this.btnSetupProxy = this.getCustomButton("HTTP proxy settings");
        miscTab.add((Component)this.btnSetupProxy, c);
        this.btnDeleteSAs.setPreferredSize(new Dimension(175, 24));
        this.btnDeleteSAs.setMinimumSize(new Dimension(175, 24));
        this.btnSetupProxy.setPreferredSize(new Dimension(175, 24));
        this.btnSetupProxy.setMinimumSize(new Dimension(175, 24));
        ++c.gridy;
        c.weighty = 100000.0;
        c.gridwidth = 1;
        miscTab.add((Component)new JLabel(""), c);
        this.updateSADiskSpace();
        this.optLocalShowAlign.setSelected(true);
        ButtonGroup localGrp = new ButtonGroup();
        localGrp.add(this.optLocalShowAlign);
        localGrp.add(this.optLocalExport);
        localGrp.add(this.optLocalDoNothing);
        this.chkSaveSA.setSelected(Config.getInstance().getIntVal("savesa", 0) == 1);
        this.optLocalShowAlign.setSelected(Config.getInstance().getIntVal("local_click", 0) == 0);
        this.optLocalExport.setSelected(Config.getInstance().getIntVal("local_click", 0) == 1);
        this.optLocalDoNothing.setSelected(Config.getInstance().getIntVal("local_click", 0) == 2);
        this.ctrl.showAlignments(this.optLocalShowAlign.isSelected());
        this.chkSaveSA.addActionListener(this);
        this.optLocalShowAlign.addActionListener(this);
        this.optLocalExport.addActionListener(this);
        this.optLocalDoNothing.addActionListener(this);
        this.btnDeleteSAs.addActionListener(this);
        this.btnSetupProxy.addActionListener(this);
        this.chkSaveSA.setToolTipText(hlp.getHelpText("savesa"));
        this.optLocalShowAlign.setToolTipText(hlp.getHelpText("localclick"));
        this.optLocalDoNothing.setToolTipText(hlp.getHelpText("localclick"));
        this.btnDeleteSAs.setToolTipText(hlp.getHelpText("deletesas"));
        this.btnSetupProxy.setToolTipText(hlp.getHelpText("httpproxy"));
        return miscTab;
    }

    private JRadioButton getCustomRadioButton(String caption) {
        JRadioButton ret = new JRadioButton(caption);
        ret.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ret.setFont(MAIN_FONT);
        return ret;
    }

    private JCheckBox getCustomCheckbox(String caption) {
        JCheckBox ret = new JCheckBox(caption);
        ret.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ret.setFont(MAIN_FONT);
        return ret;
    }

    private JButton getCustomButton(String caption) {
        JButton ret = new JButton(caption);
        ret.setFont(MAIN_FONT);
        return ret;
    }

    private JLabel getCustomLabel(String caption) {
        JLabel ret = new JLabel(caption);
        ret.setFont(MAIN_FONT);
        return ret;
    }

    private JLabel getLargeLabel(String caption) {
        JLabel ret = new JLabel(caption);
        ret.setFont(CAPT_FONT);
        return ret;
    }

    private JTextField getCustomTextField(String text, int size) {
        JTextField ret = new JTextField(text, size);
        ret.setFont(TEXT_FONT);
        return ret;
    }

    private JTextField getCustomTextField(String text) {
        JTextField ret = new JTextField(text);
        ret.setFont(TEXT_FONT);
        return ret;
    }

    private CustomComboBox getCustomComboBox() {
        CustomComboBox ret = new CustomComboBox();
        ret.setFont(TEXT_FONT);
        ret.setPreferredSize(new Dimension(1, 18));
        return ret;
    }

    private JPanel generateDispTab() {
        JPanel dispTab = new JPanel();
        HelpTexts hlp = HelpTexts.getInstance();
        ImageIcon icoExport = new ImageIcon(this.getClass().getResource("/resources/images/export.gif"));
        Insets smallInsets = new Insets(4, 5, 0, 5);
        Insets bigInsets = new Insets(8, 5, 0, 5);
        Insets extraInsets = new Insets(13, 5, 0, 5);
        GridBagConstraints c = new GridBagConstraints();
        dispTab.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = smallInsets;
        dispTab.add((Component)this.getCustomLabel("Lower color limit:"), c);
        ++c.gridy;
        this.scrLower = new JScrollBar(0, 0, 0, 0, 1);
        dispTab.add((Component)this.scrLower, c);
        ++c.gridy;
        c.insets = bigInsets;
        dispTab.add((Component)this.getCustomLabel("Upper color limit:"), c);
        ++c.gridy;
        c.insets = smallInsets;
        this.scrUpper = new JScrollBar(0, 0, 0, 0, 1);
        dispTab.add((Component)this.scrUpper, c);
        ++c.gridy;
        c.insets = bigInsets;
        dispTab.add((Component)this.getCustomLabel("Greyscale start:"), c);
        ++c.gridy;
        c.insets = smallInsets;
        this.scrGreyscale = new JScrollBar(0, 0, 0, 0, 100);
        dispTab.add((Component)this.scrGreyscale, c);
        ++c.gridy;
        c.insets = bigInsets;
        this.chkRevCompAlign = this.getCustomCheckbox("Reverse complementary alignment");
        dispTab.add((Component)this.chkRevCompAlign, c);
        ++c.gridy;
        c.insets = smallInsets;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 17;
        c.insets = extraInsets;
        c.gridwidth = 1;
        dispTab.add((Component)this.getCustomLabel("Export image:"), c);
        ++c.gridx;
        c.anchor = 13;
        this.btnExportFile = new JButton(icoExport);
        dispTab.add((Component)this.btnExportFile, c);
        ++c.gridy;
        c.weighty = 10000.0;
        c.gridwidth = 1;
        dispTab.add((Component)new JLabel(), c);
        this.scrLower.setToolTipText(hlp.getHelpText("lowerlimit"));
        this.scrUpper.setToolTipText(hlp.getHelpText("upperlimit"));
        this.scrGreyscale.setToolTipText(hlp.getHelpText("greyscale"));
        this.btnExportFile.setToolTipText(hlp.getHelpText("export"));
        this.chkRevCompAlign.setToolTipText(hlp.getHelpText("reversecomplementary"));
        this.scrLower.addAdjustmentListener(this);
        this.scrUpper.addAdjustmentListener(this);
        this.scrGreyscale.addAdjustmentListener(this);
        this.btnExportFile.addActionListener(this);
        this.chkRevCompAlign.addActionListener(this);
        this.btnExportFile.setMaximumSize(new Dimension(20, 30));
        return dispTab;
    }

    private void setDispTabEnabled(boolean e) {
        Component[] components = this.dispTab.getComponents();
        int i = 0;
        while (i < components.length) {
            components[i].setEnabled(e);
            ++i;
        }
    }

    private void setNavigationEnabled(boolean e) {
        this.btnZoomOut.setEnabled(e);
        this.btnZoomIn.setEnabled(e);
        this.btnFullPlot.setEnabled(e);
        this.btnExportFile.setEnabled(e);
    }

    public void dotplotStartCalc() {
        this.btnGo.setEnabled(false);
        this.setDispTabEnabled(false);
        this.setNavigationEnabled(false);
    }

    public void dotplotReady() {
        this.btnGo.setEnabled(true);
        this.setDispTabEnabled(true);
        this.setNavigationEnabled(true);
    }

    public void dotplotFailed() {
        this.btnGo.setEnabled(true);
        if (this.ctrl.dotplotExists()) {
            this.setDispTabEnabled(true);
            this.setNavigationEnabled(true);
        }
        this.txtStart1.setText("0");
        this.txtStop1.setText("0");
        this.txtStart2.setText("0");
        this.txtStop2.setText("0");
    }

    public boolean saveSuffixArrays() {
        return this.chkSaveSA.isSelected();
    }

    public boolean needReload() {
        return this.needreload;
    }

    public void setNeedReload(boolean c) {
        this.needreload = c;
    }

    public void setupScrollbars(float lowest, float highest) {
        this.noScrollbarEvents = true;
        this.scrLower.setMaximum((int)(highest * 100.0f));
        this.scrUpper.setMaximum((int)(highest * 100.0f));
        this.scrLower.setMinimum((int)(lowest * 100.0f));
        this.scrUpper.setMinimum((int)(lowest * 100.0f));
        this.scrLower.setUnitIncrement((int)(highest / 10.0f));
        this.scrLower.setBlockIncrement((int)highest);
        this.scrUpper.setUnitIncrement((int)(highest / 10.0f));
        this.scrUpper.setBlockIncrement((int)highest);
        this.noScrollbarEvents = false;
    }

    public void setScrollbars(float percentLower, float percentUpper, float percentGreyscale, float percentFunCats) {
        this.noScrollbarEvents = true;
        this.scrUpper.setValue((int)((float)(this.scrUpper.getMaximum() - this.scrUpper.getMinimum()) / 100.0f * percentUpper) + this.scrUpper.getMinimum());
        this.scrLower.setValue((int)((float)(this.scrLower.getMaximum() - this.scrLower.getMinimum()) / 100.0f * percentLower) + this.scrLower.getMinimum());
        this.scrGreyscale.setValue((int)((float)(this.scrGreyscale.getMaximum() - this.scrGreyscale.getMinimum()) / 100.0f * percentGreyscale) + this.scrGreyscale.getMinimum());
        this.noScrollbarEvents = false;
        this.adjustmentValueChanged(null);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        try {
            if (!this.noScrollbarEvents) {
                int lv = this.scrLower.getValue();
                int uv = this.scrUpper.getValue();
                int gv = this.scrGreyscale.getValue();
                if (lv >= uv) {
                    this.scrLower.setValue(uv - 1);
                    lv = uv - 1;
                }
                this.ctrl.eventReplot((float)lv / 100.0f, (float)uv / 100.0f, (float)gv / 100.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientGlobals.unexpectedError(e, this.ctrl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            if (evt.getSource() == this.cmbMatrices) {
                this.needreload = true;
                if (this.substMatrices[this.cmbMatrices.getSelectedIndex()].getFile().equals("-")) {
                    FileChooseResult f = this.showFileDialog("Select matrix file", true, false);
                    if (f.file != null) {
                        try {
                            this.customMatrix = SubstitutionMatrix.loadFromFile(f.file);
                            this.customMatrix.setNucleotideMatrix(false);
                        }
                        catch (InvalidSubMatFileException e) {
                            ClientGlobals.warnMessage("The substitution matrix seems to be invalid.\nPlease specify a matrix file in Blast compatible format.");
                            this.customMatrix = null;
                        }
                    }
                } else {
                    this.customMatrix = null;
                }
            } else if (evt.getSource() == this.btnLocalSeq1 || evt.getSource() == this.btnLocalSeq2) {
                FileChooseResult f = this.showFileDialog("Select sequence file", true, false);
                if (f.file != null) {
                    if (evt.getSource() == this.btnLocalSeq1) {
                        this.txtLocalSeq1.setText(f.file);
                    } else {
                        this.txtLocalSeq2.setText(f.file);
                    }
                    this.newDotplot();
                }
            } else if (evt.getSource() == this.btnGo) {
                this.initiateLocalDotplot();
            } else if (evt.getSource() == this.chkAutoZoom) {
                this.txtZoom.setEnabled(!this.chkAutoZoom.isSelected());
                this.chkSmallPlots.setEnabled(this.chkAutoZoom.isSelected());
                this.chkSmallPlots.setSelected(false);
                Config.getInstance().setVal("autozoom", this.chkAutoZoom.isSelected() ? "1" : "0");
            } else if (evt.getSource() == this.chkAutoParams) {
                this.txtWordlen.setEnabled(!this.chkAutoParams.isSelected());
                this.txtWinsize.setEnabled(!this.chkAutoParams.isSelected());
                Config.getInstance().setVal("autoparams", this.chkAutoParams.isSelected() ? "1" : "0");
            } else if (evt.getSource() == this.btnFullPlot) {
                this.ctrl.zoomFullPlot();
            } else if (evt.getSource() == this.btnZoomOut) {
                this.ctrl.zoom(2.0f);
            } else if (evt.getSource() == this.btnZoomIn) {
                this.ctrl.zoom(0.5f);
            } else if (evt.getSource() == this.btnExportFile) {
                FileChooseResult f = this.showFileDialog("Store plot to image file", false, true);
                if (f.file != null) {
                    this.ctrl.eventExportImage(f.file, f.type);
                }
            } else if (evt.getSource() == this.chkSaveSA) {
                Config.getInstance().setVal("savesa", this.chkSaveSA.isSelected() ? "1" : "0");
            } else if (evt.getSource() == this.optLocalShowAlign) {
                this.setupForAlignments();
                Config.getInstance().setVal("local_click", "0");
            } else if (evt.getSource() == this.optLocalExport) {
                this.setupForAlignments();
                Config.getInstance().setVal("local_click", "1");
            } else if (evt.getSource() == this.optLocalDoNothing) {
                this.setupForAlignments();
                Config.getInstance().setVal("local_click", "2");
            } else if (evt.getSource() == this.btnAdvanced) {
                this.switchMode(!this.isAdvancedMode);
            } else if (evt.getSource() == this.chkAutoMatrix) {
                if (this.chkAutoMatrix.isSelected()) {
                    this.cmbMatrices.setEnabled(false);
                    this.cmbMatrices.setSelectedIndex(0);
                    Config.getInstance().setVal("automatrix", "1");
                } else {
                    this.cmbMatrices.setEnabled(true);
                    Config.getInstance().setVal("automatrix", "0");
                }
            } else if (evt.getSource() == this.btnDeleteSAs) {
                this.deleteSAFiles();
                this.updateSADiskSpace();
            } else if (evt.getSource() == this.btnQuit) {
                this.ctrl.exit();
            } else if (evt.getSource() == this.btnSetupProxy) {
                new ProxyDialog(this.ctrl);
            } else if (evt.getSource() == this.chkSmallPlots) {
                Config.getInstance().setVal("smallplots", this.chkSmallPlots.isSelected() ? "1" : "0");
            } else if (evt.getSource() == this.chkFirstComp) {
                if (this.chkFirstComp.isSelected()) {
                    this.chkSecondComp.setSelected(false);
                }
                this.newDotplot();
            } else if (evt.getSource() == this.chkSecondComp) {
                if (this.chkSecondComp.isSelected()) {
                    this.chkFirstComp.setSelected(false);
                }
                this.newDotplot();
            } else if (evt.getSource() == this.chkRevCompAlign) {
                this.ctrl.updateAlignment();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientGlobals.unexpectedError(e, this.ctrl);
        }
    }

    private void setupForAlignments() {
        if (this.optLocalShowAlign.isSelected()) {
            this.ctrl.showAlignments(true);
        } else {
            this.ctrl.showAlignments(false);
        }
    }

    private void newDotplot() {
        this.needreload = true;
        this.txtStart1.setText("0");
        this.txtStop1.setText("0");
        this.txtStart2.setText("0");
        this.txtStop2.setText("0");
        this.setGoButtonCaption(false);
    }

    private void initiateLocalDotplot() {
        ParameterSet params;
        SubstitutionMatrix mat;
        boolean secondSecIsNucl;
        boolean firstSecIsNucl;
        if (this.txtLocalSeq1.getText().trim().equals("") || this.txtLocalSeq2.getText().trim().equals("")) {
            ClientGlobals.warnMessage("Please select two sequence files.");
            return;
        }
        try {
            firstSecIsNucl = FASTAReader.isNucleotideFile(this.txtLocalSeq1.getText());
        }
        catch (IOException e) {
            ClientGlobals.errMessage("Failed loading sequence file 1\nIO error: " + e.getMessage());
            return;
        }
        catch (InvalidFASTAFileException e) {
            ClientGlobals.errMessage("Failed loading sequence file 1\nInvalid FASTA file: " + e.getMessage());
            return;
        }
        try {
            secondSecIsNucl = FASTAReader.isNucleotideFile(this.txtLocalSeq2.getText());
        }
        catch (IOException e) {
            ClientGlobals.errMessage("Failed loading sequence file 2\nIO error: " + e.getMessage());
            return;
        }
        catch (InvalidFASTAFileException e) {
            ClientGlobals.errMessage("Failed loading sequence file 2\nInvalid FASTA file: " + e.getMessage());
            return;
        }
        String basePath = "/resources/matrices/";
        if (!this.chkAutoMatrix.isSelected()) {
            if (this.customMatrix == null) {
                mat = this.loadSubstMatrix(String.valueOf(basePath) + this.substMatrices[this.cmbMatrices.getSelectedIndex()].getFile());
                mat.setNucleotideMatrix(this.substMatrices[this.cmbMatrices.getSelectedIndex()].isNucleotideMatrix());
                this.curSubmatName = this.substMatrices[this.cmbMatrices.getSelectedIndex()].getName();
            } else {
                mat = this.customMatrix;
                this.curSubmatName = "Custom";
            }
            if (this.customMatrix != null && (firstSecIsNucl || secondSecIsNucl)) {
                ClientGlobals.warnMessage("Custom matrices are only allowed for protein dotplots.");
                return;
            }
        } else {
            if (firstSecIsNucl != secondSecIsNucl) {
                ClientGlobals.warnMessage("The two sequences do not seem to have the same type (DNA/Protein).\nPlease choose different sequences or do not use auto-matrix mode.");
                return;
            }
            if (firstSecIsNucl) {
                mat = this.loadSubstMatrix(String.valueOf(basePath) + "edna.mat");
                this.curSubmatName = "DNA";
                mat.setNucleotideMatrix(true);
            } else {
                mat = this.loadSubstMatrix(String.valueOf(basePath) + "blosum62.mat");
                this.curSubmatName = "BLOSUM62";
                mat.setNucleotideMatrix(false);
            }
        }
        try {
            params = this.getParameterSet(false);
        }
        catch (InvalidParamSetException e) {
            return;
        }
        if (params == null) {
            this.dotplotFailed();
            return;
        }
        if (params.wordLength == 0 && params.windowSize == 0) {
            ClientGlobals.warnMessage("Whether window size or word length must have a non-zero value");
            return;
        }
        if (mat != null) {
            int compseq = 0;
            if (this.chkFirstComp.isSelected()) {
                compseq = 1;
            }
            if (this.chkSecondComp.isSelected()) {
                compseq = 2;
            }
            this.ctrl.initiateLocalDotplot(mat, this.txtLocalSeq1.getText(), this.txtLocalSeq2.getText(), params, compseq);
        }
    }

    public ParameterSet getParameterSet(boolean novalidation) throws InvalidParamSetException {
        try {
            int ratio = Integer.parseInt(this.txtZoom.getText());
            int wordlen = Integer.parseInt(this.txtWordlen.getText());
            int windowsize = Integer.parseInt(this.txtWinsize.getText());
            int seq1start = Integer.parseInt(this.txtStart1.getText());
            int seq1stop = Integer.parseInt(this.txtStop1.getText());
            int seq2start = Integer.parseInt(this.txtStart2.getText());
            int seq2stop = Integer.parseInt(this.txtStop2.getText());
            if (!(novalidation || (seq1stop > seq1start || seq1start == 0 && seq1stop == 0) && (seq2stop > seq2start || seq2start == 0 && seq2stop == 0))) {
                ClientGlobals.warnMessage("Sequence start parameter must be smaller than stop parameter");
                throw new InvalidParamSetException();
            }
            return new ParameterSet(ratio, wordlen, windowsize, seq1start, seq1stop, seq2start, seq2stop, this.curSubmatName);
        }
        catch (Exception e) {
            ClientGlobals.warnMessage("Something went wrong in the GUI, please try again what you were just intending to do.");
            e.printStackTrace();
            return null;
        }
    }

    public void setParameterSet(ParameterSet params) {
        this.txtZoom.setText(String.valueOf(params.zoom));
        this.txtWordlen.setText(String.valueOf(params.wordLength));
        this.txtWinsize.setText(String.valueOf(params.windowSize));
        this.txtStart1.setText(String.valueOf(params.seq1Start));
        this.txtStop1.setText(String.valueOf(params.seq1Stop));
        this.txtStart2.setText(String.valueOf(params.seq2Start));
        this.txtStop2.setText(String.valueOf(params.seq2Stop));
    }

    public boolean useAutoZoom() {
        return this.chkAutoZoom.isSelected();
    }

    public boolean useAutoParameters() {
        return this.chkAutoParams.isSelected();
    }

    public void showOptionsTab() {
        this.optTabs.setSelectedIndex(0);
    }

    public void showDisplayTab() {
        this.optTabs.setSelectedIndex(2);
    }

    public int getLocalClickAction() {
        if (this.optLocalShowAlign.isSelected()) {
            return 0;
        }
        if (this.optLocalExport.isSelected()) {
            return 1;
        }
        return 2;
    }

    private FileChooseResult showFileDialog(String title, boolean open, boolean imageexport) {
        int retval;
        JFileChooser f = !imageexport ? new JFileChooser(Config.getInstance().getStringVal("lastopendir", "")) : new JFileChooser(Config.getInstance().getStringVal("lastopendir_export", ""));
        if (imageexport) {
            f.removeChoosableFileFilter(f.getFileFilter());
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("jpg");
            filter.addExtension("jpeg");
            filter.setDescription("JPEG image files");
            f.addChoosableFileFilter(filter);
            filter = new ExampleFileFilter();
            filter.addExtension("png");
            filter.setDescription("PNG image files");
            f.addChoosableFileFilter(filter);
            filter = new ExampleFileFilter();
            filter.addExtension("bmp");
            filter.setDescription("Bitmap image files");
            f.addChoosableFileFilter(filter);
        }
        if ((retval = open ? f.showOpenDialog(this) : f.showSaveDialog(this)) == 0 && f.getSelectedFile() != null) {
            String selextension;
            if (!imageexport) {
                Config.getInstance().setVal("lastopendir", f.getSelectedFile().getParent());
            } else {
                Config.getInstance().setVal("lastopendir_export", f.getSelectedFile().getParent());
            }
            String filename = f.getSelectedFile().getAbsolutePath();
            if (imageexport) {
                ExampleFileFilter sel = (ExampleFileFilter)f.getFileFilter();
                selextension = sel.getFirstExtension();
                if (!open && filename.lastIndexOf(".") == -1) {
                    filename = String.valueOf(filename) + "." + selextension;
                }
            } else {
                selextension = "";
            }
            return new FileChooseResult(filename, selextension);
        }
        return new FileChooseResult(null, null);
    }

    private SubstitutionMatrix loadSubstMatrix(String file) {
        try {
            SubstitutionMatrix mat = SubstitutionMatrix.loadFromResource(file);
            return mat;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "IO error while opening matrix file:\n" + e.getMessage(), "Error", 0);
            return null;
        }
        catch (InvalidSubMatFileException e) {
            JOptionPane.showMessageDialog(null, "Could not load matrix file:\n" + e.getMessage(), "Error", 0);
            return null;
        }
    }

    private long calcCurrentSADiskSpace() {
        long totalSize = 0L;
        String[] saFiles = new File(ClientGlobals.SETTINGS_DIR).list();
        int i = 0;
        while (i < saFiles.length) {
            if (saFiles[i].substring(saFiles[i].length() - 3).equals(".sa")) {
                totalSize += new File(String.valueOf(ClientGlobals.SETTINGS_DIR) + System.getProperty("file.separator") + saFiles[i]).length();
            }
            ++i;
        }
        return totalSize;
    }

    private void deleteSAFiles() {
        String[] saFiles = new File(ClientGlobals.SETTINGS_DIR).list();
        int i = 0;
        while (i < saFiles.length) {
            if (saFiles[i].substring(saFiles[i].length() - 3).equals(".sa")) {
                new File(String.valueOf(ClientGlobals.SETTINGS_DIR) + System.getProperty("file.separator") + saFiles[i]).delete();
            }
            ++i;
        }
    }

    public void updateSADiskSpace() {
        this.lblSASpace.setText("Suffix arrays diskspace: " + ClientGlobals.convenientFileSize(this.calcCurrentSADiskSpace()));
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.optTabs.setEnabledAt(3, this.seqTabs.getSelectedIndex() == 1);
        this.setupForAlignments();
    }

    public boolean smallPlots() {
        return this.chkSmallPlots.isSelected();
    }

    public void uncheckFirstComp() {
        this.chkFirstComp.setSelected(false);
    }

    public void uncheckSecondComp() {
        this.chkSecondComp.setSelected(false);
    }

    public String getGUIDump() {
        StringBuilder guidump = new StringBuilder();
        guidump.append("==== LOCAL SEQUENCES ====\n");
        guidump.append("Sequence 1: " + this.txtLocalSeq1.getText() + "\n");
        guidump.append("Seq1comp  : " + this.chkFirstComp.isSelected() + "\n");
        guidump.append("Sequence 2: " + this.txtLocalSeq2.getText() + "\n");
        guidump.append("Seq2comp  : " + this.chkSecondComp.isSelected() + "\n");
        guidump.append("\n");
        guidump.append("==== PLOT SETTINGS ====\n");
        guidump.append("Seq1 coords : " + this.txtStart1.getText() + "-" + this.txtStop1.getText() + "\n");
        guidump.append("Seq2 coords : " + this.txtStart2.getText() + "-" + this.txtStop2.getText() + "\n");
        guidump.append("Auto zoom  : " + this.chkAutoZoom.isSelected() + "\n");
        guidump.append("Small plots: " + this.chkSmallPlots.isSelected() + "\n");
        guidump.append("Zoom       : " + this.txtZoom.getText() + "\n");
        guidump.append("Auto params : " + this.chkAutoParams.isSelected() + "\n");
        guidump.append("Word length : " + this.txtWordlen.getText() + "\n");
        guidump.append("Window size : " + this.txtWinsize.getText() + "\n");
        guidump.append("Auto matrix: " + this.chkAutoMatrix.isSelected() + "\n");
        guidump.append("Matrix     : " + this.cmbMatrices.getSelectedItem() + "\n");
        guidump.append("\n");
        guidump.append("==== MISC SETTINGS ====\n");
        guidump.append("Save SAs: " + this.chkSaveSA.isSelected() + "\n");
        String localaction = this.optLocalDoNothing.isSelected() ? "Do nothing" : "Show alignment";
        guidump.append("Local click action: " + localaction + "\n");
        guidump.append("\n");
        return guidump.toString();
    }

    public void setRevComplAlign(boolean revcomp) {
        this.chkRevCompAlign.setSelected(revcomp);
    }

    public boolean reverseComplementaryAlignments() {
        return this.chkRevCompAlign.isSelected();
    }

    public void setNucleotidePlot(boolean nuclplot) {
        if (nuclplot) {
            this.chkRevCompAlign.setEnabled(true);
        } else {
            this.chkRevCompAlign.setEnabled(false);
            this.chkRevCompAlign.setSelected(false);
        }
    }

    private class FileChooseResult {
        public String file;
        public String type;

        public FileChooseResult(String file, String type) {
            this.file = file;
            this.type = type;
        }
    }

    class IntVerifier
    extends InputVerifier {
        private String m_name;
        private int m_min;
        private int m_max;

        public IntVerifier(String name, int min, int max) {
            this.m_name = name;
            this.m_min = min;
            this.m_max = max;
        }

        @Override
        public boolean verify(JComponent input) {
            String contents = ((JTextField)input).getText();
            boolean valueok = true;
            try {
                int value = Integer.parseInt(contents);
                if (value < this.m_min || value > this.m_max) {
                    valueok = false;
                }
            }
            catch (NumberFormatException nfe) {
                valueok = false;
            }
            if (!valueok) {
                JOptionPane.showMessageDialog(input.getParent().getParent(), String.valueOf(this.m_name) + " must be a valid integer between " + INTFMT.format(this.m_min) + " and " + INTFMT.format(this.m_max), "Invalid value", 2);
            }
            return valueok;
        }
    }
}

