/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.gepard.client.Controller;
import org.gepard.client.userinterface.MainPanel;
import org.gepard.client.userinterface.WindowPos;

public class ContainerWindow
extends JFrame {
    private static final long serialVersionUID = -5944334167138374870L;
    private Controller ctrl;

    public void setup(Controller ictrl, MainPanel mp) {
        this.setSize(600, 600);
        this.ctrl = ictrl;
        this.setContentPane(mp);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Window[] children = ContainerWindow.this.getOwnedWindows();
                int i = 0;
                while (i < children.length) {
                    children[i].toFront();
                    ++i;
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ContainerWindow.this.ctrl.eventExit();
            }
        });
        this.setExtendedState(this.getExtendedState() | 6);
        this.setVisible(true);
    }

    public WindowPos getPosition() {
        int width = this.getWidth();
        int height = this.getHeight();
        Point loc = this.getLocation();
        return new WindowPos(width, height, loc.x, loc.y);
    }

    public void close() {
        this.dispose();
        this.ctrl.eventExit();
    }
}

