/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.userinterface;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.gepard.client.BrowserLauncher;
import org.gepard.client.ClientGlobals;
import org.gepard.client.userinterface.UserMessageDialog;

public class AboutDialog
extends JFrame
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 2421453233837541464L;
    private static int LEFT_MARGIN = 10;
    private static int VERT_SPACE = 10;
    private static int VERT_SPACE_AFTER_TOP = 20;
    private static int INIT_VERT_SPACE = 2;
    private static double LEFT_WEIGHT = 1.0;
    private static double RIGHT_WEIGHT = 2.0;
    private static int BELOW_CLOSE = 7;
    private static int EXTRA_AFTER_AUTHOR = 10;
    private static int EXTRA_AFTER_CONTACT = 10;
    private static int BETWEEN_CONTACT_WEB = 5;
    private static int LOGO_TOPMARG = 10;
    private static int WIN_WIDTH = 450;
    private static int WIN_HEIGHT = 315;
    JButton close;
    JButton ref;

    public AboutDialog() {
        this.setupGUI();
        this.setSize(WIN_WIDTH, WIN_HEIGHT);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/gepard.gif")));
        this.pack();
        this.setVisible(true);
    }

    private JLabel getBoldJLabel(String caption) {
        JLabel ret = new JLabel(caption);
        Font oldFont = ret.getFont();
        ret.setFont(new Font(oldFont.getName(), oldFont.getStyle() | 1, oldFont.getSize()));
        return ret;
    }

    private JLabel getHeaderJLabel(String caption) {
        JLabel ret = new JLabel(caption);
        Font oldFont = ret.getFont();
        ret.setFont(new Font(oldFont.getName(), oldFont.getStyle() | 1, oldFont.getSize() + 2));
        return ret;
    }

    private JLabel getNormalJLabel(String caption) {
        JLabel ret = new JLabel(caption);
        Font oldFont = ret.getFont();
        ret.setFont(new Font(oldFont.getName(), oldFont.getStyle() & 0xFFFFFFFE, oldFont.getSize()));
        return ret;
    }

    private JLabel getLinkJLabel(String caption) {
        JLabel ret = new JLabel("<html><u>" + caption + "</u></html>");
        Font oldFont = ret.getFont();
        ret.setFont(new Font(oldFont.getName(), oldFont.getStyle() & 0xFFFFFFFE, oldFont.getSize()));
        ret.setForeground(Color.BLUE);
        ret.setCursor(Cursor.getPredefinedCursor(12));
        ret.addMouseListener(this);
        return ret;
    }

    private void setupGUI() {
        this.setTitle("About " + ClientGlobals.APPNAME);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, LEFT_MARGIN, 0, 0);
        c.anchor = 18;
        c.weighty = 1.0;
        c.weightx = LEFT_WEIGHT;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(INIT_VERT_SPACE, LEFT_MARGIN, 0, 0);
        this.add((Component)this.getHeaderJLabel(ClientGlobals.APPNAME), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.anchor = 18;
        c.insets = new Insets(LOGO_TOPMARG, 0, 0, 0);
        this.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/resources/images/logo.gif"))), c);
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, VERT_SPACE_AFTER_TOP, 0);
        this.add((Component)this.getNormalJLabel("1.40 final"), c);
        c.anchor = 18;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, LEFT_MARGIN, EXTRA_AFTER_AUTHOR, 0);
        ++c.gridy;
        this.add((Component)this.getBoldJLabel("Developed by:"), c);
        c.insets = new Insets(0, LEFT_MARGIN, 0, 0);
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, EXTRA_AFTER_CONTACT, 0);
        this.add((Component)this.getBoldJLabel("Web:"), c);
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, VERT_SPACE, 0);
        this.add((Component)this.getBoldJLabel("Thanks to:"), c);
        c.gridy += 3;
        this.add((Component)this.getBoldJLabel("Logo:"), c);
        ++c.gridy;
        this.add((Component)this.getBoldJLabel("Institution:"), c);
        c.weightx = RIGHT_WEIGHT;
        c.gridx = 1;
        c.gridy = 2;
        this.add((Component)this.getBoldJLabel("Jan Krumsiek, Thomas Rattei"), c);
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, BETWEEN_CONTACT_WEB, 0);
        this.add((Component)this.getLinkJLabel("http://cube.univie.ac.at/gepard"), c);
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, 0, 0);
        this.add((Component)this.getNormalJLabel("Roland Arnold, Patrick Tischler, "), c);
        ++c.gridy;
        c.insets = new Insets(0, LEFT_MARGIN, VERT_SPACE, 0);
        this.add((Component)this.getNormalJLabel("Dominik Lindner, Volker Stuempflen, Tini"), c);
        ++c.gridy;
        ++c.gridy;
        this.add((Component)this.getNormalJLabel("Tobias Petri"), c);
        ++c.gridy;
        this.add((Component)this.getNormalJLabel("Division of Computational Systems Biology"), c);
        ++c.gridy;
        this.add((Component)this.getNormalJLabel("University of Vienna"), c);
        ++c.gridy;
        ++c.gridy;
        c.anchor = 13;
        c.insets = new Insets(0, 0, BELOW_CLOSE, LEFT_MARGIN);
        this.close = new JButton("Close");
        this.add((Component)this.close, c);
        this.close.addActionListener(this);
        --c.gridx;
        c.insets = new Insets(0, LEFT_MARGIN, 0, 0);
        c.anchor = 17;
        this.ref = new JButton("Reference");
        this.add((Component)this.ref, c);
        this.ref.addActionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        JLabel input = (JLabel)arg0.getSource();
        try {
            if (input.getText().indexOf(64) > -1) {
                BrowserLauncher.openURL("mailto:contact.cube@univie.ac.at");
            } else {
                BrowserLauncher.openURL("http://cube.univie.ac.at/gepard");
            }
        }
        catch (Exception e) {
            ClientGlobals.errMessage("Could not open browser.\n\nError:\n" + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.close) {
            this.dispose();
            System.exit(0);
        } else if (arg0.getSource() == this.ref) {
            UserMessageDialog.showUserMessageIfExisting("/resources/help/reference.txt");
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    public static void main(String[] args) {
        new AboutDialog();
    }
}

