/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.cmdline;

import java.util.Arrays;
import java.util.HashMap;
import org.gepard.client.cmdline.InvalidArgumentsException;

public class CommandLineArguments {
    private HashMap<String, String> values = new HashMap();

    public CommandLineArguments(String allowed, String[] args) throws InvalidArgumentsException {
        this(allowed.split(","), args);
    }

    public CommandLineArguments(String[] allowed, String[] args) throws InvalidArgumentsException {
        Arrays.sort(allowed);
        int i = 0;
        while (i < args.length) {
            String argument = args[i];
            if (argument.charAt(0) != '-') {
                throw new InvalidArgumentsException("Invalid argument: '" + argument + "'... argument names must start with -");
            }
            String key = argument.substring(1).trim();
            String value = "";
            if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                value = args[i + 1];
                ++i;
            }
            if (Arrays.binarySearch(allowed, key) < 0) {
                throw new InvalidArgumentsException("Unknown argument: '" + key + "'");
            }
            this.values.put(key, value);
            ++i;
        }
    }

    public boolean isSet(String switchName) {
        return this.values.get(switchName) != null;
    }

    public String getValue(String key) {
        return this.values.get(key);
    }
}

