/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client.cmdline;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.gepard.client.ClientGlobals;
import org.gepard.client.DrawTarget;
import org.gepard.client.Plotter;
import org.gepard.client.cmdline.CommandLineArguments;
import org.gepard.client.cmdline.InvalidArgumentsException;
import org.gepard.common.AbortionChecker;
import org.gepard.common.DotMatrix;
import org.gepard.common.DotMatrixCallback;
import org.gepard.common.FASTAReader;
import org.gepard.common.InvalidFASTAFileException;
import org.gepard.common.InvalidSubMatFileException;
import org.gepard.common.ParameterSet;
import org.gepard.common.Sequence;
import org.gepard.common.SubstitutionMatrix;
import org.gepard.common.SuffixArray;

public class CommandLine {
    private static final String[] ALLOWED_ARGS = new String[]{"seq1", "seq2", "maxwidth", "maxheight", "matrix", "silent", "word", "window", "from1", "to1", "from2", "to2", "lower", "upper", "greyscale", "outfile", "format", "safile", "sasecondseq", "secondcomp", "zoom"};
    private static final int DEF_WIDTH = 750;
    private static final int DEF_HEIGHT = 750;
    private static final int DEF_WORD = 10;
    private static final int DEF_WINDOW = 0;
    private static final String DEF_OUTFORMAT = "PNG";
    private static final String[] VALID_OUTFORMATS = new String[]{"png", "jpg", "bmp"};
    private static final int XMARGIN = 100;
    private static final int YMARGIN = 125;
    private static int width;
    private static int height;

    public static void main(String[] args) {
        CommandLineArguments arguments = null;
        try {
            arguments = new CommandLineArguments(ALLOWED_ARGS, args);
        }
        catch (InvalidArgumentsException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        if (!(arguments.isSet("seq1") && arguments.isSet("seq2") && arguments.isSet("matrix") && arguments.isSet("outfile"))) {
            CommandLine.printUsage();
            System.exit(1);
        }
        boolean silent = arguments.isSet("silent");
        String format = null;
        if (arguments.isSet("format")) {
            format = arguments.getValue("format").toLowerCase();
            if (!CommandLine.contains(VALID_OUTFORMATS, format)) {
                System.err.println("Error: Invalid output format: " + format);
                System.exit(1);
            }
        } else {
            format = DEF_OUTFORMAT;
        }
        if ((arguments.isSet("maxwidth") || arguments.isSet("maxheight")) && arguments.isSet("zoom")) {
            System.out.println("Error: Parameters maxwidth/maxheight and zoom cannot be used simultanously.");
            System.out.println("maxwidth/maxheight automatically implies a zoom factor whereas a zoom factor implies the plot size");
            System.exit(1);
        }
        if (!silent) {
            System.out.println("Loading substitution matrix...");
        }
        SubstitutionMatrix submat = null;
        try {
            submat = SubstitutionMatrix.loadFromFile(arguments.getValue("matrix"));
            submat.guessIfSubstitutionMatrix();
        }
        catch (IOException e) {
            System.err.println("Error: Could not load substitution matrix file:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (InvalidSubMatFileException e) {
            System.err.println("Error: Invalid substitution matrix file:");
            System.err.println(arguments.getValue("matrix"));
            System.exit(1);
        }
        if (!silent) {
            System.out.println("Loading sequence from " + arguments.getValue("seq1"));
        }
        Sequence seq1 = null;
        try {
            seq1 = FASTAReader.readFile(arguments.getValue("seq1"), submat);
        }
        catch (IOException e) {
            System.err.println("Error: Could not load first sequence file:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (InvalidFASTAFileException e) {
            System.err.println("Error: File could not be recognized as FASTA format file:");
            System.err.println(arguments.getValue("seq1"));
            System.err.println("Problem: " + e.getMessage());
            System.exit(1);
        }
        if (!silent) {
            System.out.println("Loading sequence from " + arguments.getValue("seq2"));
        }
        Sequence seq2 = null;
        try {
            seq2 = FASTAReader.readFile(arguments.getValue("seq2"), submat);
        }
        catch (IOException e) {
            System.err.println("Error: Could not load second sequence file:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (InvalidFASTAFileException e) {
            System.err.println("Error: File could not be recognized as FASTA format file:");
            System.err.println(arguments.getValue("seq2"));
            System.err.println("Problem: " + e.getMessage());
            System.exit(1);
        }
        if (arguments.isSet("secondcomp")) {
            Sequence.complementarizeSequence(seq2);
        }
        int word = -1;
        int window = -1;
        try {
            word = arguments.isSet("word") ? Integer.parseInt(arguments.getValue("word")) : (arguments.isSet("window") ? 0 : 10);
            window = arguments.isSet("window") ? Integer.parseInt(arguments.getValue("window")) : 0;
        }
        catch (NumberFormatException e) {
            System.err.println("Error: Invalid integer number:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        float lower = -1.0f;
        lower = arguments.isSet("lower") ? Float.parseFloat(arguments.getValue("lower")) / 100.0f : (word > 0 ? 0.0f : Float.NaN);
        float upper = -1.0f;
        upper = arguments.isSet("upper") ? Float.parseFloat(arguments.getValue("upper")) / 100.0f : (word > 0 ? 0.2f : 1.0f);
        float greyscale = -1.0f;
        greyscale = arguments.isSet("greyscale") ? Float.parseFloat(arguments.getValue("greyscale")) / 100.0f : (word > 0 ? 0.0f : 0.5f);
        ParameterSet params = new ParameterSet(-1, word, window, -1, -1, -1, -1, ClientGlobals.extractFilename(arguments.getValue("matrix").toLowerCase()));
        try {
            CommandLine.setCoordinates(params, seq1, seq2, arguments);
            if (arguments.isSet("zoom")) {
                int zoom = Integer.parseInt(arguments.getValue("zoom"));
                width = 100 + (int)Math.ceil((float)seq1.getLength() / (float)zoom);
                height = 125 + (int)Math.ceil((float)seq2.getLength() / (float)zoom);
                params.zoom = zoom;
            } else {
                width = arguments.isSet("maxwidth") ? Integer.parseInt(arguments.getValue("maxwidth")) : 750;
                height = arguments.isSet("maxheight") ? Integer.parseInt(arguments.getValue("maxheight")) : 750;
                params.zoom = CommandLine.calcZoom(width, height, params.seq1Start, params.seq1Stop, params.seq2Start, params.seq2Stop);
            }
            if (width - 100 <= 1 || height - 125 <= 1) {
                System.err.println("Error: This plot would become too small.");
                System.err.println("Please use bigger plot size or smaller zoom factor.");
                System.exit(1);
            }
            if (params.seq1Start >= params.seq1Stop || params.seq2Start >= params.seq2Stop) {
                System.err.println("Error: To coordinates may not be greater than from coordinates!");
                System.exit(1);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Error: Invalid integer number:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
        boolean saSecondSeq = false;
        SuffixArray sa = null;
        if (!arguments.isSet("safile")) {
            if (!silent) {
                System.out.println("Calculating suffix array... ");
            }
            if (seq1.getLength() >= seq2.getLength()) {
                sa = new SuffixArray(seq1, submat.getAlphabetSize(), null);
            } else {
                sa = new SuffixArray(seq2, submat.getAlphabetSize(), null);
                saSecondSeq = true;
            }
        } else {
            String safile = arguments.getValue("safile");
            saSecondSeq = arguments.isSet("sasecondseq");
            if (!silent) {
                System.out.println("Reading suffix array from " + arguments.getValue("safile"));
            }
            try {
                Sequence saSeq;
                sa = !saSecondSeq ? SuffixArray.loadFromFile(new File(safile), seq1.getSequenceData()) : SuffixArray.loadFromFile(new File(safile), seq2.getSequenceData());
                Sequence sequence = saSeq = saSecondSeq ? seq2 : seq1;
                if (sa.getLength() != saSeq.getLength()) {
                    System.err.println("Error: Suffix array does not appear to belong to that sequence.");
                    System.exit(1);
                }
            }
            catch (IOException e) {
                System.err.println("Error: Could not load suffix array from file:");
                if (e.getMessage().toLowerCase().contains("gzip")) {
                    System.err.println("Invalid suffix array file.");
                } else {
                    System.err.println(e.getMessage());
                }
                System.exit(1);
            }
            catch (OutOfMemoryError e) {
                System.err.println("Error: Invalid suffix array file.");
                System.exit(1);
            }
        }
        if (!silent) {
            System.out.println("Calculating dotplot... ");
        }
        Callback catcher = new Callback();
        DotMatrix dm = new DotMatrix(seq1.getSequenceData(), seq2.getSequenceData(), seq1.getName(), seq2.getName(), sa, params, submat, catcher, catcher, saSecondSeq);
        if (!silent) {
            System.out.println("Creating image and writing to file... ");
        }
        Plotter plotter = new Plotter(dm, catcher);
        float minScore = dm.getMinDotScore();
        float maxScore = dm.getMaxDotScore();
        if (Float.isNaN(lower)) {
            float gooddisp = (dm.getAvgDotScore() + maxScore) * 0.4f;
            lower = (gooddisp - minScore) / (maxScore - minScore);
        }
        plotter.reCalc((maxScore - minScore) * lower + minScore, (maxScore - minScore) * upper + minScore, greyscale);
        try {
            File outfile = new File(arguments.getValue("outfile"));
            ImageIO.write((RenderedImage)plotter.getFullImage(), format, outfile);
        }
        catch (Exception e) {
            System.err.println("Error: Could not write image file:");
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private static void setCoordinates(ParameterSet params, Sequence seq1, Sequence seq2, CommandLineArguments arguments) {
        params.seq1Start = arguments.isSet("from1") ? CommandLine.getCoordinate(arguments.getValue("from1"), seq1) : 0;
        params.seq1Stop = arguments.isSet("to1") ? CommandLine.getCoordinate(arguments.getValue("to1"), seq1) : seq1.getLength() - 1;
        params.seq2Start = arguments.isSet("from2") ? CommandLine.getCoordinate(arguments.getValue("from2"), seq2) : 0;
        params.seq2Stop = arguments.isSet("to2") ? CommandLine.getCoordinate(arguments.getValue("to2"), seq2) : seq2.getLength() - 1;
        if (params.seq1Start < 0) {
            params.seq1Start = 0;
        }
        if (params.seq1Stop >= seq1.getLength()) {
            params.seq1Stop = seq1.getLength() - 1;
        }
        if (params.seq2Start < 0) {
            params.seq2Start = 0;
        }
        if (params.seq2Stop >= seq2.getLength()) {
            params.seq2Stop = seq2.getLength() - 1;
        }
    }

    private static final int getCoordinate(String argument, Sequence seq) {
        if (!argument.contains("%")) {
            return Integer.parseInt(argument);
        }
        float fraction = Float.parseFloat(argument.substring(0, argument.indexOf("%"))) / 100.0f;
        return (int)((float)seq.getLength() * fraction);
    }

    private static int calcZoom(int imgwidth, int imgheight, int x1, int x2, int y1, int y2) {
        int drawWidth = imgwidth - 100;
        int drawHeight = imgheight - 125;
        int xzoom = (int)Math.ceil((float)(x2 - x1) / (float)drawWidth);
        int yzoom = (int)Math.ceil((float)(y2 - y1) / (float)drawHeight);
        if (xzoom == 0 && yzoom == 0) {
            xzoom = 1;
        }
        return xzoom > yzoom ? xzoom : yzoom;
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Gepard 1.40 final - command line mode");
        System.err.println();
        System.err.println("Reference:");
        System.err.println("Krumsiek J, Arnold R, Rattei T");
        System.err.println("Gepard: A rapid and sensitive tool for creating dotplots on genome scale.");
        System.err.println("Bioinformatics 2007; 23(8): 1026-8. PMID: 17309896");
        System.err.println();
        System.err.println("Parameters are supplied as -name value");
        System.err.println();
        System.err.println("Required parameters:");
        System.err.println("  -seq1:        first sequence file");
        System.err.println("  -seq2:        second sequence file");
        System.err.println("  -matrix:      substitution matrix file");
        System.err.println("  -outfile:     output file name");
        System.err.println();
        System.err.println("Dotplot image parameters:");
        System.err.println("  -maxwidth:    maximum width of the generated image (default: 750)");
        System.err.println("  -maxheight:   maximum height of the generated image (default: 750)");
        System.err.println("  -zoom:        specify a zoom factor for the dotplot");
        System.err.println("  note: you can only use maxwidth/maxheight OR zoom");
        System.err.println("        when using maxwidth/maxheight the program tries to generate the largest");
        System.err.println("        possible dotplot within the given bounds");
        System.err.println("  -format:      output format, one of:  'png', 'jpg', 'bmp' (default:PNG)");
        System.err.println();
        System.err.println("Dotplot computation parameters:");
        System.err.println("  -secondcomp   use complementary of second sequence");
        System.err.println("  -word:        word length for suffix array mode (default: 10)");
        System.err.println("  -window:      window size for ordinary dotplot mode (default: 0)");
        System.err.println("  if a window value and no word value is specified, word=0 is assumed");
        System.err.println();
        System.err.println("Suffix array parameters:");
        System.err.println("  -safile       load suffix array from file instead of calculating it");
        System.err.println("  -sasecondseq  the suffix array is for the second sequence");
        System.err.println("  if -sasecondseq is NOT specified, the suffix array will be used for first sequence");
        System.err.println();
        System.err.println("Coordinate parameters (absolute values of % values)");
        System.err.println("  -from1,-to1   coordinates of first sequence");
        System.err.println("  -from2,-to2   coordinates of second sequence");
        System.err.println("  if these parameters are not specified the full sequence will be used");
        System.err.println();
        System.err.println("Display parameters:");
        System.err.println("  -lower        lower limit for dot intensity (in %)");
        System.err.println("  -upper        upper limit for dot intensity (in %)");
        System.err.println("  -greyscale    greyscale start value (in %)");
        System.err.println();
        System.err.println("Miscellaneous:");
        System.err.println("  -silent       generate no output (except error messages)");
        System.err.println();
    }

    private static boolean contains(Object[] array, Object item) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class Callback
    implements DotMatrixCallback,
    AbortionChecker,
    DrawTarget {
        private Callback() {
        }

        @Override
        public void dotmatrixCalcStatus(float percent) {
        }

        @Override
        public void tellAborted() {
        }

        @Override
        public int tellCallbackStep(int wordlen, int windowsize) {
            return 1000;
        }

        @Override
        public boolean dotplotAborted() {
            return false;
        }

        @Override
        public int getHeight() {
            return height;
        }

        @Override
        public int getWidth() {
            return width;
        }

        @Override
        public void setPreferredSize(Dimension dimension) {
        }
    }
}

