/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.gepard.client.ClientGlobals;
import org.gepard.client.DrawTarget;
import org.gepard.common.DotMatrix;

public class Plotter {
    DotMatrix dm;
    int selX1 = -1;
    int selY1 = -1;
    int selX2 = -1;
    int selY2 = -1;
    public static final int XOFF = 85;
    public static final int YOFF = 110;
    private static final int GC_RATIO_OFF = 160;
    private static final Font INFO_FONT = new Font("Monospaced", 0, 12);
    private static final Font GENE_FONT = new Font("Monospaced", 0, 11);
    private static final int NAME_MIN_HOR_MARGIN = 10;
    private static final int NAME_VERT_MARGIN = 30;
    private int crossX = -1;
    private int crossY = -1;
    private int crossPosX;
    private int crossPosY;
    private int genex = -1;
    private int geney = -1;
    private int minPlotWidth = 0;
    private BufferedImage offscreen;
    private String infoPlotTitle;
    private String infoZoom;
    private String infoWordLen;
    private String infoWindowSize;
    private String infoSubmat;
    private String infoProgram;
    private String infoGCRatio1;
    private String infoGCRatio2;
    private String seq1Name;
    private String seq2Name;
    private int imgWidth;
    private int imgHeight;
    private DrawTarget dp;
    private String genehor;
    private String genevert;

    public Plotter(DotMatrix dm, DrawTarget dp) {
        this.dm = dm;
        this.dp = dp;
        this.offscreen = new BufferedImage(dm.getWidth(), dm.getHeight(), 1);
        this.infoZoom = "Zoom: " + dm.getParameterSet().zoom + " : 1";
        this.infoWordLen = "Word length: " + dm.getParameterSet().wordLength;
        this.infoWindowSize = "Window size: " + dm.getParameterSet().windowSize;
        this.infoSubmat = "Matrix: " + dm.getParameterSet().submatName;
        this.infoProgram = "Program: " + ClientGlobals.APPNAME + " (" + "1.40 final" + ")";
        DecimalFormat fmt = new DecimalFormat("#####0.0000", new DecimalFormatSymbols(Locale.ENGLISH));
        this.infoGCRatio1 = "GC ratio seq1: " + fmt.format(dm.getGCratio1());
        this.infoGCRatio2 = "GC ratio seq2: " + fmt.format(dm.getGCratio2());
        FontMetrics fontMetrics = this.offscreen.getGraphics().getFontMetrics(INFO_FONT);
        int infoGCRatioWidth = 245 + fontMetrics.stringWidth(this.infoGCRatio1);
        int infoProgramWidth = 245 + fontMetrics.stringWidth(this.infoProgram);
        int hormargin = Math.max(Math.max(10, fontMetrics.stringWidth(String.valueOf(dm.getParameterSet().seq1Start)) * 2), fontMetrics.stringWidth(String.valueOf(dm.getParameterSet().seq1Stop)) * 2);
        this.seq1Name = ClientGlobals.cutString(dm.getSeq1Name(), (dm.getWidth() - hormargin) / fontMetrics.charWidth(' '));
        this.seq2Name = ClientGlobals.cutString(dm.getSeq2Name(), (dm.getHeight() - 30) / fontMetrics.charWidth(' '));
        this.minPlotWidth = Math.max(infoGCRatioWidth, infoProgramWidth);
        this.imgWidth = this.minPlotWidth > 85 + dm.getWidth() ? this.minPlotWidth + 5 : 85 + dm.getWidth() + 5;
        this.imgHeight = 110 + dm.getHeight() + 5;
        String name1 = dm.getSeq1Name();
        String name2 = dm.getSeq2Name();
        this.infoPlotTitle = "";
        int charsfortitle = (this.imgWidth - 85) / fontMetrics.charWidth(' ') - 5;
        int halfchars = charsfortitle / 2;
        int maxnamelen = Math.max(name1.length(), name2.length());
        int minnamelen = Math.min(name1.length(), name2.length());
        this.infoPlotTitle = maxnamelen <= halfchars ? String.valueOf(name1) + " vs. " + name2 : (minnamelen > halfchars ? String.valueOf(ClientGlobals.cutString(name1, halfchars)) + " vs. " + ClientGlobals.cutString(name2, halfchars) : (name1.length() < name2.length() ? String.valueOf(name1) + " vs. " + ClientGlobals.cutString(name2, charsfortitle - name1.length()) : String.valueOf(ClientGlobals.cutString(name1, charsfortitle - name2.length())) + " vs. " + name2));
        dp.setPreferredSize(new Dimension(this.imgWidth, this.imgHeight));
    }

    public void reCalc(float colorlower, float colorupper, float greyscalestart) {
        float[][] matrix = this.dm.getDotMatrix();
        int colorDot = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int i = 0;
        while (i < this.dm.getWidth()) {
            int j = 0;
            while (j < this.dm.getHeight()) {
                if (matrix[i][j] >= colorlower) {
                    float dotscore = matrix[i][j];
                    if (dotscore > colorupper) {
                        dotscore = colorupper;
                    }
                    float ratio = greyscalestart + (dotscore - colorlower) / (colorupper - colorlower) * (1.0f - greyscalestart);
                    colorDot = (int)((1.0f - ratio) * 255.0f);
                } else {
                    colorDot = 255;
                }
                r = colorDot;
                g = colorDot;
                b = colorDot;
                this.offscreen.setRGB(i, j, r * 65536 + g * 256 + b);
                ++j;
            }
            ++i;
        }
    }

    public void setSelection(int x1, int y1, int x2, int y2) {
        if (x1 < 85) {
            x1 = 85;
        }
        if (x2 < 85) {
            x2 = 85;
        }
        if (y1 < 110) {
            y1 = 110;
        }
        if (y2 < 110) {
            y2 = 110;
        }
        if (x1 >= 85 + this.dm.getWidth()) {
            x1 = 85 + this.dm.getWidth() - 1;
        }
        if (x2 >= 85 + this.dm.getWidth()) {
            x2 = 85 + this.dm.getWidth() - 1;
        }
        if (y1 >= 110 + this.dm.getHeight()) {
            y1 = 110 + this.dm.getHeight() - 1;
        }
        if (y2 >= 110 + this.dm.getHeight()) {
            y2 = 110 + this.dm.getHeight() - 1;
        }
        this.selX1 = x1;
        this.selY1 = y1;
        this.selX2 = x2;
        this.selY2 = y2;
    }

    public void setCrossHair(int x, int y, int posx, int posy) {
        if (x < 85) {
            x = 85;
        }
        if (y < 110) {
            y = 110;
        }
        if (x >= 85 + this.dm.getWidth()) {
            x = 85 + this.dm.getWidth() - 1;
        }
        if (y >= 110 + this.dm.getHeight()) {
            y = 110 + this.dm.getHeight() - 1;
        }
        this.crossX = x;
        this.crossY = y;
        this.crossPosX = posx;
        this.crossPosY = posy;
    }

    public void moveCrossHair(int xmove, int ymove) {
        this.crossPosX += xmove;
        this.crossPosY += ymove;
    }

    public void removeCrossHair() {
        this.crossX = -1;
        this.crossY = -1;
    }

    public void removeSelection() {
        this.selX1 = -1;
        this.selY1 = -1;
    }

    public void redraw(Graphics2D g) {
        int whitenWidth = Math.max(this.imgWidth, this.dp.getWidth());
        int whitenHeight = Math.max(this.imgHeight, this.dp.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, whitenWidth, whitenHeight);
        g.setColor(Color.BLACK);
        g.drawRect(84, 109, this.dm.getWidth() + 1, this.dm.getHeight() + 1);
        g.setFont(INFO_FONT);
        FontMetrics fontMetrics = g.getFontMetrics(g.getFont());
        g.drawString(this.seq1Name, 85 + this.dm.getWidth() / 2 - fontMetrics.stringWidth(this.seq1Name) / 2, 103);
        Font oldFont = g.getFont();
        Font rotated = this.getRotatedFont(oldFont);
        g.setFont(rotated);
        g.drawString(this.seq2Name, 78, 110 + this.dm.getHeight() / 2 + fontMetrics.stringWidth(this.seq2Name) / 2);
        g.setFont(oldFont);
        g.drawString(this.infoPlotTitle, 85, 13);
        g.drawString(this.infoZoom, 85, 28);
        g.drawString(this.infoWordLen, 85, 43);
        g.drawString(this.infoWindowSize, 85, 58);
        g.drawString(this.infoSubmat, 85, 73);
        if (this.dm.isNucleotideMatrix()) {
            g.drawString(this.infoGCRatio1, 245, 43);
            g.drawString(this.infoGCRatio2, 245, 58);
        }
        g.drawString(this.infoProgram, 245, 73);
        g.drawLine(85, 100, 85, 110);
        g.drawString(String.valueOf(this.dm.getParameterSet().seq1Start), 82, 93);
        g.drawLine(85 + this.dm.getWidth() - 1, 100, 85 + this.dm.getWidth() - 1, 110);
        g.drawString(String.valueOf(this.dm.getParameterSet().seq1Stop), 85 + this.dm.getWidth() - fontMetrics.stringWidth(String.valueOf(this.dm.getParameterSet().seq1Stop)) + 3, 93);
        g.drawLine(75, 110, 85, 110);
        g.drawString(String.valueOf(this.dm.getParameterSet().seq2Start), 68 - fontMetrics.stringWidth(String.valueOf(this.dm.getParameterSet().seq2Start)), 114);
        g.drawLine(75, 110 + this.dm.getHeight() - 1, 85, 110 + this.dm.getHeight() - 1);
        g.drawString(String.valueOf(this.dm.getParameterSet().seq2Stop), 68 - fontMetrics.stringWidth(String.valueOf(this.dm.getParameterSet().seq2Stop)), 110 + this.dm.getHeight() + 2);
        g.drawImage((Image)this.offscreen, 85, 110, null);
        if (this.selX1 != -1) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.selX1 < this.selX2) {
                x = this.selX1;
                width = this.selX2 - this.selX1;
            } else {
                x = this.selX2;
                width = this.selX1 - this.selX2;
            }
            if (this.selY1 < this.selY2) {
                y = this.selY1;
                height = this.selY2 - this.selY1;
            } else {
                y = this.selY2;
                height = this.selY1 - this.selY2;
            }
            g.setColor(Color.BLUE);
            g.drawRect(x, y, width, height);
        }
        if (this.crossX > -1) {
            g.setColor(Color.BLUE);
            g.drawLine(this.crossX, 110, this.crossX, this.crossY - 1);
            g.drawLine(this.crossX, this.crossY + 1, this.crossX, this.dm.getHeight() + 110);
            g.drawLine(85, this.crossY, this.crossX - 1, this.crossY);
            g.drawLine(this.crossX + 1, this.crossY, this.dm.getWidth() + 85, this.crossY);
            g.drawString(String.valueOf(this.crossPosX) + ", " + this.crossPosY, this.crossX + 5, this.crossY - 5);
        }
        if (this.genex > -1) {
            int textvertwidth;
            FontMetrics genemetrics = this.offscreen.getGraphics().getFontMetrics(GENE_FONT);
            int texthorwidth = genemetrics.stringWidth(this.genehor);
            int textwidth = texthorwidth > (textvertwidth = genemetrics.stringWidth(this.genevert)) ? texthorwidth : textvertwidth;
            int textheight = genemetrics.getHeight();
            int yshift = genemetrics.getAscent();
            int GENE_YOFF = 20;
            boolean GENE_XOFF = false;
            g.setFont(GENE_FONT);
            g.setColor(Color.BLACK);
            g.drawRect(this.genex + 0, this.geney + 20, textwidth + 2, textheight * 2 + 2);
            g.setColor(Color.WHITE);
            g.fillRect(this.genex + 0 + 1, this.geney + 20 + 1, textwidth + 2 - 1, textheight * 2 + 2 - 1);
            g.setColor(Color.BLACK);
            g.drawString(this.genehor, this.genex + 0 + 1, this.geney + 20 + yshift + 1);
            g.drawString(this.genevert, this.genex + 0 + 1, this.geney + 20 + textheight + yshift + 1);
        }
    }

    private Font getRotatedFont(Font original) {
        AffineTransform fontAT = new AffineTransform();
        fontAT.rotate(4.71238898038469);
        return original.deriveFont(fontAT);
    }

    public BufferedImage getFullImage() {
        BufferedImage fullImage = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        Graphics2D g = (Graphics2D)fullImage.getGraphics();
        this.redraw(g);
        return fullImage;
    }

    public void setGeneToolTip(int x, int y, String genehor, String genevert) {
        this.genex = x;
        this.geney = y;
        this.genehor = "Hor : " + genehor;
        this.genevert = "Vert: " + genevert;
    }

    public String getGeneNameInformation() {
        return String.valueOf(this.genehor) + "\n" + this.genevert;
    }

    public void noToolTips() {
        this.genex = -1;
    }
}

