/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.gepard.client.AutoParameters;
import org.gepard.client.ClientGlobals;
import org.gepard.client.Config;
import org.gepard.client.DotplotInfo;
import org.gepard.client.GeneNames;
import org.gepard.client.InvalidParamSetException;
import org.gepard.client.Plotter;
import org.gepard.client.userinterface.AboutDialog;
import org.gepard.client.userinterface.ContainerWindow;
import org.gepard.client.userinterface.ControlPanel;
import org.gepard.client.userinterface.DrawPanel;
import org.gepard.client.userinterface.InfoPanel;
import org.gepard.client.userinterface.MainPanel;
import org.gepard.client.userinterface.StatusDialog;
import org.gepard.client.userinterface.UserMessageDialog;
import org.gepard.client.userinterface.WindowPos;
import org.gepard.common.AbortionChecker;
import org.gepard.common.DotMatrix;
import org.gepard.common.FASTAReader;
import org.gepard.common.FASTAWriter;
import org.gepard.common.InvalidFASTAFileException;
import org.gepard.common.ParameterSet;
import org.gepard.common.Sequence;
import org.gepard.common.SubstitutionMatrix;
import org.gepard.common.SuffixArray;
import org.gepard.common.VmatchConverter;

public class Controller
implements AbortionChecker {
    private ContainerWindow container;
    private MainPanel mp;
    private DrawPanel dp;
    private ControlPanel cp;
    private InfoPanel ip;
    private StatusDialog stat;
    private DotplotInfo dpInfo;
    private Plotter p;
    private GeneNames genenames;
    private int crossX = -1;
    private int crossY = -1;
    private int crossPosX;
    private int crossPosY;
    private int selStartX = -1;
    private int selStartY = -1;
    private boolean isDragging = false;
    private boolean ctrlpressed;
    private int mousex;
    private int mousey;
    private boolean sticking = false;
    private boolean reversestick = false;
    private boolean dotplotExists = false;
    private boolean dotplotAborted = false;
    private byte[] curAlignData1 = null;
    private byte[] curAlignData2 = null;
    private int dataOffset1;
    private int dataOffset2;

    public Controller() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            try {
                Runtime.getRuntime().exec("mkvtree");
                ClientGlobals.useVmatch = true;
                ClientGlobals.vmatchCommand = "mkvtree";
            }
            catch (Exception e) {
                try {
                    Runtime.getRuntime().exec("mkvtree.exe");
                    ClientGlobals.useVmatch = true;
                    ClientGlobals.vmatchCommand = "mkvtree.exe";
                }
                catch (Exception e2) {
                    ClientGlobals.useVmatch = false;
                }
            }
            new File(ClientGlobals.SETTINGS_DIR).mkdirs();
            try {
                Config.setConfigFile(String.valueOf(ClientGlobals.SETTINGS_DIR) + System.getProperty("file.separator") + "config.xml");
            }
            catch (Exception e) {
                // empty catch block
            }
            this.updateProxySettings(true);
            this.container = new ContainerWindow();
            this.dp = new DrawPanel(this);
            this.ip = new InfoPanel(this);
            this.cp = new ControlPanel(this);
            this.mp = new MainPanel(this.cp, this.dp, this.ip);
            this.container.setIconImage(Toolkit.getDefaultToolkit().getImage(this.container.getClass().getResource("/resources/images/gepard.gif")));
            this.container.setup(this, this.mp);
            this.container.setTitle(ClientGlobals.APPNAME);
            if (Config.getInstance().getIntVal("userhelloshown", 0) == 0) {
                UserMessageDialog.showUserMessageIfExisting("/resources/help/usermsg.txt");
                Config.getInstance().setIntVal("userhelloshown", 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientGlobals.unexpectedError(e, this);
        }
    }

    public void zoomFullPlot() {
        this.dpInfo.params.seq1Start = 0;
        this.dpInfo.params.seq1Stop = this.dpInfo.seq1len - 1;
        this.dpInfo.params.seq2Start = 0;
        this.dpInfo.params.seq2Stop = this.dpInfo.seq2len - 1;
        this.initiateLocalDotplot(this.dpInfo.submat, this.dpInfo.seqFile1, this.dpInfo.seqFile2, this.dpInfo.params, this.dpInfo.compseq);
    }

    public void zoom(float factor) {
        int newStop2;
        int newStop1;
        try {
            this.dpInfo.params = this.cp.getParameterSet(false);
        }
        catch (InvalidParamSetException invalidParamSetException) {
            // empty catch block
        }
        int oldRange1 = this.dpInfo.params.seq1Stop - this.dpInfo.params.seq1Start;
        int newRange1 = (int)((float)(this.dpInfo.params.seq1Stop - this.dpInfo.params.seq1Start + 1) * factor);
        int newStart1 = this.dpInfo.params.seq1Start - (newRange1 - oldRange1) / 2;
        int add = 0;
        if (newStart1 < 0) {
            add = -newStart1;
            newStart1 = 0;
        }
        if ((newStop1 = this.dpInfo.params.seq1Stop + (newRange1 - oldRange1) / 2 + add) >= this.dpInfo.seq1len) {
            newStop1 = this.dpInfo.seq1len - 1;
        }
        int oldRange2 = this.dpInfo.params.seq2Stop - this.dpInfo.params.seq2Start;
        int newRange2 = (int)((float)(this.dpInfo.params.seq2Stop - this.dpInfo.params.seq2Start + 1) * factor);
        int newStart2 = this.dpInfo.params.seq2Start - (newRange2 - oldRange2) / 2;
        add = 0;
        if (newStart2 < 0) {
            add = -newStart2;
            newStart2 = 0;
        }
        if ((newStop2 = this.dpInfo.params.seq2Stop + (newRange2 - oldRange2) / 2 + add) >= this.dpInfo.seq2len) {
            newStop2 = this.dpInfo.seq2len - 1;
        }
        this.dpInfo.params.seq1Start = newStart1;
        this.dpInfo.params.seq1Stop = newStop1;
        this.dpInfo.params.seq2Start = newStart2;
        this.dpInfo.params.seq2Stop = newStop2;
        this.initiateLocalDotplot(this.dpInfo.submat, this.dpInfo.seqFile1, this.dpInfo.seqFile2, this.dpInfo.params, this.dpInfo.compseq);
    }

    public boolean dotplotExists() {
        return this.dotplotExists;
    }

    public void abortDotplot() {
        this.dotplotAborted = true;
    }

    @Override
    public boolean dotplotAborted() {
        return this.dotplotAborted;
    }

    public boolean checkDotplotAborted() {
        if (this.dotplotAborted) {
            JOptionPane.showMessageDialog(null, "Dotplot computation aborted.", "Aborted", 1);
            this.erasePlot();
            this.dotplotExists = false;
            this.dotplotAborted = false;
            this.plotFailedCleanup();
            this.dp.setPreferredSize(new Dimension(1, 1));
            this.dp.repaint();
            this.dp.invalidate();
            this.container.validate();
            this.cp.setNeedReload(true);
            return true;
        }
        return false;
    }

    public void initiateLocalDotplot(final SubstitutionMatrix submat, final String seqfile1, final String seqfile2, final ParameterSet params, final int compseq) {
        this.stat = new StatusDialog(this);
        WindowPos cpos = this.container.getPosition();
        this.stat.setLocation(cpos.x + cpos.width / 2 - this.stat.getWidth() / 2, cpos.y + cpos.height / 2 - this.stat.getHeight() / 2);
        final Controller ctrl = this;
        Thread worker = new Thread(){

            @Override
            public void run() {
                try {
                    Controller.this.doLocalDotplot(submat, seqfile1, seqfile2, params, compseq);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ClientGlobals.unexpectedError(e, ctrl);
                }
            }
        };
        worker.start();
    }

    public void doLocalDotplot(SubstitutionMatrix submat, String seqfile1, String seqfile2, ParameterSet params, int compseq) {
        this.cp.dotplotStartCalc();
        ((Component)this.container).setCursor(Cursor.getPredefinedCursor(3));
        SuffixArray sa = null;
        boolean SAforSecondSeq = false;
        Sequence sequence1 = null;
        Sequence sequence2 = null;
        if (!this.cp.needReload() && this.dpInfo != null) {
            this.ip.removeAlignment();
            sa = this.dpInfo.suffixArray;
            SAforSecondSeq = this.dpInfo.SAforSecondSeq;
            sequence1 = this.dpInfo.sequence1;
            sequence2 = this.dpInfo.sequence2;
        } else {
            this.erasePlot();
            this.stat.setStatusText("Reading first sequence file...");
            sequence1 = this.readSequenceFile(seqfile1, 1, submat);
            if (sequence1 == null) {
                this.stat.close();
                this.stat = null;
                this.plotFailedCleanup();
                return;
            }
            if (sequence1.hasInvalidChars()) {
                JOptionPane.showMessageDialog(null, "Sequence 1 contains characters which to do not belong to the alphabet defined by the substitution matrix.\n\nA suffix array cannot be saved to or loaded from a file.", "Warning", 2);
            }
            if (!sequence1.likelyNucleotides() && compseq == 1) {
                JOptionPane.showMessageDialog(null, "Sequence 1 seems to be an amino acid sequence.\nNo complementary sequence can be calculated.", "Warning", 2);
                compseq = 0;
                this.cp.uncheckFirstComp();
            }
            if (sequence1.likelyNucleotides() && compseq == 1) {
                this.stat.setStatusText("Calculating complementary sequence...");
                Sequence.complementarizeSequence(sequence1);
            }
            if (seqfile1.equals(seqfile2) && compseq == 0) {
                sequence2 = sequence1;
            } else {
                this.stat.setStatusText("Reading first sequence file...");
                sequence2 = this.readSequenceFile(seqfile2, 2, submat);
                if (sequence2 == null) {
                    this.stat.close();
                    this.stat = null;
                    this.plotFailedCleanup();
                    return;
                }
                if (sequence2.hasInvalidChars()) {
                    JOptionPane.showMessageDialog(null, "Sequence 2 contains characters which to do not belong to the alphabet defined by the substitution matrix.\n\nA suffix array cannot be saved to or loaded from a file.", "Warning", 2);
                }
                if (!sequence1.likelyNucleotides() && compseq == 2) {
                    JOptionPane.showMessageDialog(null, "Sequence 2 seems to be an amino acid sequence.\nNo complementary sequence can be calculated.", "Warning", 2);
                    compseq = 0;
                    this.cp.uncheckSecondComp();
                }
                if (sequence2.likelyNucleotides() && compseq == 2) {
                    this.stat.setStatusText("Calculating complementary sequence...");
                    Sequence.complementarizeSequence(sequence2);
                }
            }
        }
        if (sequence1.getLength() <= params.seq1Stop) {
            JOptionPane.showMessageDialog(null, "Stop parameter for sequence 1 is higher than sequence length.", "Warning", 2);
            this.plotFailedCleanup();
            return;
        }
        if (sequence2.getLength() <= params.seq2Stop) {
            JOptionPane.showMessageDialog(null, "Stop parameter for sequence 2 is higher than sequence length.", "Warning", 2);
            this.plotFailedCleanup();
            return;
        }
        if (this.checkDotplotAborted()) {
            return;
        }
        if (params.seq1Stop == 0) {
            params.seq1Stop = sequence1.getLength() - 1;
        }
        if (params.seq2Stop == 0) {
            params.seq2Stop = sequence2.getLength() - 1;
        }
        if (this.cp.useAutoZoom() || params.zoom == 0) {
            params.zoom = this.getAutoZoom(params.seq1Start, params.seq1Stop, params.seq2Start, params.seq2Stop);
            if (params.zoom == -1) {
                this.errPlotTooNarrow();
                this.plotFailedCleanup();
                return;
            }
        }
        if ((params.seq1Stop - params.seq1Start + 1) / params.zoom == 0) {
            JOptionPane.showMessageDialog(null, "Plot is too narrow. Please alter start/stop parameters for sequence 1 to enlarge the range on this sequence.", "Warning", 2);
            this.plotFailedCleanup();
            return;
        }
        if ((params.seq2Stop - params.seq2Start + 1) / params.zoom == 0) {
            JOptionPane.showMessageDialog(null, "Plot is too narrow. Please alter start/stop parameters for sequence 2 to enlarge the range on this sequence.", "Warning", 2);
            this.plotFailedCleanup();
            return;
        }
        if (this.cp.useAutoParameters()) {
            AutoParameters.setAutoParameters(params);
        }
        if (AutoParameters.areCriticalParameters(params) && JOptionPane.showConfirmDialog(null, "The plot parameters you set might result in a long computation time.You should increase the wordlength or disable window mode.\nProceed?", "Warning", 0, 2) == 1) {
            this.plotFailedCleanup();
            return;
        }
        this.cp.setParameterSet(params);
        boolean noSAfileOverwrite = false;
        if (sa == null) {
            String seqFileForSA;
            Sequence SAseq;
            boolean calcSA = true;
            SAforSecondSeq = compseq > 0 ? compseq == 1 : sequence1.getLength() < sequence2.getLength();
            if (!SAforSecondSeq) {
                SAseq = sequence1;
                seqFileForSA = seqfile1;
            } else {
                SAseq = sequence2;
                seqFileForSA = seqfile2;
            }
            String seqdirsafile = String.valueOf(seqFileForSA) + ".sa";
            String settingssafile = String.valueOf(ClientGlobals.SETTINGS_DIR) + SuffixArray.getSAFilename(seqFileForSA);
            if (!SAseq.hasInvalidChars()) {
                calcSA = false;
                String safile = new File(seqdirsafile).exists() ? seqdirsafile : (new File(settingssafile).exists() ? settingssafile : null);
                if (safile != null) {
                    try {
                        this.stat.setStatusText("Loading suffix array from file...");
                        sa = SuffixArray.loadFromFile(new File(safile), SAseq.getSequenceData());
                    }
                    catch (Exception ex) {
                        if (JOptionPane.showConfirmDialog(null, "The file '" + safile + "' could not be recognized as a valid suffix array file for this sequence.\n\nDelete file now?", "Warning", 0, 2) == 0) {
                            new File(safile).delete();
                        } else {
                            noSAfileOverwrite = true;
                        }
                        calcSA = true;
                    }
                } else {
                    calcSA = true;
                }
            }
            if (calcSA) {
                if (ClientGlobals.useVmatch && SAseq.getLength() >= 50000 && SAseq.likelyNucleotides()) {
                    try {
                        if (this.cp.saveSuffixArrays()) {
                            this.stat.setStatusText("Vmatch calculates suffix array...");
                            VmatchConverter.genSAFileFromVmatch(seqFileForSA, SAseq.getLength(), new File(settingssafile), ClientGlobals.vmatchCommand);
                            this.stat.setStatusText("Loading array from file...");
                            sa = SuffixArray.loadFromFile(new File(settingssafile), SAseq.getSequenceData());
                        } else {
                            File tempfile = File.createTempFile("gepard", "tmpfile");
                            this.stat.setStatusText("Vmatch calculates suffix array...");
                            VmatchConverter.genSAFileFromVmatch(seqFileForSA, SAseq.getLength(), tempfile, ClientGlobals.vmatchCommand);
                            this.stat.setStatusText("Loading array from file...");
                            sa = SuffixArray.loadFromFile(tempfile, SAseq.getSequenceData());
                            tempfile.delete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ClientGlobals.useVmatch = false;
                    }
                }
                if (sa == null) {
                    this.stat.setStatusText("Calculating suffix array...");
                    try {
                        sa = new SuffixArray(SAseq, submat.getAlphabetSize(), this);
                    }
                    catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        ClientGlobals.errMessage("Out of memory!\nTry launching Gepard with a higher amount of available memory.");
                        this.plotFailedCleanup();
                        return;
                    }
                    if (!this.dotplotAborted && this.cp.saveSuffixArrays() && !SAseq.hasInvalidChars() && !noSAfileOverwrite) {
                        try {
                            this.stat.setStatusText("Writing suffix array to file...");
                            sa.saveToFile(settingssafile);
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(null, "Failed saving suffix array to file.\n\nError message:\n" + ioe, "Error", 2);
                        }
                    }
                }
            }
        }
        System.gc();
        if (this.checkDotplotAborted()) {
            return;
        }
        this.dotplotExists = false;
        this.stat.setStatusText("Calculating dot matrix...");
        DotMatrix dm = new DotMatrix(sequence1.getSequenceData(), sequence2.getSequenceData(), sequence1.getName(), sequence2.getName(), sa, params, submat, this.stat, this, SAforSecondSeq);
        if (this.checkDotplotAborted()) {
            return;
        }
        this.stat.setStatusText("Preparing dotplot...");
        this.dpInfo = new DotplotInfo(sequence1.getLength(), sequence2.getLength(), dm.getWidth(), dm.getHeight(), sa, SAforSecondSeq, params, submat, true, compseq, seqfile1, seqfile2);
        this.dpInfo.sequence1 = sequence1;
        this.dpInfo.sequence2 = sequence2;
        this.showDotplot(dm);
        ((Component)this.container).setCursor(Cursor.getDefaultCursor());
        this.stat.close();
        this.stat = null;
        this.cp.dotplotReady();
        this.cp.setNucleotidePlot(dm.isNucleotideMatrix());
        this.cp.updateSADiskSpace();
        System.gc();
    }

    private void showDotplot(DotMatrix dm) {
        this.p = new Plotter(dm, this.dp);
        this.dp.setPlotter(this.p);
        this.cp.setupScrollbars(dm.getMinDotScore(), dm.getMaxDotScore());
        if (this.dpInfo.params.wordLength > 0) {
            this.cp.setScrollbars(0.0f, 20.0f, 0.0f, 20.0f);
        } else {
            float gooddisp = (dm.getAvgDotScore() + dm.getMaxDotScore()) * 0.4f;
            int percent = (int)((gooddisp - dm.getMinDotScore()) / (dm.getMaxDotScore() - dm.getMinDotScore()) * 100.0f);
            this.cp.setScrollbars(percent, 100.0f, 50.0f, 20.0f);
        }
        this.cp.showDisplayTab();
        this.cp.setNeedReload(false);
        this.container.setTitle(String.valueOf(ClientGlobals.cutString(dm.getSeq1Name(), 50)) + "  vs.  " + ClientGlobals.cutString(dm.getSeq2Name(), 50) + "  -  " + ClientGlobals.APPNAME);
        this.dotplotExists = true;
        this.dp.invalidate();
        this.container.validate();
        this.ip.componentResized(null);
        this.cp.setGoButtonCaption(true);
    }

    public void plotFailedCleanup() {
        this.cp.dotplotFailed();
        ((Component)this.container).setCursor(Cursor.getDefaultCursor());
        if (this.stat != null) {
            this.stat.close();
        }
    }

    public void showAlignments(boolean show) {
        this.ip.showAlignments(show);
    }

    private Sequence readSequenceFile(String file, int num, SubstitutionMatrix submat) {
        int ret;
        Sequence seq = null;
        try {
            seq = FASTAReader.readFile(file, submat);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.container, "Failed loading sequence file " + num + "\nIO error: " + e.getMessage(), "Failed loading sequence file " + num, 0);
            return null;
        }
        catch (InvalidFASTAFileException e) {
            JOptionPane.showMessageDialog(this.container, "Failed loading sequence file " + num + "\nInvalid FASTA file: " + e.getMessage(), "Failed loading sequence file " + num, 0);
            return null;
        }
        if (seq.likelyNucleotides() && !submat.isNucleotideMatrix() ? (ret = JOptionPane.showConfirmDialog(this.container, "You are using an amino acid (protein) substitution matrix but your sequence appears to be a nucleotide sequence.\nProceed?", "Warning: Sequence " + num, 0, 2)) == 1 : !seq.likelyNucleotides() && submat.isNucleotideMatrix() && (ret = JOptionPane.showConfirmDialog(this.container, "You are using a nucleotide substitution matrix but your sequence appears to be an amino acid (protein) sequence.\nProceed?", "Warning: Sequence " + num, 0, 2)) == 1) {
            return null;
        }
        return seq;
    }

    private void erasePlot() {
        this.dp.setPlotter(null);
        this.p = null;
        this.dpInfo = null;
        this.ip.removeAlignment();
        System.gc();
    }

    public void eventReplot(float lower, float upper, float greyscale) {
        this.p.reCalc(lower, upper, greyscale);
        this.dp.repaint();
    }

    public void eventExportImage(String file, String format) {
        try {
            ImageIO.write((RenderedImage)this.p.getFullImage(), format, new File(file));
            JOptionPane.showMessageDialog(this.container, "Dotplot successfully exported", "Export", 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Could not export image file.\n\nError message:\n" + e, "Error", 2);
        }
    }

    public void eventMouseMove(int x, int y) {
        if (!this.dotplotExists) {
            return;
        }
        if (!this.dp.hasFocus()) {
            this.dp.requestFocus();
        }
        this.mousex = x;
        this.mousey = y;
        int tx = this.transX(x);
        int ty = this.transY(y);
        if (this.ctrlpressed) {
            int inploty;
            int inplotx = x - 85;
            if (inplotx < 0) {
                inplotx = 0;
            }
            if (inplotx >= this.dpInfo.dpWidth) {
                inplotx = this.dpInfo.dpWidth - 1;
            }
            if ((inploty = y - 110) < 0) {
                inploty = 0;
            }
            if (inploty >= this.dpInfo.dpHeight) {
                inploty = this.dpInfo.dpHeight - 1;
            }
            String gene1 = null;
            String gene2 = null;
            if (this.genenames == null) {
                gene1 = "-";
                gene2 = "-";
            } else {
                this.genenames.getGeneName(true, inplotx);
                this.genenames.getGeneName(false, inploty);
            }
            this.p.setGeneToolTip(x, y, gene1, gene2);
            this.dp.repaint();
        }
        if (this.dpInfo.sequence1 != null && this.dpInfo.sequence2 != null) {
            this.ip.setCoordinates(tx, ty, this.getMultiName(this.dpInfo.sequence1, tx), this.getMultiName(this.dpInfo.sequence2, ty));
        }
    }

    private String getMultiName(Sequence seq, int pos) {
        if (!seq.isMulti()) {
            return null;
        }
        int[] starts = seq.getMultiStarts();
        int i = 0;
        i = 0;
        while (i < starts.length) {
            if (pos <= starts[i]) break;
            ++i;
        }
        if (--i < 0) {
            i = 0;
        }
        String[] names = seq.getMultiNames();
        return names[i];
    }

    public void validateContainer() {
        if (this.container != null) {
            this.container.validate();
        }
    }

    public void eventMouseClick(int x, int y, int button) {
        if (!this.dotplotExists) {
            return;
        }
        int tX = this.transX(x);
        int tY = this.transY(y);
        int localClickAction = this.cp.getLocalClickAction();
        if (localClickAction == 0) {
            this.sticking = false;
            this.reversestick = false;
            this.curAlignData1 = this.dpInfo.sequence1.getSequenceData();
            this.curAlignData2 = this.dpInfo.sequence2.getSequenceData();
            this.dataOffset1 = 0;
            this.dataOffset2 = 0;
            this.crossX = x;
            this.crossY = y;
            if (button == 1) {
                this.crossPosX = tX;
                this.crossPosY = tY;
            } else if (this.dpInfo.submat.isNucleotideMatrix()) {
                Pos diagonal = this.searchDiagonal(tX, tY);
                if (diagonal.x == -1) {
                    ClientGlobals.infoMessage("No diagonal found in this area, showing normal aligment");
                    this.crossPosX = tX;
                    this.crossPosY = tY;
                } else {
                    this.stickToDiagonal(diagonal);
                }
            } else {
                ClientGlobals.warnMessage("No sticky click for protein sequence dotplots!");
                this.crossPosX = tX;
                this.crossPosY = tY;
            }
            this.ip.showAlignment(this.curAlignData1, this.curAlignData2, this.dataOffset1, this.dataOffset2, this.curAlignData1.length, this.curAlignData2.length, this.crossPosX, this.crossPosY, this.dpInfo.submat, this.cp.reverseComplementaryAlignments());
            this.p.setCrossHair(this.crossX, this.crossY, this.crossPosX, this.crossPosY);
            this.dp.repaint();
        } else if (localClickAction == 1) {
            ClientGlobals.infoMessage("Exporting current sequence window to FASTA files:\nSequence 1: " + this.dpInfo.params.seq1Start + "-" + this.dpInfo.params.seq1Stop + "\n" + "Sequence 2: " + this.dpInfo.params.seq2Start + "-" + this.dpInfo.params.seq2Stop);
            String lastdir = Config.getInstance().getStringVal("lastopendir_seqexport", "");
            JFileChooser f = new JFileChooser(lastdir);
            String defFile = ClientGlobals.insertBeforeExtension(ClientGlobals.extractFilename(this.dpInfo.seqFile1), "_" + this.dpInfo.params.seq1Start + "-" + this.dpInfo.params.seq1Stop);
            f.setSelectedFile(new File(defFile));
            int retval = f.showSaveDialog(this.mp);
            if (retval == 0) {
                try {
                    FASTAWriter.writeFASTAFile(f.getSelectedFile().getAbsolutePath(), this.dpInfo.sequence1, this.dpInfo.params.seq1Start, this.dpInfo.params.seq1Stop - this.dpInfo.params.seq1Start + 1, this.dpInfo.submat);
                    defFile = ClientGlobals.insertBeforeExtension(ClientGlobals.extractFilename(this.dpInfo.seqFile2), "_" + this.dpInfo.params.seq2Start + "-" + this.dpInfo.params.seq2Stop);
                    f.setSelectedFile(new File(defFile));
                    retval = f.showSaveDialog(this.mp);
                    if (retval == 0) {
                        FASTAWriter.writeFASTAFile(f.getSelectedFile().getAbsolutePath(), this.dpInfo.sequence2, this.dpInfo.params.seq2Start, this.dpInfo.params.seq2Stop - this.dpInfo.params.seq2Start + 1, this.dpInfo.submat);
                        Config.getInstance().setVal("lastopendir_seqexport", f.getSelectedFile().getParent());
                    }
                }
                catch (IOException e) {
                    ClientGlobals.errMessage("Error while writing file:\n\n" + e.getMessage());
                }
            }
        }
    }

    private void stickToDiagonal(Pos diagonal) {
        this.crossPosX = diagonal.x;
        this.crossPosY = diagonal.y;
        this.crossX = (this.crossPosX - this.dpInfo.params.seq1Start) / this.dpInfo.params.zoom + 85;
        this.crossY = (this.crossPosY - this.dpInfo.params.seq2Start) / this.dpInfo.params.zoom + 110;
        this.cp.setRevComplAlign(diagonal.reverse);
        this.sticking = true;
        this.reversestick = diagonal.reverse;
    }

    public void updateAlignment() {
        this.ip.updateAlignment(this.cp.reverseComplementaryAlignments());
    }

    public void eventMouseDrag(int x, int y) {
        if (!this.dotplotExists) {
            return;
        }
        if (!this.isDragging) {
            this.selStartX = x;
            this.selStartY = y;
            this.isDragging = true;
            this.p.removeCrossHair();
        }
        this.ip.setSelection(this.transX(this.selStartX), this.transY(this.selStartY), this.transX(x), this.transY(y));
        this.p.setSelection(this.selStartX, this.selStartY, x, y);
        this.dp.repaint();
    }

    public void eventMouseRelease(int x, int y) {
        if (!this.dotplotExists) {
            return;
        }
        if (this.isDragging) {
            int tselStartX = this.transX(this.selStartX);
            int tselStartY = this.transY(this.selStartY);
            int tselStopX = this.transX(x);
            int tselStopY = this.transY(y);
            if (tselStartX != tselStopX && tselStartY != tselStopY) {
                int x1 = 0;
                int y1 = 0;
                int x2 = 0;
                int y2 = 0;
                x1 = tselStartX < tselStopX ? tselStartX : tselStopX;
                x2 = tselStartX > tselStopX ? tselStartX : tselStopX;
                y1 = tselStartY < tselStopY ? tselStartY : tselStopY;
                y2 = tselStartY > tselStopY ? tselStartY : tselStopY;
                this.isDragging = false;
                ParameterSet cpyparams = null;
                try {
                    cpyparams = this.cp.getParameterSet(true).getClone();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.cp.useAutoZoom()) {
                    cpyparams.zoom = this.getAutoZoom(x1, x2, y1, y2);
                }
                if (cpyparams.zoom == 0) {
                    cpyparams.zoom = 1;
                }
                cpyparams.seq1Start = x1;
                cpyparams.seq1Stop = x2;
                cpyparams.seq2Start = y1;
                cpyparams.seq2Stop = y2;
                this.cp.setParameterSet(cpyparams);
                this.cp.showOptionsTab();
            }
        }
    }

    public void eventExit() {
        try {
            Config.getInstance().storeConfig();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Could not save configuration file '" + Config.getConfigFileName() + "'.\n\nError:\n" + e, "Error", 2);
        }
        AboutDialog about = new AboutDialog();
    }

    public void exit() {
        this.container.close();
    }

    private void errPlotTooNarrow() {
        ClientGlobals.warnMessage("Using the current zoom level the dotplot would become too narrow (as one of the sequences is too short).\nPlease decrease the zoom level or use a smaller section of the longer sequence.");
    }

    private int getAutoZoom(int x1, int x2, int y1, int y2) {
        int realzoom;
        Dimension dimdraw = this.mp.getRealDrawPanelDim();
        dimdraw.width -= 100;
        dimdraw.height -= 125;
        if (this.cp.smallPlots()) {
            dimdraw.width /= 2;
            dimdraw.height /= 2;
        }
        int xzoom = (int)Math.ceil((float)(x2 - x1) / (float)dimdraw.width);
        int yzoom = (int)Math.ceil((float)(y2 - y1) / (float)dimdraw.height);
        if (xzoom == 0 && yzoom == 0) {
            xzoom = 1;
        }
        int n = realzoom = xzoom > yzoom ? xzoom : yzoom;
        if (realzoom > x2 - x1 || realzoom > y2 - y1) {
            return -1;
        }
        return realzoom;
    }

    private int transX(int x) {
        int val = (x - 85) * this.dpInfo.params.zoom + this.dpInfo.params.seq1Start;
        if (val < this.dpInfo.params.seq1Start) {
            val = this.dpInfo.params.seq1Start;
        } else if (val > this.dpInfo.params.seq1Stop) {
            val = this.dpInfo.params.seq1Stop;
        }
        return val;
    }

    private int transY(int y) {
        int val = (y - 110) * this.dpInfo.params.zoom + this.dpInfo.params.seq2Start;
        if (val < this.dpInfo.params.seq2Start) {
            val = this.dpInfo.params.seq2Start;
        } else if (val > this.dpInfo.params.seq2Stop) {
            val = this.dpInfo.params.seq2Stop;
        }
        return val;
    }

    public boolean eventKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 17) {
            this.ctrlpressed = true;
            this.eventMouseMove(this.mousex, this.mousey);
        }
        if (this.curAlignData1 == null) {
            return false;
        }
        boolean updateAlignment = true;
        switch (evt.getKeyCode()) {
            case 37: {
                --this.crossPosX;
                this.sticking = false;
                break;
            }
            case 39: {
                ++this.crossPosX;
                this.sticking = false;
                break;
            }
            case 38: {
                --this.crossPosY;
                this.sticking = false;
                break;
            }
            case 40: {
                ++this.crossPosY;
                this.sticking = false;
                break;
            }
            case 65: {
                this.crossPosX -= 25;
                this.sticking = false;
                break;
            }
            case 68: {
                this.crossPosX += 25;
                this.sticking = false;
                break;
            }
            case 87: {
                this.crossPosY -= 25;
                this.sticking = false;
                break;
            }
            case 83: {
                this.crossPosY += 25;
                this.sticking = false;
                break;
            }
            case 71: {
                --this.crossPosX;
                if (this.reversestick) {
                    ++this.crossPosY;
                    break;
                }
                --this.crossPosY;
                break;
            }
            case 72: {
                ++this.crossPosX;
                if (this.reversestick) {
                    --this.crossPosY;
                    break;
                }
                ++this.crossPosY;
                break;
            }
            case 74: {
                this.crossPosX -= 25;
                if (this.reversestick) {
                    this.crossPosY += 25;
                    break;
                }
                this.crossPosY -= 25;
                break;
            }
            case 75: {
                this.crossPosX += 25;
                if (this.reversestick) {
                    this.crossPosY -= 25;
                    break;
                }
                this.crossPosY += 25;
                break;
            }
            default: {
                updateAlignment = false;
            }
        }
        if (updateAlignment) {
            if (this.crossPosX < this.dpInfo.params.seq1Start) {
                this.crossPosX = this.dpInfo.params.seq1Start;
            }
            if (this.crossPosX > this.dpInfo.params.seq1Stop) {
                this.crossPosX = this.dpInfo.params.seq1Stop;
            }
            if (this.crossPosY < this.dpInfo.params.seq2Start) {
                this.crossPosY = this.dpInfo.params.seq2Start;
            }
            if (this.crossPosY > this.dpInfo.params.seq2Stop) {
                this.crossPosY = this.dpInfo.params.seq2Stop;
            }
            this.crossX = (this.crossPosX - this.dpInfo.params.seq1Start) / this.dpInfo.params.zoom + 85;
            this.crossY = (this.crossPosY - this.dpInfo.params.seq2Start) / this.dpInfo.params.zoom + 110;
            if (this.sticking) {
                this.cp.setRevComplAlign(this.reversestick);
            }
            this.ip.showAlignment(this.curAlignData1, this.curAlignData2, this.dataOffset1, this.dataOffset2, this.curAlignData1.length, this.curAlignData2.length, this.crossPosX, this.crossPosY, this.dpInfo.submat, this.cp.reverseComplementaryAlignments());
            this.p.setCrossHair(this.crossX, this.crossY, this.crossPosX, this.crossPosY);
            this.p.removeSelection();
            this.dp.repaint();
        }
        return false;
    }

    public boolean eventKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 17) {
            this.ctrlpressed = false;
            this.p.noToolTips();
            this.dp.repaint();
        }
        return false;
    }

    public void responseDotplot(DotMatrix dm, GeneNames genenames) {
        this.dpInfo.seq1len = dm.getSeq1Length();
        this.dpInfo.seq2len = dm.getSeq2Length();
        this.showDotplot(dm);
        this.genenames = genenames;
        ((Component)this.container).setCursor(Cursor.getDefaultCursor());
        if (this.stat != null) {
            this.stat.close();
            this.stat = null;
        }
        this.cp.dotplotReady();
        this.cp.setNucleotidePlot(true);
    }

    public void updateProxySettings(boolean startup) {
        String host = Config.getInstance().getStringVal("proxy_host", "");
        String port = Config.getInstance().getStringVal("proxy_port", "");
        Properties sysProperties = System.getProperties();
        if (host.trim().equals("")) {
            sysProperties.put("http.proxyHost", "");
            sysProperties.put("http.proxyPort", "");
            sysProperties.put("http.proxySet", "false");
        } else {
            sysProperties.put("http.proxyHost", host);
            sysProperties.put("http.proxyPort", port);
            sysProperties.put("http.proxySet", "true");
        }
        if (!startup && JOptionPane.showConfirmDialog(this.container, "You have to restart Gepard in order to apply the proxy settings.\n\nQuit program now?", "Proxy settings", 0, 3) == 0) {
            this.eventExit();
        }
    }

    public DotplotInfo getDPInfo() {
        return this.dpInfo;
    }

    public ContainerWindow getContainer() {
        return this.container;
    }

    public String getGUIDump() {
        return this.cp.getGUIDump();
    }

    private Pos searchDiagonal(int x, int y) {
        int j;
        int matches;
        int SCANOFZOOM = 10;
        int STICKY_RANGE = this.dpInfo.params.zoom * 10;
        int STICKY_WINDOW = 20;
        int STICKY_THRESH = 28;
        byte[] complmap = Sequence.getComplementaryMap();
        int maxmatches = 0;
        int maxx = 0;
        int maxy = 0;
        boolean reverse = false;
        int forward = STICKY_RANGE / 2;
        ParameterSet params = this.dpInfo.params;
        boolean dox = true;
        int checkx = x - forward;
        int checky = y + forward;
        while (checkx <= x + forward) {
            if (checkx >= params.seq1Start + 20 && checky >= params.seq2Start + 20 && checkx <= params.seq1Stop - 20 && checky <= params.seq2Stop - 20) {
                matches = 0;
                j = -20;
                while (j <= 20) {
                    if (this.curAlignData1[checkx + j - this.dataOffset1] == this.curAlignData2[checky + j - this.dataOffset2]) {
                        ++matches;
                    }
                    ++j;
                }
                if (matches > maxmatches) {
                    maxmatches = matches;
                    maxx = checkx;
                    maxy = checky;
                    reverse = false;
                }
            }
            if (dox) {
                ++checkx;
            } else {
                --checky;
            }
            boolean bl = dox = !dox;
        }
        dox = true;
        checkx = x + forward;
        checky = y + forward;
        while (checkx >= x - forward) {
            if (checkx >= params.seq1Start + 20 && checky >= params.seq2Start + 20 && checkx <= params.seq1Stop - 20 && checky <= params.seq2Stop - 20) {
                matches = 0;
                j = -20;
                while (j <= 20) {
                    if (this.curAlignData1[checkx - j - this.dataOffset1] == complmap[this.curAlignData2[checky + j - this.dataOffset2]]) {
                        ++matches;
                    }
                    ++j;
                }
                if (matches > maxmatches) {
                    maxmatches = matches;
                    maxx = checkx;
                    maxy = checky;
                    reverse = true;
                }
            }
            if (dox) {
                --checkx;
            } else {
                --checky;
            }
            boolean bl = dox = !dox;
        }
        if (maxmatches >= 28) {
            return new Pos(maxx, maxy, reverse);
        }
        return new Pos(-1, -1, true);
    }

    private class Pos {
        public int x;
        public int y;
        boolean reverse;

        public Pos(int x, int y, boolean reverse) {
            this.x = x;
            this.y = y;
            this.reverse = reverse;
        }
    }
}

