/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client;

import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import org.gepard.common.SAXFinishedException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class Config
extends DefaultHandler {
    private static Config instance = null;
    private static String configFile = null;
    private HashMap<String, String> settings;

    public static void setConfigFile(String file) throws Exception {
        if (instance == null) {
            configFile = file;
            try {
                instance = new Config();
            }
            catch (Exception e) {
                instance = new Config(true);
                throw e;
            }
        }
    }

    public static String getConfigFileName() {
        return configFile;
    }

    public static Config getInstance() {
        return instance;
    }

    public String getStringVal(String name, String defval) {
        String temp = this.settings.get(name);
        if (temp != null) {
            return temp;
        }
        return defval;
    }

    public int getIntVal(String name, int defval) {
        String temp = this.settings.get(name);
        if (temp != null) {
            return Integer.parseInt(temp);
        }
        return defval;
    }

    public void setIntVal(String name, int val) {
        this.setVal(name, String.valueOf(val));
    }

    public void setVal(String name, String val) {
        this.settings.remove(name);
        this.settings.put(name, val);
    }

    public void storeConfig() throws FileNotFoundException {
        PrintStream p = new PrintStream(new FileOutputStream(configFile));
        p.println("<settings>");
        for (String key : this.settings.keySet()) {
            String value = this.settings.get(key);
            p.println("\t<setting name=\"" + key + "\" value=\"" + value + "\" />");
        }
        p.println("</settings>");
        p.close();
    }

    private Config() throws Exception {
        SAXParser p = new SAXParser();
        p.setContentHandler(this);
        this.settings = new HashMap();
        p.parse(configFile);
    }

    private Config(boolean noFile) {
        this.settings = new HashMap();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXFinishedException {
        if (localName.toLowerCase().equals("setting")) {
            this.settings.put(atts.getValue("name"), atts.getValue("value"));
        }
    }
}

