/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;

public class BrowserLauncher {
    static final String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape"};

    public static void openURL(String url) throws Exception {
        boolean worked = true;
        try {
            URI uri = new URI(url);
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method getDesktop = desktopClass.getMethod("getDesktop", new Class[0]);
            Method browse = desktopClass.getMethod("browse", uri.getClass());
            Object desktop = getDesktop.invoke(null, new Object[0]);
            browse.invoke(desktop, uri);
        }
        catch (Exception e) {
            worked = false;
        }
        catch (Error e) {
            worked = false;
        }
        if (!worked) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                boolean found = false;
                String[] stringArray = browsers;
                int n = browsers.length;
                int n2 = 0;
                while (n2 < n) {
                    String browser = stringArray[n2];
                    if (!found) {
                        boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                        if (found) {
                            Runtime.getRuntime().exec(new String[]{browser, url});
                        }
                    }
                    ++n2;
                }
                if (!found) {
                    throw new Exception(Arrays.toString(browsers));
                }
            }
        }
    }
}

