/*
 * Decompiled with CFR 0.152.
 */
package org.gepard.client;

import org.gepard.common.ParameterSet;

public class AutoParameters {
    private static final long WORDLENZERO_AUTOTHRESHOLD = 2250000L;
    private static final long WARNING_THRESHOLD = 100000000L;
    private static final int FIXED_WORDLENGTH = 10;
    private static final int CRITICAL_WORDLEN = 5;
    private static final int MAXSIZE_FOR_SEQDATA = 500000;

    public static void setAutoParameters(ParameterSet params) {
        long dots = (long)(params.seq1Stop - params.seq1Start + 1) * (long)(params.seq2Stop - params.seq2Start + 1);
        if (dots > 2250000L) {
            params.wordLength = 10;
            params.windowSize = 0;
        } else {
            params.wordLength = 0;
            params.windowSize = 25;
        }
    }

    public static boolean areCriticalParameters(ParameterSet params) {
        if (params.wordLength == 0) {
            long dots = (long)(params.seq1Stop - params.seq1Start + 1) * (long)(params.seq2Stop - params.seq2Start + 1);
            return dots > 100000000L;
        }
        return params.wordLength <= 5;
    }

    public static boolean mayRequestSequenceData(ParameterSet params) {
        return params.seq1Stop - params.seq1Start + 1 <= 500000 && params.seq2Stop - params.seq2Start + 1 <= 500000;
    }

    public static int getMaxSizeForSeqData() {
        return 500000;
    }
}

