/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.javagyak.zh2.popserver;

import hu.ppke.itk.javagyak.zh2.popserver.Client;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;

public class Server
extends Thread {
    public static boolean DEBUG = true;
    private static final int PORT = 110;
    private static final String USERS_FILE = "/felhasznalok.txt";
    private ServerSocket socket = new ServerSocket(110);
    private HashMap<String, String> users;

    public Server() throws IOException {
        String line;
        if (DEBUG) {
            System.out.println("Users database is loading");
        }
        this.users = new HashMap();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(USERS_FILE)));
        while ((line = reader.readLine()) != null) {
            String[] user = line.split("\t");
            this.users.put(user[0].toLowerCase(), user[1].toUpperCase());
        }
        reader.close();
        if (DEBUG) {
            System.out.println("The database is ready");
            System.out.println("Server is listening on 110");
        }
    }

    @Override
    public void run() {
        while (!this.socket.isClosed()) {
            try {
                Socket s = this.socket.accept();
                new Client(this, s).start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean validateUserName(String username) {
        boolean ret = false;
        if (this.users.containsKey(username.toLowerCase())) {
            ret = true;
        }
        return ret;
    }

    public boolean validateUser(String username, String password) {
        boolean ret = false;
        if (this.users.get(username).equals(password)) {
            ret = true;
        }
        return ret;
    }
}

