/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.javagyak.zh2.popserver;

import hu.ppke.itk.javagyak.zh2.popserver.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Client
extends Thread {
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private Server server;
    private String username;
    private String password;
    private int myMessageNumber;
    private int myMessageSize = 0;
    private Pattern usernamePattern = Pattern.compile("\\s*USER\\s+(\\w+)\\s*", 2);
    private Pattern passwordPattern = Pattern.compile("\\s*PASS\\s+(\\w+)\\s*", 2);
    private Pattern quitPattern = Pattern.compile("\\s*QUIT\\s*", 2);
    private Pattern statPattern = Pattern.compile("\\s*STAT\\s*", 2);
    private Pattern retrPattern = Pattern.compile("\\s*RETR\\s+(\\d+)\\s*", 2);

    public Client(Server server, Socket socket) throws IOException {
        this.server = server;
        this.socket = socket;
        Random random = new Random();
        this.myMessageNumber = random.nextInt(10) + 1;
        int i = 0;
        while (i < this.myMessageNumber) {
            this.myMessageSize += random.nextInt(10) + 1;
            ++i;
        }
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.writer = new PrintWriter(socket.getOutputStream(), true);
    }

    @Override
    public void run() {
        block16: {
            try {
                String line;
                this.write(Client.generateOkMessage("Successfully connected, you can log in now"));
                Matcher matcher = this.usernamePattern.matcher(this.read());
                while (!matcher.matches()) {
                    this.write(Client.generateErrMessage("Bad request"));
                    matcher = this.usernamePattern.matcher(this.read());
                }
                this.username = matcher.group(1);
                while (!this.server.validateUserName(this.username)) {
                    this.write(Client.generateErrMessage("No such user"));
                    matcher = this.usernamePattern.matcher(this.read());
                    while (!matcher.matches()) {
                        this.write(Client.generateErrMessage("Bad request"));
                        matcher = this.usernamePattern.matcher(this.read());
                    }
                    this.username = matcher.group(1);
                }
                this.write(Client.generateOkMessage("Great, send me your Neptun code"));
                matcher = this.passwordPattern.matcher(this.read());
                while (!matcher.matches()) {
                    this.write(Client.generateErrMessage("Cannot parse password command!"));
                    matcher = this.passwordPattern.matcher(this.read());
                }
                this.password = matcher.group(1);
                while (!this.server.validateUser(this.username, this.password)) {
                    this.write(Client.generateErrMessage("Authentication failed, wrong Neptun code!"));
                    matcher = this.passwordPattern.matcher(this.read());
                    while (!matcher.matches()) {
                        this.write(Client.generateErrMessage("Cannot parse password command!"));
                        matcher = this.passwordPattern.matcher(this.read());
                    }
                    this.password = matcher.group(1);
                }
                this.write(Client.generateOkMessage("Successful login, have a nice day!"));
                while (!this.quitPattern.matcher(line = this.read()).matches()) {
                    matcher = this.statPattern.matcher(line);
                    if (matcher.matches()) {
                        this.write(Client.generateOkMessage(String.valueOf(this.myMessageNumber) + " " + this.myMessageSize));
                        continue;
                    }
                    matcher = this.retrPattern.matcher(line);
                    if (matcher.matches()) {
                        try {
                            int messageId = Integer.parseInt(matcher.group(1));
                            if (messageId > 0 && messageId <= this.myMessageNumber) {
                                this.write(Client.generateOkMessage(""));
                                this.write("MessageID=\"" + messageId + "\"");
                                this.write("");
                                this.write("Szervusz " + this.username + "!");
                                this.write("");
                                this.write("\"Ha ezt l\u00e1tod, j\u00f3 \u00faton haladsz.\" - Paulo Coelho");
                                this.write("");
                                this.write(".");
                                continue;
                            }
                            this.write(Client.generateErrMessage("No such message"));
                        }
                        catch (NumberFormatException e) {
                            this.write(Client.generateErrMessage("Error while parsing number!"));
                        }
                        continue;
                    }
                    this.write(Client.generateErrMessage("Unknown command!"));
                }
                this.write(Client.generateOkMessage("Bye"));
            }
            catch (IOException e) {
                if (this.socket == null) break block16;
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static String generateOkMessage(String message) {
        return "+OK " + message;
    }

    private static String generateErrMessage(String message) {
        return "-ERR " + message;
    }

    private void write(String message) {
        this.writer.write(String.valueOf(message) + "\r\n");
        this.writer.flush();
    }

    private String read() throws IOException {
        return this.reader.readLine().trim();
    }
}

