function y_raised=raiseBy(y, Fs, freqOffset)
    Y=fft(y);
    freqOffset_scaled = round(length(Y)/Fs*freqOffset);
    Y_part1=Y(1:floor(end/2));
    Y_part2=Y(floor(end/2)+1 : end);
    
    Y_part1=circshift(Y_part1, [freqOffset_scaled, 0]);
    Y_part1(1:freqOffset_scaled) = zeros(size(Y_part1(1:freqOffset_scaled)));
    Y_part2=circshift(Y_part2, [-freqOffset_scaled, 0]);
    Y_part2(end-freqOffset_scaled:end)=zeros(size(Y_part1(end-freqOffset_scaled:end)));
    Y=[Y_part1; Y_part2];
    y_raised=abs(ifft(Y));
end