#include "OpenGL_lib.h"

#include <cmath>

using namespace genv;

//TORUS
int main(int argc, char* argv[])
{
    std::vector<float> Colors;
    std::vector<float> Vertices;
    std::vector<unsigned int> Indices;


    float R=1;
    float r=0.2;
    int N=100,n=20;

    //calculate vertices of the cube
    for (int i=0;i<N;i++) {
        float t1=2*M_PI/N*i;
        float kx=R*cos(t1);
        float ky=R*sin(t1);
        for (int j=0;j<n;j++) {
            float t2=2*M_PI/n*j;
            Vertices.push_back(kx+r*cos(t2)*cos(t1));
            Vertices.push_back(ky+r*cos(t2)*sin(t1));
            Vertices.push_back(r*sin(t2));

            Colors.push_back(1);
            Colors.push_back(1);
            Colors.push_back(0);
        }
    }

    //the indices of vertices, 3 in a row represents a triangle
    for (int circle1=0;circle1<N;circle1++) {
        int circle2=circle1+1;
        if (circle2==N) circle2=0;
        for (int point1=0;point1<n;point1++) {
            int point2=point1+1;
            if (point2==n) point2=0;

            Indices.push_back( circle1 * n + point1);
            Indices.push_back( circle2 * n + point1);
            Indices.push_back( circle1 * n + point2);

            Indices.push_back( circle2 * n + point1);
            Indices.push_back( circle1 * n + point2);
            //Indices.push_back( circle2 * n + point1);
            Indices.push_back( circle2 * n + point2);
        }
    }


    //open window
    glout.open(640,480);

    //assign the vertices, their colors, and the indices to the library
    //
    //Draw mode can be:
    //  DRAW_TRIANGLES (3 vertices per triangle)
    //  DRAW_WIREFRAME (3 vertices per triangle)
    //  DRAW_LINES (2 vertices per line)
    //  DRAW_POINTS (1 vertex per point)
    glout.setVertices(Vertices,Colors,Indices,DRAW_WIREFRAME);

    glout.show();

    return 0;
}



/*
//COLOR CUBE
//8 vertices
//6*2*3 indices
int main(int argc, char* argv[])
{
    std::vector<float> Colors;
    std::vector<float> Vertices;
    std::vector<unsigned int> Indices;

    //calculate vertices of the cube
    for (int z=-1;z<=1;z+=2) {
        for (int y=-1;y<=1;y+=2) {
            for (int x=-1;x<=1;x+=2) {
                Vertices.push_back(x);
                Vertices.push_back(y);
                Vertices.push_back(z);
                Colors.push_back(x>0);
                Colors.push_back(y>0);
                Colors.push_back(z>0);
                //Colors.push_back(1);
                //Colors.push_back(1);
                //Colors.push_back(0);
            }
        }
    }

    //the indices of vertices, 3 in a row represents a triangle
    unsigned int ind[]={
        0,2,1,1,2,3,
        4,5,6,6,5,7,
        0,1,4,5,4,1,
        1,3,5,7,5,3,
        3,2,7,6,7,2,
        2,0,6,4,6,0
    };

    Indices.assign(ind,ind+36);

    //open window
    glout.open(640,480);

    //assign the vertices, their colors, and the indices to the library
    //
    //Draw mode can be:
    //  DRAW_TRIANGLES (3 vertices per triangle)
    //  DRAW_WIREFRAME (3 vertices per triangle)
    //  DRAW_LINES (2 vertices per line)
    //  DRAW_POINTS (1 vertex per point)
    glout.setVertices(Vertices,Colors,Indices,DRAW_WIREFRAME);

    //starting translation and rotation
    glout.translate_abs(0,0,-6);
    glout.rotate_abs_OC(0,0,0);

    //draw 3d object
    glout.refresh();

    //glout.timer(100);
    bool light=false;
    event ev;
    while (glout>>ev) {
        if (ev.type==ev_mouse) {
            //implemented mouse event handler ->
            //users don't have to implement this
            //AND don't have to use it
            glout.mouseEventHandler(ev);
        }
        if (ev.type==ev_key)
        {
            if (ev.keycode=='l')
            {
                //switch lighting
                glout.lighting(light=!light);
            }
        }
        if (ev.type==ev_timer) {
            //automatic rotation
            //glout.rotate_abs_OC(0,1,0);
        }
        //draw 3d object
        glout.refresh();
    }


    return 0;
}
*/
