#include "OpenGL_lib.h"

using namespace genv;

//COLOR CUBE
int main(int argc, char* argv[])
{
    std::vector<float> Colors;
    std::vector<float> Vertices;
    std::vector<unsigned int> Indices;

    //vertices of the cube: -1,-1,-1 ... 1,1,1
    for (int i=-1;i<=1;i+=2) {
        for (int j=-1;j<=1;j+=2) {
            for (int k=-1;k<=1;k+=2) {
                Vertices.push_back(i);
                Vertices.push_back(j);
                Vertices.push_back(k);
                Colors.push_back(i>0);
                Colors.push_back(j>0);
                Colors.push_back(k>0);
            }
        }
    }

    //indices of the triangles

    //top and bottom:
    for (int first=0;first<=4;first+=4) {
        Indices.push_back(first);
        Indices.push_back(first+1);
        Indices.push_back(first+3);

        Indices.push_back(first);
        Indices.push_back(first+3);
        Indices.push_back(first+2);
    }

    //sides
    for (int first=0;first<=3;first+=3) {
        for (int next=1;next<=2;next++) {
            Indices.push_back(first);
            Indices.push_back(next);
            Indices.push_back(next+4);

            Indices.push_back(first);
            Indices.push_back(first+4);
            Indices.push_back(next+4);
        }
    }



    //open window
    glout.open(640,480);

    //assign the vertices, their colors, and the indices to the library
    //
    //Draw mode can be:
    //  DRAW_TRIANGLES (3 vertices per triangle)
    //  DRAW_WIREFRAME (3 vertices per triangle)
    //  DRAW_LINES (2 vertices per line)
    //  DRAW_POINTS (1 vertex per point, Indices omitted)
    glout.setVertices(Vertices,Colors,Indices,DRAW_TRIANGLES);

    glout.show();

    return 0;
}
