#include "OpenGL_lib.h"

#include <cmath>
#include <iostream>

using namespace genv;

//GRAY CUBE
int main(int argc, char* argv[])
{
    std::vector<float> Colors;
    std::vector<float> Vertices;
    std::vector<unsigned int> Indices;

    //vertices of the cube: -1,-1,-1 ... 1,1,1
    for (int t1d=-45;t1d<=45;t1d+=90) {
        for (int t2d=0;t2d<=270;t2d+=90) {
            float t1=t1d*M_PI/180;
            float t2=t2d*M_PI/180;
            Vertices.push_back(cos(t2));
            Vertices.push_back(sin(t2));
            Vertices.push_back(sin(t1));
            Colors.push_back(0.5);
            Colors.push_back(0.5);
            Colors.push_back(0.5);
        }
    }

    //indices of the triangles

    //top and bottom:
    for (int first=0;first<=4;first+=4) {
        Indices.push_back(first);
        Indices.push_back(first+1);
        Indices.push_back(first+2);

        Indices.push_back(first);
        Indices.push_back(first+2);
        Indices.push_back(first+3);
    }

    //sides
    for (int first=0;first<4;first++) {
        int next=first+1;
        if (next==4) next=0;
        Indices.push_back(first);
        Indices.push_back(next);
        Indices.push_back(next+4);

        Indices.push_back(first);
        Indices.push_back(first+4);
        Indices.push_back(next+4);
    }



    //open window
    glout.open(640,480);

    //assign the vertices, their colors, and the indices to the library
    //
    //Draw mode can be:
    //  DRAW_TRIANGLES (3 vertices per triangle)
    //  DRAW_WIREFRAME (3 vertices per triangle)
    //  DRAW_LINES (2 vertices per line)
    //  DRAW_POINTS (1 vertex per point, Indices omitted)
    glout.setVertices(Vertices,Colors,Indices,DRAW_TRIANGLES);

    glout.show();

    return 0;
}
