#include "graphics.hpp"
#include <cstdlib>
#include <vector>
using namespace genv;
//megynitott kperny mrete:
const int X = 300, Y = 300;

struct kor{
    //Kor struct. Adatmezok:
    int o_x, o_y, radius;  //Kor kozeppontja es sugara.
    int c_r, c_g, c_b;    //Kor szine.
    // konstruktor:
    kor(){//default konstruktor. Mindig meg kell irni!!!
        o_x = X/2;
        o_y = Y/2;
        radius = rand()%10+10;
        c_r = rand()%255;
        c_g = rand()%255;
        c_b = rand()%255;
    }
    kor(int _o_x, int _o_y){
        //Beallitja a kor kozeppontjat a kapott koordinatakra es a tobbi parameteret random ertekekre.
        o_x = _o_x;
        o_y = _o_y;
        radius = rand()%10+10;
        c_r = rand()%255;
        c_g = rand()%255;
        c_b = rand()%255;
    }
    //konstruktorok inicializalo sorral:
    //: es a { kozti resznel mezonev(ertek) stilusban inicializalja a mezok ertekeit.
    //szep hasznos(es rovidebb is:P) es van amit csak ilyen stilusban lehet megoldani (tipikusan ilyen: konstans mezok inicializalasa)
    kor(int _o_x, int _o_y, int _r, int _g, int _b): o_x(_o_x), o_y(_o_y), c_r(_r), c_g(_g), c_b(_b){
        radius = rand()%10+10;
    }
    kor(int _o_x, int _o_y, int _rad, int _r, int _g, int _b):
        o_x(_o_x), o_y(_o_y), radius(_rad), c_r(_r), c_g(_g), c_b(_b){}
    //Tagfuggvenyek:

    void kirajzol(){
        //kirajzolo metodus.
        gout << color(c_r,c_g,c_b);
        for(int i = -radius; i < radius; ++i){
            for(int j = -radius; j < radius; ++j){
                //Akkor rajzolunk ki amikor a kor sugaran belul vagyunk es a kepernyon van a keppont.
                if(i*i+j*j < radius*radius && i+o_x < X && i+o_x >= 0 && j+o_y < Y && j+o_y >=0){
                    gout << move_to(i+o_x,j+o_y) << dot;
                }
            }
        }
    }

    void mozog(){
        //mozgato fv.
        o_x += rand()%5-2;
        // ha kicsuszik a kepernyon akkor visszateszi a tuloldalt. ekvivalens: if(o_x >= X || o_x < 0) o_x =(X+o_x)%X;
        if(o_x > X) o_x -= X;
        else if(o_x < 0) o_x += X;

        o_y += rand()%4-1;
        // ha kicsuszik a kepernyon akkor visszateszi a tuloldalt. ekvivalens: if(o_y >= Y || o_y < 0) o_y =(Y+o_y)%Y;
        if(o_y > Y) o_y -= Y;
        else if(o_y < 0) o_y += Y;

    }
};


void torol(){
    gout << move_to(0,0) << color(0,0,0) << box(X,Y);
}

int main()
{
     // hopihek vektora es feltoltese:
    std::vector<kor> hopihek;
    for(unsigned i = 0; i < 100; ++i){
        hopihek.push_back(kor(rand()%X, rand()%Y, rand()%3+2, 255,255,255));
    }


    gout.open(X,Y);
    event ev;
    gin.timer(40);
    while(gin >> ev) {
        if(ev.type == ev_timer){
            torol(); //kepernyo alaphelyzetbe allitasa azaz elozo allapot torlese.
            //kovetkezo allapot kiszamitasa es beallitasa:
            for(unsigned i = 0; i < hopihek.size(); ++i){
                hopihek[i].mozog();
                hopihek[i].kirajzol();
            }
            //tenyleges megjelenites:
            gout << refresh;
        }
    }
    return 0;
}
