#include "graphics.hpp"
#include <cmath>
#include <iostream>
#include <cstdlib>
#include <ctime>
#include <vector>
#include <cmath>

using namespace std;
using namespace genv;

///A kijelzo merete. Innentol minden parameterses.
const int X=1000;
const int Y=500;
const int g = 2;


struct Labda{
private:
    float u,v;
    float vx,vy;
    int r;

    void ellenoriz(){
        if(u>X-r){
            u = X-r;
            vx = -vx;
        }
        else if(r>u){
            u = r;
            vx = -vx;
        }
        if(v>Y-r){
            v = Y-r;
            vy = -vy;
        }
        else if(r>v) {
            v = r;
            vy = -vy;
        }
    }
    void gyorsul(){
        vx += 0;
        vy += g;
    }
public:
    Labda(){
        u = X/2;
        v = Y/2;
        vx= 5;
        vy = 5;
    }
    Labda(float _u, float _v, float _vx, float _vy):
        u(_u),v(_v),vx(_vx){
        vy = _vy;
        r = 20;
    }
    void mozog(){
        gyorsul();
        u+=vx;
        v+=vy;
        ellenoriz();
    }
    void kirajzol(){
        gout << color(255,255,255);
        for(int i = u-r; i<u+r; ++i){
            for(int j = v-r;j<v+r;++j){
                    float R =(i-u)*(i-u)+(j-v)*(j-v);
                if((i-u)*(i-u)+(j-v)*(j-v)<r*r){
                    gout << move_to(i,j) << color(255-R*255/(r*r),255-R*255/(r*r),255-R*255/(r*r)) << dot;
                }
            }
        }
    }
};


void kepernyo_torol()
{
    gout<<move_to(0,0)<<color(0,0,0)<<box(X,Y)<<color(255,255,255);
}


int main()
{
    Labda l(X/2,Y/2,5,0);
    gout.open(X,Y);
    event ev;
    gin.timer(40);
    while(gin >> ev && ev.keycode != key_escape)
    {
        if(ev.type == ev_timer){
            kepernyo_torol();
            l.mozog();
            l.kirajzol();
        }

        gout << refresh;
    }
    return 0;
}
