/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.EmptyValue;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;

public class VarExpression
extends Expression {
    private String varName;
    private ErrorType errorType;

    static VarExpression parseVarExpr(String var, Lexer lex, Environment env) {
        if (!env.hasVar(var)) {
            return new VarExpression(var, ErrorType.EXISTS);
        }
        return new VarExpression(var, env.getVarType(var));
    }

    private VarExpression(String name, Type type, ErrorType errType) {
        super(type);
        this.varName = name;
        this.errorType = errType;
    }

    private VarExpression(String name, Type type) {
        this(name, type, ErrorType.NONE);
    }

    private VarExpression(String name, ErrorType errType) {
        this(name, null, errType);
    }

    public String toString() {
        return this.varName;
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.EXISTS) {
            return ProgramLine.bad(this.varName);
        }
        return this.varName;
    }

    @Override
    Object getValue(State state) {
        Object val = state.getVar(this.varName);
        if (val == null) {
            return new EmptyValue("\"" + this.varName + "\" v\u00e1ltoz\u00f3 nem kapott kezd\u0151\u00e9rt\u00e9ket.");
        }
        return val;
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[0];
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.EXISTS) {
            return "Nincs \"" + this.varName + "\" nev\u0171 v\u00e1ltoz\u00f3.";
        }
        return null;
    }

    private static enum ErrorType {
        NONE,
        EXISTS;

    }
}

