/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class VarDecl {
    private Vector<String> names;
    private Type type;
    private boolean last;
    private ErrorType errorType = ErrorType.NONE;
    private int errIndex = -1;

    static VarDecl parseVarDecl(Lexer lex, Environment env) {
        LinkedList<String> names = new LinkedList<String>();
        if (!lex.isIdent()) {
            return new VarDecl(names, null, ErrorType.NAME);
        }
        names.add(lex.getString());
        lex.next();
        while (lex.isKeyword(",")) {
            lex.next();
            if (!lex.isIdent()) {
                return new VarDecl(names, null, ErrorType.NAME);
            }
            names.add(lex.getString());
            lex.next();
        }
        if (!lex.isKeyword(":")) {
            return new VarDecl(names, null, ErrorType.COLON);
        }
        lex.next();
        Type type = Type.parseType(lex, env);
        VarDecl vd = new VarDecl(names, type, ErrorType.NONE);
        vd.apply(env);
        return vd;
    }

    void apply(Environment env) {
        if (this.errorType != ErrorType.NONE) {
            return;
        }
        int i = 0;
        while (i < this.names.size()) {
            if (env.hasVar(this.names.elementAt(i))) {
                this.errorType = ErrorType.DUP_NAME;
                this.errIndex = i;
            } else {
                env.addVar(this.names.elementAt(i), this.type);
            }
            ++i;
        }
    }

    public void setLast(boolean l) {
        this.last = l;
    }

    public VarDecl(List<String> names, Type type, ErrorType errorType) {
        this.names = new Vector<String>(names);
        this.type = type;
        this.errorType = errorType;
        if (errorType == ErrorType.NONE && type == null) {
            this.errorType = ErrorType.TYPE;
        }
        this.last = true;
    }

    public ProgramLine getLine(int indent) {
        return new DeclLine(indent);
    }

    private String getErrorStr() {
        if (this.errorType == ErrorType.NAME) {
            return "Hi\u00e1nyzik a k\u00f6vetkez\u0151 v\u00e1ltoz\u00f3 azonos\u00edt\u00f3ja.";
        }
        if (this.errorType == ErrorType.COLON) {
            return "Hi\u00e1nyzik a v\u00e1ltoz\u00f3k ut\u00e1n a kett\u0151spont.";
        }
        if (this.errorType == ErrorType.TYPE) {
            return "Hib\u00e1s a t\u00edpus megad\u00e1sa.";
        }
        if (this.errorType == ErrorType.DUP_NAME) {
            return "Ilyen nev\u0171 v\u00e1ltoz\u00f3 m\u00e1r l\u00e9tezik.";
        }
        return null;
    }

    final class DeclLine
    extends ProgramLine {
        DeclLine(int ind) {
            super(ind, VarDecl.this.getErrorStr());
        }

        @Override
        protected String render() {
            Iterator i = VarDecl.this.names.iterator();
            if (!i.hasNext()) {
                return ProgramLine.bad("???");
            }
            int ind = 0;
            String str = String.valueOf(this.indent()) + (ind == VarDecl.this.errIndex ? ProgramLine.bad((String)i.next()) : (String)i.next());
            while (i.hasNext()) {
                str = String.valueOf(str) + ", " + (++ind == VarDecl.this.errIndex ? ProgramLine.bad((String)i.next()) : (String)i.next());
            }
            if (VarDecl.this.errorType == ErrorType.NAME) {
                return String.valueOf(str) + ", " + ProgramLine.bad("???");
            }
            if (VarDecl.this.errorType == ErrorType.COLON) {
                return ProgramLine.bad(":");
            }
            if (VarDecl.this.errorType == ErrorType.TYPE) {
                return String.valueOf(str) + ": " + ProgramLine.bad("???");
            }
            return String.valueOf(str) + ": " + VarDecl.this.type.render() + (VarDecl.this.last ? "" : ",");
        }

        @Override
        public ExprNode getExpr(State state) {
            return ExprNode.EMPTY;
        }

        @Override
        public void setLine(int l) {
        }
    }

    private static enum ErrorType {
        NONE,
        NAME,
        COLON,
        TYPE,
        DUP_NAME;

    }
}

