/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.State;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

class UnparsedLines {
    private Vector<String> lines;

    private UnparsedLines(List<String> lines) {
        this.lines = new Vector<String>(lines);
    }

    static UnparsedLines skip(Lexer lex, String limit) {
        LinkedList<String> lines = new LinkedList<String>();
        while (!(lex.isEof() || limit != null && lex.isKeyword(limit))) {
            lines.add(lex.skip());
        }
        return new UnparsedLines(lines);
    }

    List<ProgramLine> getLines(int indent) {
        LinkedList<ProgramLine> l = new LinkedList<ProgramLine>();
        int i = 0;
        while (i < this.lines.size()) {
            l.add(new UnparsedLine(indent, i));
            ++i;
        }
        return l;
    }

    private final class UnparsedLine
    extends ProgramLine {
        int line;

        UnparsedLine(int ind, int l) {
            super(ind);
            this.line = l;
        }

        @Override
        protected String render() {
            return String.valueOf(this.indent()) + (String)UnparsedLines.this.lines.elementAt(this.line);
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, "---", null);
        }

        @Override
        public void setLine(int l) {
        }
    }
}

