/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Type;
import hu.ppke.itk.plang.prog.UnaryOperator;

class UnOpExpression
extends Expression {
    private Expression expr;
    private UnaryOperator op;
    private ErrorType errorType;

    static UnOpExpression createUnOpExpr(Expression e, UnaryOperator op) {
        if (e.getError() != null) {
            return new UnOpExpression(e, op, ErrorType.ARG);
        }
        Type t = e.getType().operatorType(op);
        if (t == null) {
            return new UnOpExpression(e, op, ErrorType.OPER);
        }
        return new UnOpExpression(e, op, t);
    }

    private UnOpExpression(Expression expr, UnaryOperator op, Type type) {
        super(type);
        this.expr = expr;
        this.op = op;
    }

    private UnOpExpression(Expression expr, UnaryOperator op, ErrorType errorType) {
        super(null);
        this.expr = expr;
        this.op = op;
        this.errorType = errorType;
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.OPER) {
            return ProgramLine.bad(this.op.render(this.expr.render()));
        }
        return this.op.render(this.expr);
    }

    public String toString() {
        return this.op.render(this.expr.toString());
    }

    @Override
    Object getValue(State state) {
        Object val = this.expr.getValue(state);
        if (val instanceof BadValue) {
            return val;
        }
        return this.expr.getType().apply(this.op, val);
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[]{this.expr.getTree(state)};
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.ARG) {
            return this.expr.getError();
        }
        if (this.errorType == ErrorType.OPER) {
            return this.expr.getType() + " t\u00edpuson nincs " + (Object)((Object)this.op) + " m\u0171velet \u00e9rtelmezve.";
        }
        return null;
    }

    private static enum ErrorType {
        NONE,
        ARG,
        OPER;

    }
}

