/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.BadValue;
import hu.ppke.itk.plang.prog.BasicType;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.State;

class SubstringExpression
extends Expression {
    private ErrorType errorType;
    private Expression base;
    private Expression begin;
    private Expression end;

    static SubstringExpression createSubstringExpr(Expression base, Expression begin, Expression end) {
        if (base.getError() != null) {
            return new SubstringExpression(base, begin, end, ErrorType.BASE);
        }
        if (begin.getError() != null) {
            return new SubstringExpression(base, begin, end, ErrorType.BEGIN);
        }
        if (end.getError() != null) {
            return new SubstringExpression(base, begin, end, ErrorType.END);
        }
        if (base.getType() != BasicType.STRING) {
            return new SubstringExpression(base, begin, end, ErrorType.BASETYPE);
        }
        if (begin.getType() != BasicType.INTEGER) {
            return new SubstringExpression(base, begin, end, ErrorType.BEGINTYPE);
        }
        if (end.getType() != BasicType.INTEGER) {
            return new SubstringExpression(base, begin, end, ErrorType.ENDTYPE);
        }
        return new SubstringExpression(base, begin, end, ErrorType.NONE);
    }

    private SubstringExpression(Expression base, Expression begin, Expression end, ErrorType errorType) {
        super(BasicType.STRING);
        this.base = base;
        this.begin = begin;
        this.end = end;
        this.errorType = errorType;
    }

    @Override
    public String getError() {
        if (this.errorType == ErrorType.BASE) {
            return this.base.getError();
        }
        if (this.errorType == ErrorType.BEGIN) {
            return this.begin.getError();
        }
        if (this.errorType == ErrorType.END) {
            return this.end.getError();
        }
        if (this.errorType == ErrorType.BASETYPE) {
            return "A [ : ] m\u0171velet csak a STRING t\u00edpuson \u00e9rtelmezett.";
        }
        if (this.errorType == ErrorType.BEGINTYPE || this.errorType == ErrorType.ENDTYPE) {
            return "A [ : ] m\u0171velet param\u00e9terei csak INTEGER t\u00edpus\u00faak lehetnek.";
        }
        return null;
    }

    @Override
    String render() {
        if (this.errorType == ErrorType.BASETYPE) {
            return String.valueOf(ProgramLine.bad(this.base.render())) + "[" + this.begin.render() + ":" + this.end.render() + "]";
        }
        if (this.errorType == ErrorType.BEGINTYPE) {
            return String.valueOf(this.base.render()) + "[" + ProgramLine.bad(this.begin.render()) + ":" + this.end.render() + "]";
        }
        if (this.errorType == ErrorType.ENDTYPE) {
            return String.valueOf(this.base.render()) + "[" + this.begin.render() + ":" + ProgramLine.bad(this.end.render()) + "]";
        }
        return String.valueOf(this.base.render()) + "[" + this.begin.render() + ":" + this.end.render() + "]";
    }

    public String toString() {
        return this.base + "[" + this.begin + ":" + this.end + "]";
    }

    @Override
    Object getValue(State state) {
        int e;
        Object baseval = this.base.getValue(state);
        if (baseval instanceof BadValue) {
            return baseval;
        }
        Object bval = this.begin.getValue(state);
        if (bval instanceof BadValue) {
            return bval;
        }
        Object eval = this.end.getValue(state);
        if (eval instanceof BadValue) {
            return eval;
        }
        int b = (Integer)bval;
        if (b == (e = ((Integer)eval).intValue())) {
            return "";
        }
        String s = (String)baseval;
        if (b < 0 || b >= s.length()) {
            return new BadValue("Hib\u00e1s kezd\u0151 index");
        }
        if (e < b) {
            return new BadValue("A kezd\u0151 index nagyobb v\u00e9gindexn\u00e9l");
        }
        if (e > s.length()) {
            return new BadValue("Hib\u00e1s v\u00e9gindex");
        }
        return ((String)baseval).substring((Integer)bval, (Integer)eval);
    }

    @Override
    ExprNode[] getChildren(State state) {
        return new ExprNode[]{this.base.getTree(state), this.begin.getTree(state), this.end.getTree(state)};
    }

    private static enum ErrorType {
        NONE,
        BASE,
        BEGIN,
        END,
        BASETYPE,
        BEGINTYPE,
        ENDTYPE;

    }
}

