/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.Declarations;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.ParDecl;
import hu.ppke.itk.plang.prog.Program;
import hu.ppke.itk.plang.prog.Signature;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statements;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubProgram
extends Program {
    private static Map<Kind, Set<String>> termKeyw = new EnumMap<Kind, Set<String>>(Kind.class);
    private Kind kind;
    private Signature signature;
    private ErrorType errorType;
    private Environment env;

    static {
        termKeyw.put(Kind.PROC, new HashSet<String>(Arrays.asList("eljaras_vege", "program_vege")));
        termKeyw.put(Kind.FUNC, new HashSet<String>(Arrays.asList("fuggveny_vege", "program_vege")));
    }

    static SubProgram parseSubProgram(Lexer lex, Environment env) {
        Kind kind;
        if (lex.isKeyword("eljaras")) {
            kind = Kind.PROC;
        } else if (lex.isKeyword("fuggveny")) {
            kind = Kind.FUNC;
        } else {
            return null;
        }
        lex.next();
        if (!lex.isIdent()) {
            return new SubProgram(kind, ErrorType.NAME);
        }
        String name = lex.getString();
        lex.next();
        Environment subEnv = new Environment(env);
        Signature sig = Signature.parseSignature(kind, lex, subEnv);
        Declarations decls = Declarations.parseDecl(lex, subEnv);
        Statements stmts = Statements.parseStmt(lex, subEnv, termKeyw.get((Object)kind));
        if (kind == Kind.PROC && !lex.isKeyword("eljaras_vege") || kind == Kind.FUNC && !lex.isKeyword("fuggveny_vege")) {
            return new SubProgram(kind, name, sig, decls, stmts, ErrorType.TAIL);
        }
        lex.next();
        SubProgram sp = new SubProgram(kind, name, sig, decls, stmts, subEnv, ErrorType.NONE);
        sp.apply(env);
        return sp;
    }

    private SubProgram(Kind kind, String name, Signature sig, Declarations decl, Statements stmts, Environment env, ErrorType errType) {
        super(name, decl, stmts, env);
        this.signature = sig;
        this.kind = kind;
        this.env = env;
        this.errorType = errType;
        if (this.errorType == ErrorType.NONE && stmts.hasError()) {
            this.errorType = ErrorType.BODY;
        }
    }

    private SubProgram(Kind kind, ErrorType errorType) {
        this(kind, null, null, null, null, null, errorType);
    }

    private SubProgram(Kind kind, String name, Signature sig, Declarations decls, Statements stmts, ErrorType errorType) {
        this(kind, name, sig, decls, stmts, null, errorType);
    }

    public List<State> runProgram(State parent, Object[] param) {
        State state = new State(this.env, parent);
        int i = 0;
        while (i < this.signature.getParCount()) {
            ParDecl par = this.signature.getPar(i);
            if (par.getKind() == ParDecl.Kind.INPUT) {
                state.setVar(par.getName(), param[i]);
            }
            ++i;
        }
        List<State> lst = super.runProgram(state);
        State last = lst.get(lst.size() - 1);
        int i2 = 0;
        while (i2 < this.signature.getParCount()) {
            ParDecl par = this.signature.getPar(i2);
            if (par.getKind() == ParDecl.Kind.OUTPUT) {
                param[i2] = last.getVar(par.getName());
            }
            ++i2;
        }
        for (String stn : parent.getStreamNames()) {
            parent.getStreamState(stn).advanceTo(last.getStreamState(stn).getPtr());
        }
        return lst;
    }

    private String headError() {
        if (this.errorType == ErrorType.NAME) {
            return "Hi\u00e1nyzik az alprogram neve.";
        }
        return null;
    }

    @Override
    protected ProgramLine getHeadLine(int indent) {
        return new SubProgHead(indent);
    }

    private String tailError() {
        if (this.errorType == ErrorType.TAIL) {
            return "Hi\u00e1nyzik " + (this.kind == Kind.PROC ? "az ELJ\u00c1R\u00c1S_V\u00c9GE" : "a F\u00dcGGV\u00c9NY_V\u00c9GE") + " kulcssz\u00f3.";
        }
        return null;
    }

    @Override
    protected ProgramLine getTailLine(int indent) {
        return new SubProgTail(indent);
    }

    @Override
    public boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    private void apply(Environment env) {
        env.addSubProg(this);
    }

    int getParamCount() {
        return this.signature.getParCount();
    }

    ParDecl getParam(int index) {
        return this.signature.getPar(index);
    }

    private static enum ErrorType {
        NONE,
        BODY,
        NAME,
        TAIL,
        PARAM,
        RETURN,
        OPAREN;

    }

    static enum Kind {
        PROC,
        FUNC;

    }

    private class SubProgHead
    extends ProgramLine {
        SubProgHead(int indent) {
            super(indent, SubProgram.this.headError());
        }

        @Override
        protected String render() {
            String kwd;
            String string = kwd = SubProgram.this.kind == Kind.PROC ? "ELJ\u00c1R\u00c1S " : "F\u00dcGGV\u00c9NY ";
            if (SubProgram.this.errorType == ErrorType.NAME) {
                return String.valueOf(this.indent()) + kwd + SubProgHead.bad("???");
            }
            return String.valueOf(this.indent()) + kwd + SubProgram.this.getName() + SubProgram.this.signature.render();
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, "---", null);
        }

        @Override
        public void setLine(int l) {
        }
    }

    private class SubProgTail
    extends ProgramLine {
        SubProgTail(int indent) {
            super(indent, SubProgram.this.tailError());
        }

        @Override
        protected String render() {
            String kwd;
            String string = kwd = SubProgram.this.kind == Kind.PROC ? "ELJ\u00c1R\u00c1S_V\u00c9GE" : "F\u00dcGGV\u00c9NY_V\u00c9GE";
            if (SubProgram.this.errorType == ErrorType.TAIL) {
                return String.valueOf(this.indent()) + SubProgTail.bad(kwd);
            }
            return String.valueOf(this.indent()) + kwd;
        }

        @Override
        public ExprNode getExpr(State state) {
            return new ExprNode(null, state == null ? "---" : "Az alprogram v\u00e9get \u00e9rt.", null);
        }

        @Override
        public void setLine(int l) {
            SubProgram.this.setEndLine(l);
        }
    }
}

