/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.prog.StreamKind;
import hu.ppke.itk.plang.prog.StreamState;

public class StreamData {
    private StringBuffer content;
    private StreamKind kind;

    public StreamData(StreamKind kind) {
        this.kind = kind;
        this.content = new StringBuffer();
    }

    void addContent(String data) {
        this.content.append(data);
    }

    public String getContent() {
        return this.content.toString();
    }

    public StreamKind getKind() {
        return this.kind;
    }

    public void append(StreamState st, String str) {
        if (st.getPtr() < this.content.length()) {
            st.advance(this.content.length() - st.getPtr());
        }
        this.content.append(str);
        st.advance(str.length());
    }

    public String getSection(int start, int end) {
        return this.content.substring(start, end);
    }

    public int getLength() {
        return this.content.length();
    }

    private void skipWS(StreamState sst) {
        while (sst.getPtr() < this.content.length()) {
            char c = this.content.charAt(sst.getPtr());
            if (c != ' ' && c != '\n' && c != '\t') break;
            sst.advance(1);
        }
    }

    private String getNumber(StreamState sst) throws DataError {
        if (sst.getPtr() >= this.content.length() || this.content.charAt(sst.getPtr()) < '0' || this.content.charAt(sst.getPtr()) > '9') {
            throw new DataError();
        }
        String num = "";
        while (sst.getPtr() < this.content.length()) {
            char c = this.content.charAt(sst.getPtr());
            if (c < '0' || c > '9') break;
            num = String.valueOf(num) + c;
            sst.advance(1);
        }
        return num;
    }

    int readInteger(StreamState sst) throws DataError {
        String num = "";
        this.skipWS(sst);
        if (sst.getPtr() < this.content.length() && this.content.charAt(sst.getPtr()) == '-') {
            num = "-";
            sst.advance(1);
        }
        num = String.valueOf(num) + this.getNumber(sst);
        return Integer.valueOf(num);
    }

    double readReal(StreamState sst) throws DataError {
        String num = "";
        this.skipWS(sst);
        if (sst.getPtr() < this.content.length() && this.content.charAt(sst.getPtr()) == '-') {
            num = "-";
            sst.advance(1);
        }
        num = String.valueOf(num) + this.getNumber(sst);
        if (sst.getPtr() < this.content.length() && this.content.charAt(sst.getPtr()) == '.') {
            num = String.valueOf(num) + ".";
            sst.advance(1);
            num = String.valueOf(num) + this.getNumber(sst);
        }
        return Double.valueOf(num);
    }

    String readString(StreamState sst) throws DataError {
        if (sst.getPtr() >= this.content.length()) {
            throw new DataError();
        }
        StringBuffer s = new StringBuffer("");
        while (sst.getPtr() < this.content.length()) {
            char c = this.content.charAt(sst.getPtr());
            sst.advance(1);
            if (c == '\n') break;
            s.append(c);
        }
        return s.toString();
    }

    Object readChar(StreamState sst) throws DataError {
        if (sst.getPtr() >= this.content.length()) {
            throw new DataError();
        }
        char c = this.content.charAt(sst.getPtr());
        sst.advance(1);
        return Character.valueOf(c);
    }

    boolean readBoolean(StreamState sst) throws DataError {
        this.skipWS(sst);
        if (sst.getPtr() >= this.content.length()) {
            throw new DataError();
        }
        char c = this.content.charAt(sst.getPtr());
        switch (c) {
            case 'I': 
            case 'Y': 
            case 'i': 
            case 'y': {
                sst.advance(1);
                return true;
            }
            case 'H': 
            case 'N': 
            case 'h': 
            case 'n': {
                sst.advance(1);
                return false;
            }
        }
        throw new DataError();
    }

    public static class DataError
    extends Exception {
    }
}

