/*
 * Decompiled with CFR 0.152.
 */
package hu.ppke.itk.plang.prog;

import hu.ppke.itk.plang.gui.ExprNode;
import hu.ppke.itk.plang.gui.ProgramLine;
import hu.ppke.itk.plang.prog.AssignableExpr;
import hu.ppke.itk.plang.prog.Assignment;
import hu.ppke.itk.plang.prog.CallStatement;
import hu.ppke.itk.plang.prog.CloseStatement;
import hu.ppke.itk.plang.prog.CommentStatement;
import hu.ppke.itk.plang.prog.Conditional;
import hu.ppke.itk.plang.prog.Environment;
import hu.ppke.itk.plang.prog.Expression;
import hu.ppke.itk.plang.prog.Lexer;
import hu.ppke.itk.plang.prog.Loop;
import hu.ppke.itk.plang.prog.OpenStatement;
import hu.ppke.itk.plang.prog.PrintStmt;
import hu.ppke.itk.plang.prog.ReadStmt;
import hu.ppke.itk.plang.prog.State;
import hu.ppke.itk.plang.prog.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

class Statements {
    private Vector<Statement> stmts;
    private ErrorType errorType = ErrorType.NONE;

    static Statements parseStmt(Lexer lex, Environment env, Set<String> termKeyw) {
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        do {
            if (lex.isKeyword(",")) {
                lex.next();
            }
            if (lex.isIdent()) {
                String ident = lex.getString();
                lex.next();
                if (lex.isKeyword("(")) {
                    stmts.add(CallStatement.parseCallStmt(ident, lex, env));
                    continue;
                }
                AssignableExpr lhs = AssignableExpr.parseAssignable(ident, lex, env);
                if (!lex.isKeyword(":=")) {
                    stmts.add(new UnparsedStatement(lhs.toString(), "Az \u00e9rt\u00e9kad\u00f3 utas\u00edt\u00e1s := jele hi\u00e1nyzik.", lex));
                    continue;
                }
                lex.next();
                Expression expr = Expression.parseExpression(lex, env);
                stmts.add(new Assignment(lhs, expr, env));
                continue;
            }
            if (lex.isKeyword("ha")) {
                lex.next();
                stmts.add(Conditional.parseCondStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("ciklus")) {
                lex.next();
                stmts.add(Loop.parseLoopStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("ki")) {
                lex.next();
                stmts.add(PrintStmt.parsePrintStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("be")) {
                lex.next();
                stmts.add(ReadStmt.parseReadStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("megnyit")) {
                lex.next();
                stmts.add(OpenStatement.parseOpenStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("lezar")) {
                lex.next();
                stmts.add(CloseStatement.parseCloseStmt(lex, env));
                continue;
            }
            if (lex.isKeyword("**")) {
                lex.next();
                stmts.add(CommentStatement.parseComment(lex, env));
                continue;
            }
            if (lex.isKeyword(termKeyw)) break;
            stmts.add(new UnparsedStatement("", "Ebben a sorban nincs felismerhet\u0151 utas\u00edt\u00e1s.", lex));
        } while (!lex.isEof());
        return new Statements(stmts);
    }

    private Statements(List<Statement> stmts) {
        this.stmts = new Vector<Statement>(stmts);
        if (stmts.isEmpty()) {
            this.errorType = ErrorType.EMPTY;
        } else {
            if (this.stmts.firstElement().hasError()) {
                this.errorType = ErrorType.STMT;
            } else {
                int i = 1;
                while (i < this.stmts.size()) {
                    if (this.stmts.get(i).hasError()) {
                        this.errorType = ErrorType.STMT;
                        break;
                    }
                    this.stmts.get(i - 1).setNext(this.stmts.get(i));
                    ++i;
                }
            }
            if (this.errorType == ErrorType.NONE) {
                this.stmts.elementAt(stmts.size() - 1).setNext(null);
            }
        }
    }

    boolean hasError() {
        return this.errorType != ErrorType.NONE;
    }

    public List<ProgramLine> getLines(int indent) {
        if (this.errorType == ErrorType.EMPTY) {
            Vector<ProgramLine> v = new Vector<ProgramLine>(1);
            v.add(new ProgramLine(indent, "Err\u0151l a helyr\u0151l hi\u00e1nyoznak az utas\u00edt\u00e1sok."){

                @Override
                protected String render() {
                    return String.valueOf(this.indent()) + 1.bad("???");
                }

                @Override
                public void setLine(int l) {
                }

                @Override
                public ExprNode getExpr(State state) {
                    return null;
                }
            });
            return v;
        }
        LinkedList<ProgramLine> l = new LinkedList<ProgramLine>();
        for (Statement s : this.stmts) {
            l.addAll(s.getLines(indent));
        }
        return l;
    }

    public Statement getFirst() {
        return this.stmts.firstElement();
    }

    public Statement getLast() {
        return this.stmts.lastElement();
    }

    private static enum ErrorType {
        NONE,
        EMPTY,
        STMT;

    }

    private static class UnparsedStatement
    extends Statement {
        String parsed;
        String rest;
        String error;

        UnparsedStatement(String line, String error, Lexer lex) {
            this.parsed = line;
            this.error = error;
            this.rest = lex.skip();
        }

        @Override
        List<ProgramLine> getLines(int indent) {
            return UnparsedStatement.oneLine(new ProgramLine(indent, this.error){

                @Override
                protected String render() {
                    return String.valueOf(this.indent()) + 1.bad(String.valueOf(UnparsedStatement.this.parsed) + (UnparsedStatement.this.parsed.isEmpty() ? "" : " ") + UnparsedStatement.this.rest);
                }

                @Override
                public ExprNode getExpr(State state) {
                    return new ExprNode(null, String.valueOf(UnparsedStatement.this.parsed) + " " + UnparsedStatement.this.rest, null);
                }

                @Override
                public void setLine(int l) {
                }
            });
        }

        @Override
        State execute(State state) {
            return state;
        }

        @Override
        boolean hasError() {
            return true;
        }
    }
}

